/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import de.uni_bremen.st.cyclone.util.math.Vector2D;
import java.awt.geom.Line2D;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class DirectedEdge
extends Edge {
    public static final double arrowLength = 10.0;

    public DirectedEdge(Node start, Node end, double weight) {
        super(start, end, weight);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DirectedEdge)) {
            return false;
        }
        DirectedEdge e = (DirectedEdge)o;
        return this.getStart().equals(e.getStart()) && this.getEnd().equals(e.getEnd());
    }

    @Override
    public void paint(GC gc, boolean active) {
        super.paint(gc, active);
        Node start = this.getStart();
        Node end = this.getEnd();
        Line2D.Double line = new Line2D.Double(start.getCenterX(), start.getCenterY(), end.getCenterX(), end.getCenterY());
        Point p = end.getIntersectionPoint(line);
        if (p != null) {
            Vector2D vEnd = new Vector2D(end.getCenterX(), end.getCenterY());
            Vector2D vP = new Vector2D(p.x, p.y);
            Vector2D direction = vEnd.minus(vP);
            Vector2D right = direction.rotate(2.827433388230814).normalize().multiply(10.0).plus(vP);
            Vector2D left = direction.rotate(-2.827433388230814).normalize().multiply(10.0).plus(vP);
            int[] points = new int[]{(int)vP.getX(), (int)vP.getY(), (int)right.getX(), (int)right.getY(), (int)left.getX(), (int)left.getY()};
            gc.fillPolygon(points);
        }
    }
}

