/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.ui.graph.Node;
import java.awt.geom.Line2D;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class Edge {
    private Node start;
    private Node end;
    private double weight;

    public Edge(Node start, Node end, double weight) {
        assert (start.getID() != end.getID());
        this.start = start;
        this.end = end;
        this.weight = weight;
        this.start.registerEdge(this);
        this.end.registerEdge(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        return this.start.equals(e.getStart()) && this.end.equals(e.getEnd()) || this.start.equals(e.getEnd()) && this.end.equals(e.getStart());
    }

    public int hashCode() {
        return this.start.getID() + this.end.getID();
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public Line2D.Double getLine() {
        return new Line2D.Double(this.start.getCenterX(), this.start.getCenterY(), this.end.getCenterX(), this.end.getCenterY());
    }

    public double getWeight() {
        return this.weight;
    }

    public void paint(GC gc, boolean active) {
        int value = 230 - (int)(230.0 * this.weight);
        if (active) {
            gc.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 235));
            gc.setBackground(new Color((Device)Display.getCurrent(), 0, 0, 235));
        } else {
            if (value < 0 || value > 255) {
                System.err.println("Wrong color: " + value);
            }
            gc.setForeground(new Color((Device)Display.getCurrent(), value, value, value));
            gc.setBackground(new Color((Device)Display.getCurrent(), value, value, value));
        }
        gc.drawLine(this.start.getCenterX(), this.start.getCenterY(), this.end.getCenterX(), this.end.getCenterY());
    }
}

