/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Graph {
    private static final long serialVersionUID = 1L;
    protected Set<Node> nodes = new HashSet<Node>();
    protected Set<Edge> edges = new HashSet<Edge>();
    private List<Graph> connectedComponents = new ArrayList<Graph>();

    public void addEdge(Edge e) {
        this.edges.add(e);
    }

    public void addNode(Node n) {
        this.nodes.add(n);
    }

    public void calculateConnectedComponents() {
        HashSet<Node> processed = new HashSet<Node>();
        for (Node n : this.nodes) {
            this.addToConnectedComponent(null, n, processed);
        }
        Collections.sort(this.connectedComponents, new Comparator<Graph>(){

            @Override
            public int compare(Graph a, Graph b) {
                return Integer.valueOf(b.getNodes().size()).compareTo(a.getNodes().size());
            }
        });
        Console.message(this.connectedComponents.size() + " connected components, largest with " + this.connectedComponents.get(0).getNodes().size() + " nodes");
    }

    public List<Graph> getConnectedComponents() {
        return this.connectedComponents;
    }

    public int getIntersections() {
        int intersections = 0;
        ArrayList<Edge> es = new ArrayList<Edge>(this.edges);
        for (int i = 0; i < es.size() - 1; ++i) {
            for (int j = i + 1; j < es.size(); ++j) {
                Line2D.Double l2;
                Line2D.Double l1 = es.get(i).getLine();
                if (!l1.intersectsLine(l2 = es.get(j).getLine()) || ((Line2D)l1).getP1().equals(((Line2D)l2).getP1()) || ((Line2D)l1).getP1().equals(((Line2D)l2).getP2()) || ((Line2D)l1).getP2().equals(((Line2D)l2).getP1()) || ((Line2D)l1).getP2().equals(((Line2D)l2).getP2())) continue;
                ++intersections;
            }
        }
        return intersections;
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    private void addToConnectedComponent(Graph g, Node n, Set<Node> processed) {
        if (processed.contains(n)) {
            return;
        }
        processed.add(n);
        if (g == null) {
            g = new Graph();
            this.connectedComponents.add(g);
        }
        g.addNode(n);
        for (Edge e : n.getEdges()) {
            g.addEdge(e);
            Node m = e.getStart().equals(n) ? e.getEnd() : e.getStart();
            if (processed.contains(m)) continue;
            this.addToConnectedComponent(g, m, processed);
        }
    }
}

