/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.ProgressListener;
import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.util.Worker;
import java.util.LinkedList;

public abstract class GraphGenerator
implements Worker {
    private boolean cancelled = false;
    private String name;
    private LinkedList<ProgressListener> pListeners;
    private CloneEvolutionGraph ceg = null;
    private Graph graph = null;

    public GraphGenerator(String name) {
        this.name = name;
        this.pListeners = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public Graph getGraph(CloneEvolutionGraph ceg) {
        return this.graph;
    }

    @Override
    public void addProgressListener(ProgressListener pl) {
        this.pListeners.add(pl);
    }

    public void clearProgressListeners() {
        this.pListeners.clear();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    private void fireEnd() {
        for (ProgressListener pl : this.pListeners) {
            if (this.cancelled) {
                pl.cancelled();
                continue;
            }
            pl.finished();
        }
    }

    public void setCEG(CloneEvolutionGraph ceg) {
        this.cancelled = false;
        this.ceg = ceg;
    }

    @Override
    public void run() {
        this.graph = this.generateGraph(this.ceg);
        this.fireEnd();
    }

    protected void fireProgressMade(double percent) {
        for (ProgressListener pl : this.pListeners) {
            pl.progressMade(percent);
        }
    }

    protected abstract Graph generateGraph(CloneEvolutionGraph var1);
}

