/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.FragmentSelectionListener;
import de.uni_bremen.st.cyclone.ui.Console;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class GraphPanel
extends ScrolledComposite
implements FragmentSelectionListener,
ClassSelectionListener,
CloneEvolutionGraphListener,
MouseListener,
MouseMoveListener {
    protected final Color COLOR_DEFAULT = this.getDisplay().getSystemColor(2);
    protected final Color COLOR_BACKGROUND = this.getDisplay().getSystemColor(1);
    protected Canvas canvas = new Canvas((Composite)this, 0);
    protected int zoom = 2;
    protected CloneEvolutionGraph ceg;

    public GraphPanel(Composite owner) {
        super(owner, 768);
        this.canvas.setBackground(this.COLOR_BACKGROUND);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GraphPanel.this.paint(event.gc);
            }
        });
        this.setContent((Control)this.canvas);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
    }

    public void increaseZoom() {
        this.zoom = this.zoom == 10 ? this.zoom : this.zoom + 1;
        this.calculatePositions();
        Console.debug("Increase zoom");
    }

    public void decreaseZoom() {
        this.zoom = this.zoom == 1 ? this.zoom : this.zoom - 1;
        this.calculatePositions();
        Console.debug("Decrease zoom");
    }

    public void paint(GC gc) {
        Rectangle rect = new Rectangle(this.getOrigin().x, this.getOrigin().y, this.getClientArea().width, this.getClientArea().height);
        Rectangle clip = gc.getClipping();
        if (clip.width < rect.width || clip.height < rect.height) {
            this.canvas.redraw();
        } else {
            gc.setBackground(this.COLOR_BACKGROUND);
            gc.fillRectangle(rect);
            this.paint(rect, gc);
        }
    }

    protected abstract void paint(Rectangle var1, GC var2);

    protected abstract void calculatePositions();
}

