/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.SourceContext;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.graph.DirectedEdge;
import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import de.uni_bremen.st.cyclone.ui.graph.SingleVersionGraphGenerator;
import de.uni_bremen.st.cyclone.util.Pair;
import edu.tum.cs.scanner.ELanguage;
import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.IToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportGraph
extends SingleVersionGraphGenerator {
    private boolean multipleBasepaths = true;
    private HashMap<String, Pair<SourceContext, Node>> fileNodes;
    private HashMap<String, ArrayList<String>> dirs;
    private HashSet<String> basePaths;
    private Graph graph;

    public ImportGraph() {
        super("Import/Include");
    }

    @Override
    public Graph generateGraph(CloneEvolutionGraph ceg) {
        this.fileNodes = new HashMap();
        this.dirs = new HashMap();
        this.basePaths = new HashSet();
        this.graph = new Graph();
        ELanguage lang = null;
        int fC = 0;
        Set<SourceFile> sourceFiles = ceg.getVersions().get(this.getVersionNumber()).getSource().getSourceFiles();
        int numFiles = sourceFiles.size() * 2;
        for (SourceFile sourceFile : sourceFiles) {
            this.fireProgressMade((double)fC / (double)numFiles);
            if (this.isCancelled()) {
                return null;
            }
            ++fC;
            Node n = new Node(sourceFile);
            this.graph.addNode(n);
            SourceContext sc = new SourceContext(sourceFile);
            if (!sc.isValid()) continue;
            if (lang == null) {
                lang = ImportGraph.determineLanguage(sc);
            }
            String filename = sc.getSourceFile().getName();
            if (lang.equals((Object)ELanguage.ADA)) {
                filename = filename.toLowerCase();
            }
            this.fileNodes.put(filename, new Pair<SourceContext, Node>(sc, n));
            String dir = ImportGraph.getDir(filename);
            ArrayList<String> l = this.dirs.get(dir);
            if (l == null) {
                l = new ArrayList();
                this.dirs.put(dir, l);
            }
            l.add(filename);
            if (!this.multipleBasepaths || lang == null || !lang.equals((Object)ELanguage.JAVA)) continue;
            this.basePaths.add(ImportGraph.getBasePath(lang, sc));
        }
        if (lang == null) {
            Console.error("Cannot determine Language of Source!");
            return this.graph;
        }
        Console.debug("Language is: " + lang);
        for (Pair pair : this.fileNodes.values()) {
            this.fireProgressMade((double)fC / (double)numFiles);
            if (this.isCancelled()) {
                return null;
            }
            ++fC;
            SourceContext sc = (SourceContext)pair.first;
            Node n = (Node)pair.second;
            ArrayList<String> includedFiles = this.getIncludedFiles(lang, sc);
            for (String incFile : includedFiles) {
                if (this.multipleBasepaths && lang != null && lang.equals((Object)ELanguage.JAVA)) {
                    for (String basepath : this.basePaths) {
                        this.searchAndInsert(n, basepath + incFile);
                    }
                    continue;
                }
                String basepath = ImportGraph.getBasePath(lang, sc);
                this.searchAndInsert(n, basepath + incFile);
            }
        }
        for (Node node : this.graph.getNodes()) {
            if (this.isCancelled()) {
                return null;
            }
            int in = 0;
            int out = 0;
            for (Edge e : node.getEdges()) {
                if (e.getStart().equals(node)) {
                    ++out;
                    continue;
                }
                ++in;
            }
            node.setValue(in + "|" + out);
        }
        return this.graph;
    }

    private void searchAndInsert(Node n, String filename) {
        if (filename.endsWith("*")) {
            String dir = ImportGraph.getDir(filename);
            ArrayList<String> l = this.dirs.get(dir);
            if (l != null) {
                for (String f : l) {
                    this.searchAndInsert(n, f);
                }
            }
        } else {
            Pair<SourceContext, Node> found = this.fileNodes.get(filename);
            if (found != null) {
                this.graph.addEdge(new DirectedEdge(n, (Node)found.second, 1.0));
            }
        }
    }

    private static String getDir(String filename) {
        int i = filename.lastIndexOf(File.separatorChar);
        if (i < 0) {
            return "";
        }
        String d = filename.substring(0, i);
        int j = d.indexOf(File.separatorChar);
        if (j < 0) {
            return d;
        }
        return filename.substring(j + 1, i);
    }

    private static ELanguage determineLanguage(SourceContext sc) {
        ELanguage l = null;
        List<IToken> tkns = sc.getFileTokens();
        if (tkns.size() > 0) {
            l = tkns.get(0).getLanguage();
        }
        return l;
    }

    private static String getPackageJava(SourceContext sc) {
        StringBuilder sb = new StringBuilder();
        boolean packageSeen = false;
        for (IToken t : sc.getFileTokens()) {
            switch (t.getType()) {
                case CLASS: {
                    return null;
                }
                case PACKAGE: {
                    packageSeen = true;
                    break;
                }
                case SEMICOLON: {
                    if (packageSeen) {
                        return sb.toString().replace(".", "/");
                    }
                }
                case IDENTIFIER: 
                case DOT: {
                    if (!packageSeen) break;
                    sb.append(t.getText());
                }
            }
        }
        return null;
    }

    private static String getPackageAda(SourceContext sc) {
        StringBuilder sb = new StringBuilder();
        boolean packageSeen = false;
        for (IToken t : sc.getFileTokens()) {
            switch (t.getType()) {
                case PACKAGE: {
                    packageSeen = true;
                    break;
                }
                case IS: {
                    if (packageSeen) {
                        return sb.toString().replace(".", "-");
                    }
                }
                case IDENTIFIER: 
                case DOT: {
                    if (!packageSeen) break;
                    sb.append(t.getText());
                }
            }
        }
        return null;
    }

    private static String getBasePath(ELanguage lang, SourceContext sc) {
        String basepath = "";
        String filename = sc.getSourceFile().getName();
        String pkg = null;
        switch (lang) {
            case JAVA: {
                pkg = ImportGraph.getPackageJava(sc);
                break;
            }
            case ADA: {
                pkg = ImportGraph.getPackageAda(sc);
                break;
            }
        }
        if (pkg != null) {
            assert (pkg.length() <= filename.length());
            Pattern p = Pattern.compile(pkg);
            Matcher m = p.matcher(filename);
            if (m.find()) {
                basepath = filename.substring(0, m.start());
            }
        } else {
            int idx = filename.lastIndexOf(File.separatorChar);
            if (idx >= 0) {
                basepath = filename.substring(0, idx + 1);
            }
        }
        return basepath;
    }

    private static void addCPPInclude(HashSet<String> includedFiles, Vector<IToken> selectedTokens) {
        assert (selectedTokens.size() >= 2);
        selectedTokens.removeElementAt(0);
        if (selectedTokens.size() == 1) {
            String text = selectedTokens.firstElement().getText();
            assert (text.length() < 2 || text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"');
            includedFiles.add(text.substring(1, text.length() - 1));
        } else {
            assert (selectedTokens.size() >= 2);
            selectedTokens.removeElementAt(0);
            selectedTokens.removeElementAt(selectedTokens.size() - 1);
            StringBuilder sb = new StringBuilder();
            for (IToken t : selectedTokens) {
                assert (t.getType().equals((Object)ETokenType.IDENTIFIER) || t.getType().equals((Object)ETokenType.DOT));
                sb.append(t.getText());
            }
            includedFiles.add(sb.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<String> getIncludedFiles(ELanguage lang, SourceContext sc) {
        HashSet<String> includedFiles = new HashSet<String>();
        Vector<IToken> selectedTokens = new Vector<IToken>();
        if (lang.equals((Object)ELanguage.JAVA) || lang.equals((Object)ELanguage.ADA)) {
            Iterator<IToken> i$ = sc.getFileTokens().iterator();
            block13: while (i$.hasNext()) {
                IToken t = i$.next();
                switch (t.getType()) {
                    case CLASS: 
                    case PROCEDURE: {
                        return new ArrayList<String>(includedFiles);
                    }
                    case IMPORT: 
                    case WITH: {
                        selectedTokens.add(t);
                        continue block13;
                    }
                    case IDENTIFIER: 
                    case DOT: 
                    case COMMA: 
                    case MULT: {
                        if (selectedTokens.size() <= 0) continue block13;
                        selectedTokens.add(t);
                        continue block13;
                    }
                    case SEMICOLON: {
                        String filename;
                        if (selectedTokens.size() <= 1) break;
                        StringBuilder sb = new StringBuilder();
                        selectedTokens.removeElementAt(0);
                        for (IToken st : selectedTokens) {
                            sb.append(st.getText());
                        }
                        if (lang.equals((Object)ELanguage.JAVA)) {
                            filename = sb.toString().replace(".", "/");
                            if (filename.length() > 0 && filename.charAt(filename.length() - 1) == '*') {
                                includedFiles.add(filename);
                                break;
                            }
                            includedFiles.add(filename + ".java");
                            break;
                        }
                        if (!lang.equals((Object)ELanguage.ADA)) break;
                        filename = sb.toString().replace(".", "-");
                        for (String s : filename.split(",")) {
                            includedFiles.add(s.toLowerCase() + ".ads");
                        }
                        break;
                    }
                }
                selectedTokens.clear();
            }
            return new ArrayList<String>(includedFiles);
        }
        if (!lang.equals((Object)ELanguage.CPP)) return new ArrayList<String>(includedFiles);
        Iterator<IToken> i$ = sc.getFileTokens().iterator();
        block16: while (i$.hasNext()) {
            IToken t = i$.next();
            switch (t.getType()) {
                case PREPROCESSOR_DIRECTIVE: {
                    if (t.getText().equals("#include")) {
                        // empty if block
                    }
                    selectedTokens.add(t);
                    continue block16;
                }
                case LT: {
                    if (selectedTokens.size() <= 0) continue block16;
                    selectedTokens.add(t);
                    continue block16;
                }
                case GT: {
                    if (selectedTokens.size() > 2 && ((IToken)selectedTokens.get(1)).getType().equals((Object)ETokenType.LT)) {
                        selectedTokens.add(t);
                        ImportGraph.addCPPInclude(includedFiles, selectedTokens);
                    }
                    selectedTokens.clear();
                    continue block16;
                }
                case STRING_LITERAL: {
                    if (selectedTokens.size() == 1) {
                        selectedTokens.add(t);
                        ImportGraph.addCPPInclude(includedFiles, selectedTokens);
                    }
                    selectedTokens.clear();
                    continue block16;
                }
                case IDENTIFIER: 
                case DOT: 
                case DIV: {
                    if (selectedTokens.size() <= 1 || !((IToken)selectedTokens.get(1)).getType().equals((Object)ETokenType.LT)) break;
                    selectedTokens.add(t);
                    continue block16;
                }
            }
            selectedTokens.clear();
        }
        return new ArrayList<String>(includedFiles);
    }
}

