/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import java.util.HashMap;

public class Individual
extends Graph
implements Comparable<Individual> {
    private int fitness = -1;

    public Individual(Graph g) {
        HashMap<Integer, Node> mapping = new HashMap<Integer, Node>();
        for (Node n : g.getNodes()) {
            Node m = new Node(n);
            this.nodes.add(m);
            mapping.put(m.getID(), m);
        }
        for (Edge e : g.getEdges()) {
            this.edges.add(new Edge((Node)mapping.get(e.getStart().getID()), (Node)mapping.get(e.getEnd().getID()), e.getWeight()));
        }
    }

    public Individual(Individual a, Individual b) {
        Node m;
        HashMap<Integer, Node> mapping = new HashMap<Integer, Node>();
        for (Node n : a.getNodes()) {
            if (!(Math.random() > 0.5)) continue;
            m = new Node(n.getID(), n.getEntity(), n.getBounds().x, n.getBounds().y);
            this.nodes.add(m);
            mapping.put(m.getID(), m);
        }
        for (Node n : b.getNodes()) {
            if (mapping.containsKey(n.getID())) continue;
            m = new Node(n.getID(), n.getEntity(), n.getBounds().x, n.getBounds().y);
            this.nodes.add(m);
            mapping.put(m.getID(), m);
        }
        for (Edge e : a.getEdges()) {
            this.edges.add(new Edge((Node)mapping.get(e.getStart().getID()), (Node)mapping.get(e.getEnd().getID()), e.getWeight()));
        }
    }

    public int getFitness() {
        if (this.fitness < 0) {
            this.calculateFitness();
        }
        return this.fitness;
    }

    private void calculateFitness() {
        this.fitness = this.getIntersections();
    }

    @Override
    public int compareTo(Individual i) {
        return Integer.valueOf(this.getFitness()).compareTo(i.getFitness());
    }
}

