/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.ui.graph.Colors;
import de.uni_bremen.st.cyclone.ui.graph.Edge;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Node {
    private static int nextID = 0;
    private static final long serialVersionUID = 1L;
    private int id;
    private Rectangle2D.Double shape;
    private Entity e;
    private Set<Edge> edges = new HashSet<Edge>();
    private String value = "";

    public Node(Entity e) {
        this.shape = new Rectangle2D.Double(10.0, 10.0, 20.0, 20.0);
        this.id = nextID++;
        this.e = e;
    }

    public Node(Node n) {
        this.shape = new Rectangle2D.Double((int)(Math.random() * 800.0), (int)(Math.random() * 800.0), 20.0, 20.0);
        this.id = n.getID();
        this.e = n.getEntity();
    }

    public void randomPosition() {
        this.shape = new Rectangle2D.Double((int)(Math.random() * 800.0), (int)(Math.random() * 800.0), 20.0, 20.0);
    }

    public Node(int id, Entity e, int x, int y) {
        this.shape = new Rectangle2D.Double(x, y, 20.0, 20.0);
        this.id = id;
        this.e = e;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node n = (Node)o;
        return n.getID() == this.id;
    }

    public int getID() {
        return this.id;
    }

    public int getCenterX() {
        return (int)this.shape.getCenterX();
    }

    public int getCenterY() {
        return (int)this.shape.getCenterY();
    }

    private Point getIntersectionPoint(Line2D l1, Line2D l2) {
        if (!l1.intersectsLine(l2)) {
            return null;
        }
        double denom = (l2.getX2() - l2.getX1()) * (l1.getY2() - l1.getY1()) - (l2.getY2() - l2.getY1()) * (l1.getX2() - l1.getX1());
        double a = l1.getY1() * l1.getX2() - l1.getY2() * l1.getX1();
        double b = l2.getY1() * l2.getX2() - l2.getY2() * l2.getX1();
        double x = (a * (l2.getX1() - l2.getX2()) + b * (l1.getX2() - l1.getX1())) / denom;
        double y = (a * (l2.getY1() - l2.getY2()) + b * (l1.getY2() - l1.getY1())) / denom;
        return new Point((int)x, (int)y);
    }

    private Point getIntersectionPoint(byte r, Point2D p1, Point2D p2) {
        Point p = null;
        Line2D.Double line = new Line2D.Double(p1, p2);
        if ((r & 8) != 0) {
            p = this.getIntersectionPoint(line, new Line2D.Double(this.shape.getMinX(), this.shape.getMaxY(), this.shape.getMinX(), this.shape.getMinY()));
        }
        if (p == null && (r & 4) != 0) {
            p = this.getIntersectionPoint(line, new Line2D.Double(this.shape.getMaxX(), this.shape.getMaxY(), this.shape.getMaxX(), this.shape.getMinY()));
        }
        if (p == null && (r & 2) != 0) {
            p = this.getIntersectionPoint(line, new Line2D.Double(this.shape.getMinX(), this.shape.getMaxY(), this.shape.getMaxX(), this.shape.getMaxY()));
        }
        if (p == null && (r & 1) != 0) {
            p = this.getIntersectionPoint(line, new Line2D.Double(this.shape.getMinX(), this.shape.getMinY(), this.shape.getMaxX(), this.shape.getMinY()));
        }
        return p;
    }

    public Point getIntersectionPoint(Line2D line) {
        double xMin = this.shape.getMinX();
        double xMax = this.shape.getMaxX();
        double yMin = this.shape.getMinY();
        double yMax = this.shape.getMaxY();
        byte r1 = 0;
        if (line.getX1() < xMin) {
            r1 = (byte)(r1 | 8);
        }
        if (line.getX1() > xMax) {
            r1 = (byte)(r1 | 4);
        }
        if (line.getY1() > yMax) {
            r1 = (byte)(r1 | 2);
        }
        if (line.getY1() < yMin) {
            r1 = (byte)(r1 | 1);
        }
        byte r2 = 0;
        if (line.getX2() < xMin) {
            r2 = (byte)(r2 | 8);
        }
        if (line.getX2() > xMax) {
            r2 = (byte)(r2 | 4);
        }
        if (line.getY2() > yMax) {
            r2 = (byte)(r2 | 2);
        }
        if (line.getY2() < yMin) {
            r2 = (byte)(r2 | 1);
        }
        Point p = null;
        if (r1 == 0) {
            p = this.getIntersectionPoint(r2, line.getP1(), line.getP2());
        } else if (r2 == 0) {
            p = this.getIntersectionPoint(r1, line.getP2(), line.getP1());
        }
        return p;
    }

    public Entity getEntity() {
        return this.e;
    }

    public void registerEdge(Edge e) {
        this.edges.add(e);
    }

    public int hashCode() {
        return this.id;
    }

    public void paint(GC gc, boolean active, boolean label) {
        this.paintNode(gc, active);
        if (label) {
            this.paintLabel(gc);
        }
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.shape.x, (int)this.shape.y, (int)this.shape.width, (int)this.shape.height);
    }

    public void setX(int x) {
        this.shape.x = x;
    }

    public void setY(int y) {
        this.shape.y = y;
    }

    public void setWidth(int width) {
        this.shape.width = width;
    }

    public void setHeight(int height) {
        this.shape.height = height;
    }

    public Set<Edge> getEdges() {
        return this.edges;
    }

    public void setCenter(int x, int y) {
        this.shape.x = (double)x - this.shape.width / 2.0;
        this.shape.y = (double)y - this.shape.height / 2.0;
    }

    private void paintLabel(GC gc) {
        int sw = gc.textExtent((String)this.e.getPath()).x;
        int sh = gc.textExtent((String)this.e.getPath()).y;
        int border = 3;
        int offset = (int)(this.shape.width + 5.0);
        gc.setBackground(Colors.HOVER);
        gc.fillRectangle((int)(this.shape.x + (double)offset), (int)(this.shape.y - (double)offset), sw + 4 * border, sh + 2 * border);
        gc.setForeground(Colors.TEXT);
        gc.drawRectangle((int)(this.shape.x + (double)offset), (int)(this.shape.y - (double)offset), sw + 4 * border, sh + 2 * border);
        gc.drawString(this.e.getPath(), (int)(this.shape.x + (double)(2 * border) + (double)offset), (int)(this.shape.y - (double)offset + (double)border));
    }

    private void paintNode(GC gc, boolean active) {
        if (active) {
            gc.setBackground(new Color((Device)Display.getCurrent(), 255 - (int)(255.0 * this.e.getCloneCoverage()), 255 - (int)(255.0 * this.e.getCloneCoverage()), 255));
        } else {
            gc.setBackground(new Color((Device)Display.getCurrent(), 255, 255 - (int)(255.0 * this.e.getCloneCoverage()), 255 - (int)(255.0 * this.e.getCloneCoverage())));
        }
        Rectangle r = new Rectangle((int)this.shape.x, (int)this.shape.y, (int)this.shape.width, (int)this.shape.height);
        gc.fillRectangle(r);
        if (active) {
            gc.setForeground(new Color((Device)Display.getCurrent(), 0, 0, 235));
        } else {
            gc.setForeground(Colors.TEXT);
        }
        gc.drawRectangle(r);
        gc.setForeground(Colors.TEXT);
        gc.drawText("" + this.value, r.x + 3, r.y + 3);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

