/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.ui.graph.Individual;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import java.util.ArrayList;
import java.util.Collections;

public class Population
extends ArrayList<Individual> {
    private static final long serialVersionUID = 1L;
    private final int POPULATION_SIZE = 100;

    public Population(Graph g) {
        for (int i = 0; i < 100; ++i) {
            this.add(new Individual(g));
        }
    }

    public void nextGeneration() {
        ArrayList<Individual> candidates = this.select();
        this.clear();
        this.addAll(candidates);
        ArrayList<Individual> children = this.reproduce(candidates, 100 - candidates.size());
        this.mutate(children);
        this.addAll(children);
    }

    public Individual getBest() {
        Individual best = (Individual)this.get(0);
        for (Individual i : this) {
            if (i.getFitness() >= best.getFitness()) continue;
            best = i;
        }
        return best;
    }

    private void mutate(ArrayList<Individual> individuals) {
        for (Individual i : individuals) {
            for (Node n : i.getNodes()) {
                if (!(Math.random() < 0.1)) continue;
                n.getBounds().x = (int)(Math.random() * 1400.0);
                n.getBounds().y = (int)(Math.random() * 800.0);
            }
        }
    }

    private ArrayList<Individual> select() {
        Collections.sort(this);
        ArrayList<Individual> candidates = new ArrayList<Individual>();
        for (int i = 0; i < 25; ++i) {
            candidates.add((Individual)this.get(i));
        }
        return candidates;
    }

    private ArrayList<Individual> reproduce(ArrayList<Individual> candidates, int amount) {
        ArrayList<Individual> children = new ArrayList<Individual>();
        for (int i = 0; i < amount; ++i) {
            int j = (int)(Math.random() * (double)candidates.size());
            int k = (int)(Math.random() * (double)candidates.size());
            children.add(new Individual(candidates.get(j), candidates.get(k)));
        }
        return children;
    }
}

