/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.graph.CloneGraph;
import de.uni_bremen.st.cyclone.ui.graph.GraphLayoutType;
import de.uni_bremen.st.cyclone.ui.graph.ImportGraph;
import de.uni_bremen.st.cyclone.ui.graph.RelationPanel;
import de.uni_bremen.st.cyclone.ui.graph.SingleVersionGraphGenerator;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class RelationCtrlPanel
extends Composite
implements CloneEvolutionGraphListener,
ClassSelectionListener {
    private static final long serialVersionUID = 0L;
    private Vector<SingleVersionGraphGenerator> graphGenerators;
    private CloneEvolutionGraph ceg;
    private Combo cbGraphGenerator;
    private Combo cbVersions;
    private RelationPanel relationPanel;

    public RelationCtrlPanel(TabItem owner) {
        super((Composite)owner.getParent(), 0);
        owner.setControl((Control)this);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        this.setLayout((Layout)gl);
        this.graphGenerators = new Vector();
        this.graphGenerators.add(new CloneGraph());
        this.graphGenerators.add(new ImportGraph());
        this.cbGraphGenerator = new Combo((Composite)this, 8);
        for (SingleVersionGraphGenerator g : this.graphGenerators) {
            this.cbGraphGenerator.add(g.getName());
        }
        this.cbGraphGenerator.select(0);
        this.cbGraphGenerator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationCtrlPanel.this.generatorChanged();
            }
        });
        this.cbVersions = new Combo((Composite)this, 8);
        this.cbVersions.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cbVersions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationCtrlPanel.this.versionChanged();
            }
        });
        Text tfInfo = new Text((Composite)this, 16388);
        tfInfo.setEditable(false);
        tfInfo.setBackground(this.getBackground());
        tfInfo.setLayoutData((Object)new GridData(772));
        this.relationPanel = new RelationPanel(this, tfInfo);
        this.relationPanel.setLayoutData(new GridData(4, 4, true, true, gl.numColumns, 1));
        this.generatorChanged();
    }

    public void fragmentSelectionChanged(Fragment f) {
        this.relationPanel.fragmentSelectionChanged(f);
    }

    @Override
    public void classSelectionChanged(CloneClass cc) {
        this.relationPanel.classSelectionChanged(cc);
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph ceg) {
        this.ceg = ceg;
        this.cbVersions.removeAll();
        for (Version v : ceg.getVersions()) {
            this.cbVersions.add(v.getID() + " " + v.getPath());
        }
        this.cbVersions.select(0);
        this.relationPanel.cloneEvolutionGraphChanged(ceg);
    }

    public void setLayout(GraphLayoutType l) {
        this.relationPanel.calculatePositions(l);
    }

    public RelationPanel getPanel() {
        return this.relationPanel;
    }

    private void generatorChanged() {
        SingleVersionGraphGenerator svgg = this.graphGenerators.get(this.cbGraphGenerator.getSelectionIndex());
        this.relationPanel.setGraphGenerator(svgg);
        int selectedVersion = this.cbVersions.getSelectionIndex();
        if (selectedVersion > 0) {
            this.cbVersions.select(0);
            this.versionChanged();
        }
    }

    private void versionChanged() {
        if (this.cbVersions.getSelectionIndex() >= 0) {
            SingleVersionGraphGenerator svgg = this.graphGenerators.get(this.cbGraphGenerator.getSelectionIndex());
            svgg.setVersionNumber(this.cbVersions.getSelectionIndex());
            this.relationPanel.cloneEvolutionGraphChanged(this.ceg);
        }
    }
}

