/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.graph;

import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.ui.ProgressDialog;
import de.uni_bremen.st.cyclone.ui.graph.EA;
import de.uni_bremen.st.cyclone.ui.graph.Edge;
import de.uni_bremen.st.cyclone.ui.graph.Graph;
import de.uni_bremen.st.cyclone.ui.graph.GraphGenerator;
import de.uni_bremen.st.cyclone.ui.graph.GraphLayoutType;
import de.uni_bremen.st.cyclone.ui.graph.GraphPanel;
import de.uni_bremen.st.cyclone.ui.graph.Node;
import de.uni_bremen.st.cyclone.util.math.Vector2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class RelationPanel
extends GraphPanel {
    private Graph graph;
    private Node dragNode = null;
    private Node hoverNode = null;
    private Edge hoverEdge = null;
    private Map<Integer, Node> selectedNodes = new HashMap<Integer, Node>();
    private Vector2D dragOffset = null;
    private Point dragPointSource = null;
    private Point dragPointTarget = null;
    private boolean dragging = false;
    private boolean redrawAfterMouseUp = false;
    private Text tfInfo = null;
    private boolean loadedGraph = false;
    private GraphGenerator graphGenerator = null;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 800;

    public RelationPanel(Composite owner, Text tfInfo) {
        super(owner);
        this.tfInfo = tfInfo;
        this.canvas.setSize(2000, 1500);
    }

    private List<Node> getNodesSorted() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.graph.getNodes());
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                return Integer.valueOf(a.getEdges().size()).compareTo(b.getEdges().size());
            }
        });
        return nodes;
    }

    public void calculatePositionsCircle() {
        List<Node> nodes = this.getNodesSorted();
        double angle = 0.0;
        double step = Math.PI * 2 / (double)nodes.size();
        double border = 100.0;
        double radius = 400.0;
        double centerX = border + radius;
        double centerY = border + radius;
        for (Node n : nodes) {
            n.setWidth(10 * this.zoom);
            n.setHeight(10 * this.zoom);
            n.setX((int)(centerX + Math.sin(angle) * radius));
            n.setY((int)(centerY + Math.cos(angle) * radius));
            angle += step;
        }
    }

    @Override
    public void calculatePositions() {
        if (!this.loadedGraph) {
            return;
        }
        this.calculatePositions(GraphLayoutType.CIRCLE);
        this.canvas.redraw();
    }

    public void calculatePositions(GraphLayoutType l) {
        switch (l) {
            case BLOCK: {
                this.calculatePositionsBlock();
                break;
            }
            case EA: {
                this.calculatePositionsEA();
                break;
            }
            case RANDOM: {
                this.calculatePositionsRandom();
                break;
            }
            default: {
                this.calculatePositionsCircle();
            }
        }
    }

    public void calculatePositionsBlock() {
        List<Node> nodes = this.getNodesSorted();
        int x = 100;
        int y = 100;
        int maxHeight = 0;
        for (Node n : nodes) {
            n.setX(x);
            n.setY(y);
            n.setWidth(10 * this.zoom);
            n.setHeight(10 * this.zoom);
            x = x + n.getBounds().width + 10 * this.zoom;
            maxHeight = Math.max(maxHeight, n.getBounds().height);
            if (x <= this.canvas.getSize().x - 100) continue;
            x = 100;
            y = y + maxHeight + 10 * this.zoom;
            maxHeight = 0;
        }
    }

    public void calculatePositionsEA() {
        this.graph = EA.optimize(this.graph);
        for (Node n : this.graph.getNodes()) {
            n.setWidth(10 * this.zoom);
            n.setHeight(10 * this.zoom);
        }
    }

    public void calculatePositionsRandom() {
        for (Node n : this.graph.getNodes()) {
            n.setWidth(10 * this.zoom);
            n.setHeight(10 * this.zoom);
            n.setX((int)(Math.random() * 1400.0));
            n.setY((int)(Math.random() * 800.0));
        }
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph ceg) {
        this.ceg = ceg;
        this.loadedGraph = false;
    }

    public void setGraphGenerator(GraphGenerator gg) {
        this.loadedGraph = this.graphGenerator != null && gg.getName().equals(this.graphGenerator.getName());
        this.graphGenerator = gg;
    }

    private void loadGraph() {
        if (this.loadedGraph || this.ceg == null || this.graphGenerator == null) {
            return;
        }
        this.graphGenerator.clearProgressListeners();
        this.graphGenerator.setCEG(this.ceg);
        new ProgressDialog(this.getShell(), "Generate Graph", this.graphGenerator);
        this.graph = this.graphGenerator.getGraph(this.ceg);
        if (this.graph != null) {
            this.graph.calculateConnectedComponents();
            this.graph = this.graph.getConnectedComponents().get(0);
            this.calculatePositions();
            this.loadedGraph = true;
        }
        this.canvas.redraw();
    }

    protected Rectangle getRectangle(Point p1, Point p2) {
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int width = Math.max(p1.x, p2.x) - x;
        int height = Math.max(p1.y, p2.y) - y;
        return new Rectangle(x, y, width, height);
    }

    @Override
    protected void paint(Rectangle rect, GC gc) {
        this.loadGraph();
        if (this.graph == null) {
            return;
        }
        this.tfInfo.setText("Intersections: " + this.graph.getIntersections());
        for (Edge e : this.graph.getEdges()) {
            e.paint(gc, false);
        }
        if (this.hoverNode == null && this.hoverEdge != null) {
            this.hoverEdge.paint(gc, true);
        }
        for (Node n : this.graph.getNodes()) {
            n.paint(gc, false, false);
        }
        for (Node n : this.selectedNodes.values()) {
            n.paint(gc, true, false);
        }
        if (this.hoverNode != null) {
            this.hoverNode.paint(gc, true, true);
        }
        if (this.dragNode != null) {
            this.dragNode.paint(gc, true, false);
        }
        gc.setBackground(this.COLOR_BACKGROUND);
        gc.setForeground(this.COLOR_DEFAULT);
        if (this.dragPointSource != null) {
            gc.drawRectangle(this.getRectangle(this.dragPointSource, this.dragPointTarget));
        }
    }

    private void translateNode(Node n, Vector2D t) {
        Vector2D v = new Vector2D(n.getCenterX(), n.getCenterY());
        v = v.plus(t);
        n.setCenter((int)v.getX(), (int)v.getY());
    }

    private void dragNodes(int x2, int y2) {
        assert (this.dragOffset != null);
        assert (this.dragNode != null);
        Vector2D v1 = new Vector2D(this.dragNode.getCenterX(), this.dragNode.getCenterY());
        Vector2D v2 = new Vector2D(x2, y2);
        Vector2D t = v2.minus(v1).plus(this.dragOffset);
        if (!this.selectedNodes.containsKey(this.dragNode.getID())) {
            this.translateNode(this.dragNode, t);
        }
        for (Node n : this.selectedNodes.values()) {
            this.translateNode(n, t);
        }
    }

    @Override
    public void fragmentSelectionChanged(Fragment f) {
    }

    @Override
    public void classSelectionChanged(CloneClass cc) {
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.dragPointSource = new Point(e.x, e.y);
            this.dragPointTarget = new Point(e.x, e.y);
            this.dragNode = this.getNodeFromCoordinates(e.x, e.y);
            if (this.dragNode != null) {
                Vector2D vCenter = new Vector2D(this.dragNode.getCenterX(), this.dragNode.getCenterY());
                Vector2D vCursor = new Vector2D(e.x, e.y);
                this.dragOffset = vCenter.minus(vCursor);
            }
        } else {
            if (!this.selectedNodes.isEmpty()) {
                this.redrawAfterMouseUp = true;
            }
            this.selectedNodes.clear();
        }
        this.hoverNode = null;
        this.hoverEdge = null;
    }

    public void mouseUp(MouseEvent arg0) {
        if (this.dragNode != null && !this.dragging) {
            int id = this.dragNode.getID();
            if (this.selectedNodes.containsKey(id)) {
                this.selectedNodes.remove(id);
            } else {
                this.selectedNodes.put(id, this.dragNode);
            }
        }
        if (this.dragPointSource != null) {
            assert (this.dragPointTarget != null);
            Rectangle r = this.getRectangle(this.dragPointSource, this.dragPointTarget);
            for (Node n : this.getNodesInRectangle(r)) {
                this.selectedNodes.put(n.getID(), n);
            }
        }
        this.dragPointSource = null;
        this.dragPointTarget = null;
        this.dragNode = null;
        this.dragging = false;
        if (this.redrawAfterMouseUp) {
            this.canvas.redraw();
            this.redrawAfterMouseUp = false;
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.dragNode != null) {
            this.dragging = true;
            this.dragNodes(e.x, e.y);
        } else if (this.dragPointSource != null) {
            this.dragging = true;
            this.dragPointTarget = new Point(e.x, e.y);
        } else {
            this.hoverNode = this.getNodeFromCoordinates(e.x, e.y);
            if (this.hoverNode == null) {
                this.hoverEdge = this.getEdgeFromCoordinates(e.x, e.y);
            }
        }
        this.canvas.redraw();
        this.redrawAfterMouseUp = this.dragging;
    }

    private Edge getEdgeFromCoordinates(int x, int y) {
        if (this.graph == null) {
            return null;
        }
        for (Edge e : this.graph.getEdges()) {
            Line2D.Double line = new Line2D.Double(e.getStart().getCenterX(), e.getStart().getCenterY(), e.getEnd().getCenterX(), e.getEnd().getCenterY());
            if (!(line.ptSegDist(x, y) < 5.0)) continue;
            return e;
        }
        return null;
    }

    private Node getNodeFromCoordinates(int x, int y) {
        if (this.graph == null) {
            return null;
        }
        for (Node n : this.graph.getNodes()) {
            if (!n.getBounds().contains(x, y)) continue;
            return n;
        }
        return null;
    }

    private List<Node> getNodesInRectangle(Rectangle r) {
        LinkedList<Node> list = new LinkedList<Node>();
        if (this.graph != null) {
            for (Node n : this.graph.getNodes()) {
                if (!r.contains(n.getCenterX(), n.getCenterY())) continue;
                list.add(n);
            }
        }
        return list;
    }
}

