/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.list;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.control.ChangeListener;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.Controller;
import de.uni_bremen.st.cyclone.system.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListPanel
extends Composite
implements ClassSelectionListener,
CloneEvolutionGraphListener,
ChangeListener {
    private static final long serialVersionUID = 0L;
    private List<Version> revisions;
    private Table tVersions;
    private Table tClasses;
    private Table tFragments;
    private Version selectedVersion = null;
    private CloneClass selectedClass = null;
    private Fragment selectedFragment = null;

    public ListPanel(TabItem owner) {
        super((Composite)owner.getParent(), 0);
        owner.setControl((Control)this);
        this.setLayout((Layout)new FillLayout(512));
        SashForm outer = new SashForm((Composite)this, 256);
        this.tVersions = new Table((Composite)outer, 2052);
        SashForm inner = new SashForm((Composite)outer, 512);
        outer.setWeights(new int[]{50, 50});
        this.tClasses = new Table((Composite)inner, 2052);
        this.tFragments = new Table((Composite)inner, 2052);
        inner.setWeights(new int[]{50, 50});
        this.initialize(this.tVersions, new String[]{"ID", "Directory", "#Classes", "#Type 1", "#Type 2", "#Type 3", "#Fragments"});
        if (Cyclone.isRelease()) {
            this.initialize(this.tClasses, new String[]{"ID", "Type", "Length", "#Fragments"});
            this.initialize(this.tFragments, new String[]{"ID", "File"});
        } else {
            this.initialize(this.tClasses, new String[]{"ID", "Type", "Length", "#Fragments", "Alphabet"});
            this.initialize(this.tFragments, new String[]{"ID", "File", "Alphabet"});
        }
        this.tVersions.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ListPanel.this.onVersionSelectionChanged();
            }
        });
        this.tClasses.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ListPanel.this.onClassSelectionChanged();
            }
        });
        this.tFragments.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ListPanel.this.onFragmentSelectionChanged();
            }
        });
        Controller.addChangeListener(this);
    }

    private void initialize(Table t, String[] titles) {
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                Table t = column.getParent();
                TableItem[] items = t.getItems();
                int index = 0;
                for (TableColumn tableColumn : t.getColumns()) {
                    if (tableColumn == column) break;
                    ++index;
                }
                items = ListPanel.this.sort(items, index, t.getSortDirection() == 128);
                for (TableColumn tableColumn : items) {
                    String[] values = new String[t.getColumnCount()];
                    for (int k = 0; k < values.length; ++k) {
                        values[k] = tableColumn.getText(k);
                    }
                    tableColumn.dispose();
                    TableItem item = new TableItem(t, 0);
                    item.setText(values);
                }
                if (t.getSortDirection() == 128) {
                    t.setSortDirection(1024);
                } else {
                    t.setSortDirection(128);
                }
                t.setSortColumn(column);
            }
        };
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(t, 0);
            column.setText(titles[i]);
            column.addListener(13, sortListener);
        }
        t.setLinesVisible(true);
        t.setHeaderVisible(true);
    }

    private TableItem[] sort(TableItem[] items, final int pos, final boolean up) {
        Comparator<TableItem> c = new Comparator<TableItem>(){

            @Override
            public int compare(TableItem a, TableItem b) {
                int j;
                if (a.getParent().equals(ListPanel.this.tFragments) && pos == 2 || !Cyclone.isRelease() && a.getParent().equals(ListPanel.this.tClasses) && pos == 4) {
                    double j2;
                    double i = Double.parseDouble(a.getText(pos));
                    if (i == (j2 = Double.parseDouble(b.getText(pos)))) {
                        return 0;
                    }
                    if (!up && i < j2 || up && i > j2) {
                        return -1;
                    }
                    return 1;
                }
                if (!a.getParent().equals(ListPanel.this.tClasses) && pos == 1 || a.getParent().getColumn(pos).getText().equals("Annotation")) {
                    return up ? -a.getText(pos).compareTo(b.getText(pos)) : a.getText(pos).compareTo(b.getText(pos));
                }
                int i = Integer.parseInt(a.getText(pos));
                if (i == (j = Integer.parseInt(b.getText(pos)))) {
                    return 0;
                }
                if (!up && i < j || up && i > j) {
                    return -1;
                }
                return 1;
            }
        };
        Arrays.sort(items, c);
        return items;
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.revisions = g.getVersions();
        if (this.revisions.isEmpty()) {
            return;
        }
        this.selectedVersion = this.revisions.get(0);
        this.selectedClass = this.selectedVersion.getVisibleCloneClasses().size() > 0 ? new ArrayList<CloneClass>(this.selectedVersion.getVisibleCloneClasses().values()).get(0) : null;
        this.updateTables(true, true);
        this.tVersions.setSelection(0);
        this.tClasses.setSelection(0);
    }

    private void updateTables(boolean updateRevisions, boolean updateClasses) {
        int i;
        if (updateRevisions) {
            this.tVersions.removeAll();
            for (Version r : this.revisions) {
                if (!r.isVisible()) continue;
                int type1 = 0;
                int type2 = 0;
                int type3 = 0;
                for (CloneClass cc : r.getVisibleCloneClasses().values()) {
                    if (cc.getType() == 1) {
                        ++type1;
                        continue;
                    }
                    if (cc.getType() == 2) {
                        ++type2;
                        continue;
                    }
                    if (cc.getType() != 3) continue;
                    ++type3;
                }
                TableItem ti = new TableItem(this.tVersions, 0);
                ti.setText(0, "" + r.getID());
                ti.setText(1, r.getPath().substring(r.getPath().lastIndexOf(47) + 1));
                ti.setText(2, "" + r.getVisibleCloneClasses().size());
                ti.setText(3, "" + type1);
                ti.setText(4, "" + type2);
                ti.setText(5, "" + type3);
                ti.setText(6, "" + r.getVisibleFragments().size());
            }
            for (i = 0; i < this.tVersions.getColumnCount(); ++i) {
                this.tVersions.getColumn(i).pack();
            }
            this.tVersions.setSortColumn(this.tVersions.getColumns()[0]);
            this.tVersions.setSortDirection(128);
        }
        if (updateClasses && this.selectedVersion != null && this.selectedVersion.isVisible()) {
            this.tClasses.removeAll();
            for (CloneClass c : new ArrayList<CloneClass>(this.selectedVersion.getVisibleCloneClasses().values())) {
                TableItem ti = new TableItem(this.tClasses, 0);
                ti.setText(0, "" + c.getID());
                ti.setText(1, "" + c.getType());
                ti.setText(2, "" + c.getVisibleFragments().get(0).getLength());
                ti.setText(3, "" + c.getVisibleFragments().size());
                if (Cyclone.isRelease()) continue;
                ti.setText(4, "" + c.getVisibleFragments().get(0).getAlphabetSize());
            }
            for (i = 0; i < this.tClasses.getColumnCount(); ++i) {
                this.tClasses.getColumn(i).pack();
            }
            this.tClasses.setSortColumn(this.tClasses.getColumns()[0]);
            this.tClasses.setSortDirection(128);
        }
        this.tFragments.removeAll();
        if (this.selectedClass != null && this.selectedClass.isVisible()) {
            for (Fragment f : this.selectedClass.getVisibleFragments()) {
                TableItem ti = new TableItem(this.tFragments, 0);
                ti.setText(0, "" + f.getID());
                ti.setText(1, f.getFile());
                if (Cyclone.isRelease()) continue;
                ti.setText(2, "" + f.getAlphabetSize());
            }
            for (int i2 = 0; i2 < this.tFragments.getColumnCount(); ++i2) {
                this.tFragments.getColumn(i2).pack();
            }
        }
        this.tFragments.setSortColumn(this.tFragments.getColumns()[0]);
        this.tFragments.setSortDirection(128);
    }

    @Override
    public void classSelectionChanged(CloneClass c) {
        int i;
        this.selectedVersion = c.getRevision();
        this.selectedClass = c;
        this.updateTables(false, true);
        for (i = 0; i < this.tClasses.getItemCount(); ++i) {
            if (Integer.parseInt(this.tClasses.getItem(i).getText(0)) != this.selectedClass.getID()) continue;
            this.tClasses.setSelection(i);
            break;
        }
        for (i = 0; i < this.tVersions.getItemCount(); ++i) {
            if (Integer.parseInt(this.tVersions.getItem(i).getText(0)) != this.selectedVersion.getID()) continue;
            this.tVersions.setSelection(i);
            break;
        }
    }

    public void onVersionSelectionChanged() {
        int vID = Integer.parseInt(this.tVersions.getSelection()[0].getText(0));
        for (Version r : this.revisions) {
            if (r.getID() != vID) continue;
            this.selectedVersion = r;
        }
        this.selectedClass = this.selectedVersion.getVisibleCloneClasses().size() > 0 ? new ArrayList<CloneClass>(this.selectedVersion.getVisibleCloneClasses().values()).get(0) : null;
        this.updateTables(false, true);
        this.tClasses.setSelection(0);
    }

    public void onClassSelectionChanged() {
        int cID = Integer.parseInt(this.tClasses.getSelection()[0].getText(0));
        this.selectedClass = this.selectedVersion.getCloneClass(cID);
        this.updateTables(false, false);
        Controller.classSelectionChanged(this.selectedClass, this);
    }

    public void onFragmentSelectionChanged() {
        int cID = Integer.parseInt(this.tFragments.getSelection()[0].getText(0));
        for (Fragment f : this.selectedClass.getVisibleFragments()) {
            if (f.getID() != cID) continue;
            this.selectedFragment = f;
        }
        Controller.fragmentSelectionChanged(this.selectedFragment);
    }

    @Override
    public void elementChanged(AbstractModelEntity e) {
        this.updateTables(e instanceof Version, e instanceof Version || e instanceof CloneClass);
    }
}

