/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.plot;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.plot.ChangeFrequency;
import de.uni_bremen.st.cyclone.plot.CloneCoverage;
import de.uni_bremen.st.cyclone.plot.Clones;
import de.uni_bremen.st.cyclone.plot.DegreeOfChange;
import de.uni_bremen.st.cyclone.plot.ExecutionTime;
import de.uni_bremen.st.cyclone.plot.FragmentLifetime;
import de.uni_bremen.st.cyclone.plot.GenealogyLifetime;
import de.uni_bremen.st.cyclone.plot.LinesOfCode;
import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.cyclone.ui.plot.PlotPanel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PlotCtrlPanel
extends Composite
implements CloneEvolutionGraphListener {
    private static final long serialVersionUID = 0L;
    private Combo cbPlotData;
    private Button btnExportData;
    private PlotPanel plotPanel;
    private Map<String, PlotData> plotData = new HashMap<String, PlotData>();
    private PlotData currentPlotData = null;

    public PlotCtrlPanel(TabItem owner) {
        super((Composite)owner.getParent(), 0);
        PlotData[] pd;
        owner.setControl((Control)this);
        for (PlotData d : pd = new PlotData[]{new LinesOfCode(), new Clones(), new CloneCoverage(), new GenealogyLifetime(), new FragmentLifetime(), new ChangeFrequency(), new DegreeOfChange(), new ExecutionTime()}) {
            this.plotData.put(d.getName(), d);
        }
        GridLayout gl = new GridLayout();
        gl.numColumns = 6;
        this.setLayout((Layout)gl);
        Text tfPosition = new Text((Composite)this, 131076);
        tfPosition.setEditable(false);
        this.cbPlotData = new Combo((Composite)this, 8);
        this.cbPlotData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlotCtrlPanel.this.changedInput();
                PlotCtrlPanel.this.plotPanel.redraw();
            }
        });
        final Button chbKey = new Button((Composite)this, 32);
        chbKey.setText("Key");
        chbKey.setSelection(true);
        chbKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlotCtrlPanel.this.plotPanel.setDrawLegend(chbKey.getSelection());
                PlotCtrlPanel.this.plotPanel.redraw();
            }
        });
        final Button chbHGrid = new Button((Composite)this, 32);
        chbHGrid.setText("Horizontal Grid");
        chbHGrid.setSelection(true);
        chbHGrid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlotCtrlPanel.this.plotPanel.setHGrid(chbHGrid.getSelection());
                PlotCtrlPanel.this.plotPanel.redraw();
            }
        });
        final Button chbVGrid = new Button((Composite)this, 32);
        chbVGrid.setText("Vertical Grid");
        chbVGrid.setSelection(true);
        chbVGrid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlotCtrlPanel.this.plotPanel.setVGrid(chbVGrid.getSelection());
                PlotCtrlPanel.this.plotPanel.redraw();
            }
        });
        this.btnExportData = new Button((Composite)this, 8);
        this.btnExportData.setText("Export Data...");
        this.btnExportData.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                FileDialog f = new FileDialog(PlotCtrlPanel.this.getShell(), 8192);
                f.setFilterPath(Cyclone.getConfig().getProperty("lastPath"));
                String file = f.open();
                if (PlotCtrlPanel.this.mayOverwrite(file)) {
                    PlotCtrlPanel.this.exportDataFile(file);
                }
            }
        });
        this.btnExportData.setEnabled(false);
        this.plotPanel = new PlotPanel(this, tfPosition);
        this.plotPanel.setLayoutData(new GridData(4, 4, true, true, gl.numColumns, 1));
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        String previousSelection = this.cbPlotData.getText();
        ArrayList<PlotData> availablePlots = new ArrayList<PlotData>();
        for (Map.Entry<String, PlotData> e : this.plotData.entrySet()) {
            if (!e.getValue().isAvailable()) continue;
            availablePlots.add(e.getValue());
        }
        Collections.sort(availablePlots);
        this.cbPlotData.removeAll();
        for (PlotData d : availablePlots) {
            d.cloneEvolutionGraphChanged(g);
            this.cbPlotData.add(d.getName());
        }
        boolean selected = false;
        for (int i = 0; i < this.cbPlotData.getItemCount(); ++i) {
            if (!this.cbPlotData.getItem(i).equals(previousSelection)) continue;
            this.cbPlotData.select(i);
            selected = true;
            break;
        }
        if (!selected) {
            this.cbPlotData.select(0);
        }
        this.layout();
        this.changedInput();
        this.redraw();
    }

    private boolean mayOverwrite(String filename) {
        if (filename == null) {
            return false;
        }
        if (new File(filename).exists()) {
            MessageBox msg = new MessageBox(this.getShell(), 200);
            msg.setMessage("The file already exists. Overwrite it?");
            msg.setText("Overwrite File?");
            return msg.open() == 64;
        }
        return true;
    }

    private void exportDataFile(String datafile) {
        try {
            PrintStream out = new PrintStream(datafile);
            out.print("\"");
            out.print(this.currentPlotData.getXLabel());
            out.print("\"");
            for (String title : this.currentPlotData.getKey()) {
                out.print(" \"");
                out.print(title);
                out.print("\"");
            }
            out.print("\n");
            for (double[] ds : this.currentPlotData.getData()) {
                boolean first = true;
                for (double d : ds) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(" ");
                    }
                    out.print(d);
                }
                out.print("\n");
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void changedInput() {
        this.currentPlotData = this.plotData.get(this.cbPlotData.getText());
        this.btnExportData.setEnabled(this.currentPlotData != null && this.currentPlotData.getData() != null);
        this.plotPanel.setPlotData(this.currentPlotData);
    }
}

