/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.plot;

import de.uni_bremen.st.cyclone.plot.PlotData;
import de.uni_bremen.st.cyclone.ui.Console;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class PlotPanel
extends Canvas {
    private static final long serialVersionUID = 0L;
    private double minX = 0.0;
    private double minY = 0.0;
    private double maxX = 6.0;
    private double maxY = 4.0;
    private int dataSizeY = 0;
    private double smallestGap = 2.147483647E9;
    private final Font FONT = new Font((Device)this.getDisplay(), "Bitstream Vera Sans Mono", 11, 0);
    private final int MAX_YTICS_WIDTH = 4;
    private final int MAX_XTICS_WIDTH = 5;
    private final int BORDER_X = 50;
    private final int BORDER_Y = 50;
    private boolean useLines = true;
    private boolean useHGrid = true;
    private boolean useVGrid = true;
    private boolean drawLegend = true;
    private final Color COLOR_DEFAULT = this.getDisplay().getSystemColor(2);
    private final Color COLOR_BACKGROUND = this.getDisplay().getSystemColor(1);
    private final Color COLOR_SELECTED = this.getDisplay().getSystemColor(3);
    private final Color COLOR_GRID = new Color((Device)this.getDisplay(), 220, 220, 220);
    private final Color[] COLORS = new Color[]{this.getDisplay().getSystemColor(3), this.getDisplay().getSystemColor(9), this.getDisplay().getSystemColor(5), this.getDisplay().getSystemColor(4), this.getDisplay().getSystemColor(15), this.getDisplay().getSystemColor(13), this.getDisplay().getSystemColor(11), this.getDisplay().getSystemColor(7), this.getDisplay().getSystemColor(8)};
    private PlotData plotData;
    private int legendOuterSpaceX = 12;
    private int legendOuterSpaceY = 10;
    private int legendInnerSpace = 9;
    private int legendStrokeLength = 8;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double shiftX = 0.0;
    private double plotHeight = 0.0;
    private double currentXValue = 0.0;
    private double currentYValue = 0.0;
    private Point highlightedPoint = null;
    private int precisionX = 0;
    private int precisionY = 0;
    private Text pointInfo;

    public PlotPanel(Composite owner, Text pi) {
        super(owner, 0);
        this.pointInfo = pi;
        this.setBackground(this.COLOR_BACKGROUND);
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                PlotPanel.this.paint(e.gc);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                PlotPanel.this.currentXValue = PlotPanel.this.calculateX(e.x);
                PlotPanel.this.currentYValue = PlotPanel.this.calculateY(e.y);
                String sx = PlotPanel.this.format(PlotPanel.this.currentXValue, PlotPanel.this.precisionX, 5);
                String sy = PlotPanel.this.format(PlotPanel.this.currentYValue, PlotPanel.this.precisionY, 4);
                PlotPanel.this.pointInfo.setText(sx + ", " + sy);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                PlotPanel.this.highlightedPoint = new Point(e.x, e.y);
                PlotPanel.this.redraw();
            }
        });
    }

    public void setPlotData(PlotData plotData) {
        this.plotData = plotData;
        if (plotData == null) {
            return;
        }
        this.minX = 2.147483647E9;
        this.minY = 0.0;
        this.maxX = -2.147483648E9;
        this.maxY = -2.147483648E9;
        this.smallestGap = 2.147483647E9;
        this.dataSizeY = 0;
        double lastX = -2.147483648E9;
        double[][] data = plotData.getData();
        if (data == null) {
            return;
        }
        for (double[] d : data) {
            this.minX = Math.min(this.minX, d[0]);
            this.maxX = Math.max(this.maxX, d[0]);
            this.smallestGap = Math.min(this.smallestGap, Math.abs(d[0] - lastX));
            if (d[0] <= lastX) {
                Console.error("PlotPanel.setData(): the x values are not sorted");
            }
            if (plotData.getType() == PlotData.Type.STACKED) {
                double y = 0.0;
                for (int i = 1; i < d.length; ++i) {
                    if (d[i] < 0.0) {
                        this.plotData = null;
                        throw new ArrayStoreException("Negative y-values in STACKED-Mode not supported.");
                    }
                    y += d[i];
                }
                this.minY = 0.0;
                this.maxY = Math.max(this.maxY, y);
            } else {
                int i;
                for (i = 1; i < d.length; ++i) {
                    this.minY = Math.min(this.minY, d[i]);
                    this.maxY = Math.max(this.maxY, d[i]);
                }
                this.dataSizeY = Math.max(this.dataSizeY, i - 1);
            }
            lastX = d[0];
        }
        if (plotData.getType() == PlotData.Type.BAR && this.minY > 0.0) {
            this.minY = 0.0;
        }
        if (this.minX == this.maxX) {
            if (this.minX == 0.0) {
                this.minX = -1.0;
                this.maxX = 1.0;
            } else {
                this.minX -= this.minX * 0.5;
                this.maxX += this.maxX * 0.5;
            }
        }
        this.redraw();
    }

    public void setHGrid(boolean b) {
        this.useHGrid = b;
    }

    public void setVGrid(boolean b) {
        this.useVGrid = b;
    }

    public void setDrawLegend(boolean b) {
        this.drawLegend = b;
    }

    private int digits(double d) {
        double dd = d;
        int i = 1;
        if (d == 0.0) {
            return 1;
        }
        while (dd < Double.MAX_VALUE) {
            if ((int)(dd *= 10.0) > 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private Color getColor(int i) {
        return this.COLORS[i % this.COLORS.length];
    }

    private double[] round(double tics, double max) {
        int precision;
        if (max >= 1.0) {
            int digits = Integer.toString((int)max).length() - 1;
            double digitsPow10 = Math.pow(10.0, digits);
            tics /= digitsPow10;
            tics = Math.ceil(tics);
            tics *= digitsPow10;
            precision = 1 - digits;
            if (precision < 0) {
                precision = 0;
            }
        } else {
            int digits = this.digits(max - (double)((int)max));
            double digitsPow10 = Math.pow(10.0, digits);
            tics *= digitsPow10;
            tics = Math.ceil(tics);
            tics /= digitsPow10;
            precision = digits;
        }
        return new double[]{tics, precision};
    }

    public void paint(GC gc) {
        int width = this.getSize().x;
        int height = (int)((double)this.getSize().y / 1.05);
        if (this.plotData == null) {
            return;
        }
        double[][] data = this.plotData.getData();
        if (data == null) {
            return;
        }
        gc.setFont(this.FONT);
        FontMetrics fm = gc.getFontMetrics();
        double plotWidth = width - 100;
        this.plotHeight = height - 100;
        if (plotWidth < 10.0 || this.plotHeight < 10.0) {
            return;
        }
        int ticCountX = Math.max(1, (int)plotWidth / 100);
        double xtics = (this.maxX - this.minX) / (double)ticCountX;
        double[] r = this.round(xtics, this.maxX - this.minX);
        xtics = r[0];
        this.precisionX = (int)r[1];
        this.shiftX = 0.3 * xtics;
        this.scaleX = plotWidth / (this.maxX + 2.0 * this.shiftX - this.minX);
        for (double x = this.minX; x < this.maxX + this.shiftX; x += xtics) {
            int xValue = 50 + (int)((x - this.minX + this.shiftX) * this.scaleX);
            gc.drawLine(xValue, 50 + (int)this.plotHeight, xValue, 50 + (int)this.plotHeight + 5);
            String s = this.format(x, this.precisionX, 5);
            int sw = gc.stringExtent((String)s).x;
            int sx = xValue - sw / 2;
            gc.drawString(s, sx, 50 + (int)this.plotHeight + fm.getAscent(), true);
            if (!this.useVGrid || !(x >= this.minX) || !(x < this.maxX + this.shiftX)) continue;
            gc.setForeground(this.COLOR_GRID);
            gc.drawLine(xValue, 51, xValue, 50 + (int)this.plotHeight - 1);
            gc.setForeground(this.COLOR_DEFAULT);
        }
        gc.setForeground(this.darker(this.COLOR_GRID));
        int x0 = 50 + (int)((-this.minX + this.shiftX) * this.scaleX);
        gc.drawLine(x0, 51, x0, 50 + (int)this.plotHeight - 1);
        int ticCountY = Math.max(1, (int)this.plotHeight / 100);
        double ytics = (this.maxY - this.minY) / (double)ticCountY;
        double spaceTopY = 0.5 * ytics;
        r = this.round(ytics, this.maxY - this.minY);
        ytics = r[0];
        this.precisionY = (int)r[1];
        this.scaleY = this.plotHeight / (this.maxY + spaceTopY - this.minY);
        gc.setForeground(this.COLOR_DEFAULT);
        for (double y = this.minY; y <= this.maxY + spaceTopY; y += ytics) {
            int yValue = 50 + (int)(this.plotHeight - (y - this.minY) * this.scaleY);
            gc.drawLine(45, yValue, 50, yValue);
            String s = this.format(y, this.precisionY, 4);
            int sw = gc.stringExtent((String)s).x;
            int sx = 40 - sw;
            gc.drawString(s, sx, yValue - fm.getAscent() / 2 - 1, true);
            if (!this.useHGrid || !(y >= this.minY) || !(y <= this.maxY + spaceTopY)) continue;
            gc.setForeground(this.COLOR_GRID);
            gc.drawLine(51, yValue, 50 + (int)plotWidth - 1, yValue);
            gc.setForeground(this.COLOR_DEFAULT);
        }
        gc.setForeground(this.darker(this.COLOR_GRID));
        int y0 = 50 + (int)(this.plotHeight - -this.minY * this.scaleY);
        gc.drawLine(51, y0, 50 + (int)plotWidth - 1, y0);
        double infoX = 0.0;
        double infoY = 0.0;
        int infoXValue = -1;
        int infoYValue = -1;
        int barWidth = data.length > 1 ? (int)(this.smallestGap * 0.5 * this.scaleX) : (int)(0.5 * xtics * this.scaleX);
        switch (this.plotData.getType()) {
            case BAR: {
                for (int x = 0; x < data.length; ++x) {
                    int oneBarWidth = barWidth / (data[x].length - 1);
                    int xValue = 50 + (int)((data[x][0] - this.minX + this.shiftX) * this.scaleX) - barWidth / 2;
                    for (int i = 0; i < data[x].length - 1; ++i) {
                        int barHeight;
                        int yValue;
                        double y = data[x][i + 1];
                        if (y >= 0.0) {
                            yValue = 50 + (int)(this.plotHeight - (y - this.minY) * this.scaleY);
                            barHeight = (int)(50.0 + this.plotHeight - -this.minY * this.scaleY) - yValue;
                        } else {
                            yValue = (int)(50.0 + this.plotHeight - -this.minY * this.scaleY);
                            barHeight = (int)(50.0 + this.plotHeight - (y - this.minY) * this.scaleY) - yValue;
                        }
                        gc.setBackground(this.getColor(i));
                        Rectangle brect = new Rectangle(xValue, yValue, oneBarWidth, barHeight);
                        if (this.highlightedPoint != null && brect.contains(this.highlightedPoint)) {
                            infoX = data[x][0];
                            infoY = y;
                            infoXValue = xValue + oneBarWidth / 2;
                            infoYValue = yValue;
                        }
                        gc.fillRectangle(brect);
                        xValue += oneBarWidth;
                    }
                }
                gc.setForeground(this.COLOR_DEFAULT);
                int lineY = (int)(50.0 + this.plotHeight - -this.minY * this.scaleY);
                gc.drawLine(50, lineY, (int)(plotWidth + 50.0), lineY);
                break;
            }
            case STACKED: {
                for (int x = 0; x < data.length; ++x) {
                    int xValue = 50 + (int)((data[x][0] - this.minX + this.shiftX) * this.scaleX) - barWidth / 2;
                    int lastYValue = (int)(50.0 + this.plotHeight - -this.minY * this.scaleY);
                    double lastY = 0.0;
                    for (int i = 0; i < data[x].length - 1; ++i) {
                        double y = data[x][i + 1] + lastY;
                        int yValue = 50 + (int)(this.plotHeight - (y - this.minY) * this.scaleY);
                        Rectangle srect = new Rectangle(xValue, yValue, barWidth, lastYValue - yValue);
                        gc.setBackground(this.getColor(i));
                        if (this.highlightedPoint != null && srect.contains(this.highlightedPoint)) {
                            infoX = data[x][0];
                            infoY = data[x][i + 1];
                            infoXValue = xValue + barWidth / 2;
                            infoYValue = yValue;
                        }
                        gc.fillRectangle(srect);
                        lastYValue = yValue;
                        lastY = y;
                    }
                }
                break;
            }
            case GRAPH: {
                int[] lastXValue = new int[this.dataSizeY];
                int[] lastYValue = new int[this.dataSizeY];
                for (int x = 0; x < data.length; ++x) {
                    int xValue = 50 + (int)((data[x][0] - this.minX + this.shiftX) * this.scaleX);
                    for (int i = 0; i < data[x].length - 1; ++i) {
                        double y = data[x][i + 1];
                        int yValue = 50 + (int)(this.plotHeight - (y - this.minY) * this.scaleY);
                        if (this.useLines && lastXValue[i] > 0) {
                            gc.setForeground(this.getColor(i));
                            gc.drawLine(lastXValue[i], lastYValue[i], xValue, yValue);
                        }
                        lastYValue[i] = yValue;
                        lastXValue[i] = xValue;
                        Rectangle circle = new Rectangle(xValue - 6, yValue - 6, 12, 12);
                        if (this.highlightedPoint != null && infoXValue == -1 && circle.contains(this.highlightedPoint)) {
                            gc.setForeground(this.COLOR_SELECTED);
                            gc.drawOval(circle.x, circle.y, circle.width, circle.height);
                            infoX = data[x][0];
                            infoY = y;
                            infoXValue = xValue;
                            infoYValue = yValue;
                        }
                        gc.setForeground(this.getColor(i));
                        gc.drawLine(xValue - 2, yValue - 2, xValue + 2, yValue + 2);
                        gc.drawLine(xValue + 2, yValue - 2, xValue - 2, yValue + 2);
                    }
                }
                break;
            }
        }
        String[] key = this.plotData.getKey();
        if (this.drawLegend && key != null && key.length > 0) {
            int legendX = (int)(50.0 + (this.shiftX - 0.2 * xtics) * this.scaleX);
            int legendY = (int)(50.0 + (spaceTopY - spaceTopY * 0.5) * this.scaleY);
            Color legendBackground = this.COLOR_BACKGROUND;
            Color legendBorder = this.COLOR_DEFAULT;
            int legendWidth = this.legendOuterSpaceX;
            for (String s : key) {
                legendWidth += this.legendStrokeLength + this.legendInnerSpace + gc.stringExtent((String)s).x + this.legendOuterSpaceX;
            }
            int legendHeight = fm.getHeight() + 2 * this.legendOuterSpaceY;
            if ((double)legendWidth + 2.0 * (this.shiftX - 0.2 * xtics) * this.scaleX < plotWidth && (double)legendHeight < spaceTopY * this.scaleY) {
                gc.setBackground(legendBackground);
                gc.fillRectangle(legendX, legendY, legendWidth, legendHeight);
                gc.setForeground(legendBorder);
                gc.drawRectangle(legendX, legendY, legendWidth, legendHeight);
                int x = legendX + this.legendOuterSpaceX;
                for (int i = 0; i < key.length; ++i) {
                    gc.setBackground(this.getColor(i));
                    gc.fillRectangle(x, legendY + legendHeight / 2 - 1, this.legendStrokeLength, 3);
                    gc.setForeground(this.COLOR_DEFAULT);
                    gc.drawString(key[i], x += this.legendInnerSpace + this.legendStrokeLength, legendY + this.legendOuterSpaceY, true);
                    x += gc.stringExtent((String)key[i]).x + this.legendOuterSpaceX;
                }
            }
        }
        if (this.highlightedPoint != null && infoXValue > -1) {
            String s = "" + infoX + " : " + infoY;
            int infoWidth = gc.stringExtent((String)s).x + 10;
            int infoHeight = fm.getAscent() + 6;
            infoYValue = infoYValue - infoHeight - 5;
            Rectangle irect = new Rectangle(infoXValue -= infoWidth / 2, infoYValue, infoWidth, infoHeight);
            gc.setBackground(this.COLOR_GRID);
            gc.fillRectangle(irect);
            gc.setForeground(this.COLOR_DEFAULT);
            gc.drawString(s, infoXValue + 5, infoYValue + 3, true);
            gc.drawRectangle(irect);
        }
        gc.setForeground(this.COLOR_DEFAULT);
        gc.drawRectangle(50, 50, (int)plotWidth, (int)this.plotHeight);
        gc.drawString(this.plotData.getXLabel(), width - gc.stringExtent((String)this.plotData.getXLabel()).x - 50, (int)this.plotHeight + 50 + 40, true);
        gc.drawString(this.plotData.getYLabel(), 12, 50 - 2 * fm.getAscent(), true);
    }

    private String format(double value, int precision, int maxLength) {
        String s = String.format("%1$." + precision + "f", value);
        if (s.length() > maxLength) {
            s = String.format("%1$.0E", value);
        }
        return s;
    }

    private Color darker(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color((Device)this.getDisplay(), Math.max(0, r - 50), Math.max(0, g - 50), Math.max(0, b - 50));
    }

    private double calculateX(double panel) {
        return (panel - 50.0) / this.scaleX - this.shiftX + this.minX;
    }

    private double calculateY(double panel) {
        return this.minY - (panel - 50.0 - this.plotHeight) / this.scaleY;
    }
}

