/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.source;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.AbstractModelEntity;
import de.uni_bremen.st.cyclone.clones.CloneClass;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.clones.CloneStatistics;
import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.SourceContext;
import de.uni_bremen.st.cyclone.control.ChangeListener;
import de.uni_bremen.st.cyclone.control.ClassSelectionListener;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.control.Controller;
import de.uni_bremen.st.cyclone.io.SVNReader;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.CycloneFrame;
import de.uni_bremen.st.cyclone.ui.Dialog;
import de.uni_bremen.st.cyclone.ui.source.MappingPanel;
import de.uni_bremen.st.cyclone.ui.source.SourceCodePanel;
import de.uni_bremen.st.cyclone.util.Diff;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import edu.tum.cs.scanner.IToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CompareSourcePanel
extends Composite
implements ClassSelectionListener,
CloneEvolutionGraphListener,
ChangeListener {
    private static final long serialVersionUID = 0L;
    private SashForm form;
    private SourceCodePanel leftSourcePanel = null;
    private SourceCodePanel rightSourcePanel = null;
    private MappingPanel mappingPanel = null;
    private ToolItem buttonSVNLog;
    private ToolItem buttonNextCloneClass;
    private ToolItem buttonPrevCloneClass;
    private ToolItem buttonPrevChangedCloneClass;
    private ToolItem buttonNextChangedCloneClass;
    private ToolItem buttonPrevInconsistentCloneClass;
    private ToolItem buttonNextInconsistentCloneClass;
    private ToolItem buttonPrevConsistentCloneClass;
    private ToolItem buttonNextConsistentCloneClass;
    private ToolItem buttonNextFragment;
    private ToolItem buttonPrevFragment;
    private ToolItem buttonModeForward;
    private ToolItem buttonModeSingle;
    private ToolItem buttonModeBackward;
    private ToolItem buttonRandomCC;
    private Label labelLeft;
    private Label labelRight;
    private Label labelType;
    private Table tableFragments;
    private Random randomGenerator;
    private Mode mode = Mode.SINGLE;
    private ChangeMode changeMode = ChangeMode.LINE;
    private ListIterator<CloneClass> cIterator = null;
    private ListIterator<Fragment> fIterator = null;
    private HashMap<Integer, SourceContext> sourceContexts = new HashMap();
    private List<CloneClass> cloneClasses = null;
    private CloneClass cloneclass;
    private Fragment fragment;

    public CompareSourcePanel(TabItem owner) {
        super((Composite)owner.getParent(), 0);
        owner.setControl((Control)this);
        this.randomGenerator = new Random();
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.setLayout((Layout)gl);
        ToolBar tb = new ToolBar((Composite)this, 0);
        this.buttonModeBackward = this.createButton(tb, 32, "modeBackward.png", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.mode = Mode.BACKWARD;
                CompareSourcePanel.this.modeChanged();
            }
        });
        this.buttonModeBackward.setEnabled(false);
        this.buttonModeSingle = this.createButton(tb, 32, "modeSingle.png", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.mode = Mode.SINGLE;
                CompareSourcePanel.this.modeChanged();
            }
        });
        this.buttonModeSingle.setEnabled(false);
        this.buttonModeSingle.setSelection(true);
        this.buttonModeForward = this.createButton(tb, 32, "modeForward.png", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.mode = Mode.FORWARD;
                CompareSourcePanel.this.modeChanged();
            }
        });
        this.buttonModeForward.setEnabled(false);
        new ToolItem(tb, 2);
        ToolItem buttonAlign = new ToolItem(tb, 8);
        buttonAlign.setImage(CycloneFrame.getImage("align.png"));
        buttonAlign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.adjust();
            }
        });
        if (!Cyclone.isRelease()) {
            new ToolItem(tb, 2);
            this.buttonSVNLog = this.addPushButton(tb, "svnlog.png", "Show SVN log message.", new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompareSourcePanel.this.showSVNLog();
                }
            });
        }
        new ToolItem(tb, 2);
        this.buttonPrevInconsistentCloneClass = this.addPushButton(tb, "prevInconsistentClass.png", "Go to previous inconsistently changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.prevChangedCloneClass(true, false);
            }
        });
        this.buttonPrevConsistentCloneClass = this.addPushButton(tb, "prevConsistentClass.png", "Go to previous consistently changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.prevChangedCloneClass(false, true);
            }
        });
        this.buttonPrevChangedCloneClass = this.addPushButton(tb, "prevChangedClass.png", "Go to previous changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.prevChangedCloneClass(true, true);
            }
        });
        this.buttonPrevCloneClass = this.addPushButton(tb, "prevClass.png", "Go to previous clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.previousCloneClass();
            }
        });
        new ToolItem(tb, 2);
        this.buttonPrevFragment = this.addPushButton(tb, "prevFragment.png", "Go to previous fragment.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.previousFragment();
            }
        });
        this.buttonNextFragment = this.addPushButton(tb, "nextFragment.png", "Go to next fragment.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.nextFragment();
            }
        });
        new ToolItem(tb, 2);
        this.buttonNextCloneClass = this.addPushButton(tb, "nextClass.png", "Go to next clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.nextCloneClass();
            }
        });
        this.buttonNextChangedCloneClass = this.addPushButton(tb, "nextChangedClass.png", "Go to next changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.nextChangedCloneClass(true, true);
            }
        });
        this.buttonNextConsistentCloneClass = this.addPushButton(tb, "nextConsistentClass.png", "Go to next consistently changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.nextChangedCloneClass(false, true);
            }
        });
        this.buttonNextInconsistentCloneClass = this.addPushButton(tb, "nextInconsistentClass.png", "Go to next inconsistently changed clone class.", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.nextChangedCloneClass(true, false);
            }
        });
        this.buttonRandomCC = this.addPushButton(tb, "randomClass.png", "Go to a random class of the current version", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareSourcePanel.this.randomCloneClass();
            }
        });
        tb.setLayoutData((Object)new GridData(4, 2, false, false));
        this.form = new SashForm((Composite)this, 512);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableFragments = new Table((Composite)this.form, 32768);
        String[] titles = new String[]{"View", "ID", "Start Line", "End Line", "Length", "File"};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(this.tableFragments, 0);
            column.setText(titles[i]);
        }
        this.tableFragments.setLinesVisible(true);
        this.tableFragments.setHeaderVisible(true);
        this.tableFragments.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        Composite comp = new Composite((Composite)this.form, 0);
        GridLayout glf = new GridLayout();
        glf.numColumns = 5;
        comp.setLayout((Layout)glf);
        this.labelLeft = new Label(comp, 0);
        this.labelLeft.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.labelType = new Label(comp, 0x1000000);
        this.labelType.setLayoutData((Object)new GridData(4, 4, false, false));
        this.labelType.setBackground(this.getDisplay().getSystemColor(3));
        this.labelRight = new Label(comp, 0);
        this.labelRight.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.leftSourcePanel = new SourceCodePanel(comp);
        this.mappingPanel = new MappingPanel(comp, this.leftSourcePanel, this.rightSourcePanel);
        this.mappingPanel.setLayoutData(new GridData(4, 4, false, true));
        this.rightSourcePanel = new SourceCodePanel(comp);
        this.mappingPanel.setSourcePanels(this.leftSourcePanel, this.rightSourcePanel);
        this.leftSourcePanel.setMappingPanel(this.mappingPanel);
        this.rightSourcePanel.setMappingPanel(this.mappingPanel);
        this.form.setWeights(new int[]{15, 85});
        Controller.addChangeListener(this);
        this.updateCCButtons();
    }

    private ToolItem addPushButton(ToolBar tb, String imageName, String tooltip, SelectionAdapter a) {
        ToolItem t = new ToolItem(tb, 8);
        t.setImage(CycloneFrame.getImage(imageName));
        t.setEnabled(false);
        t.setToolTipText(tooltip);
        t.addSelectionListener((SelectionListener)a);
        return t;
    }

    @Override
    public void classSelectionChanged(CloneClass cc) {
        this.buttonPrevCloneClass.setEnabled(false);
        this.buttonModeSingle.setEnabled(cc != null);
        this.buttonModeForward.setEnabled(cc != null);
        this.buttonModeBackward.setEnabled(cc != null);
        this.cIterator = this.cloneClasses.listIterator();
        CloneClass temp = this.cIterator.next();
        this.buttonPrevCloneClass.setEnabled(!temp.equals(cc));
        while (!temp.equals(cc)) {
            temp = this.cIterator.next();
        }
        this.loadFragments(cc);
        this.adjustLabels(cc);
        this.fIterator = cc.getVisibleFragments().listIterator();
        if (this.mode == Mode.SINGLE) {
            this.fIterator.next();
        }
        Fragment f = this.fIterator.next();
        this.labelType.setText(cc.getID() + "");
        if (cc.getType() >= 1 && cc.getType() <= 3) {
            this.labelType.setBackground(new Color((Device)this.getDisplay(), 255, (cc.getType() - 1) * 127, 0));
        } else {
            this.labelType.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        }
        this.displayFragment(f);
        this.buttonNextFragment.setEnabled(this.fIterator.hasNext());
        this.fIterator.previous();
        this.buttonPrevFragment.setEnabled(this.fIterator.hasPrevious());
        this.fIterator.next();
        this.updateCCButtons();
        this.buttonRandomCC.setEnabled(this.cloneclass.getRevision().getCloneClasses().size() > 1);
    }

    @Override
    public void elementChanged(AbstractModelEntity e) {
        if (this.cloneclass != null) {
            this.adjustLabels(this.cloneclass);
        }
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.cloneClasses = CloneStatistics.getAllClasses(g.getVersions());
        this.cIterator = this.cloneClasses.listIterator();
        this.buttonNextCloneClass.setEnabled(false);
        this.buttonNextFragment.setEnabled(false);
        this.buttonPrevCloneClass.setEnabled(false);
        this.buttonPrevFragment.setEnabled(false);
        this.nextCloneClass();
    }

    public void setChangeMode(ChangeMode m) {
        if (this.changeMode != m && this.cloneclass != null) {
            this.changeMode = m;
            this.modeChanged();
        }
    }

    private void adjust() {
        if (this.mode == Mode.BACKWARD) {
            this.rightSourcePanel.adjust();
            this.leftSourcePanel.adjust(this.rightSourcePanel.getTopIndex());
        } else if (this.mode == Mode.SINGLE) {
            this.leftSourcePanel.adjust();
            this.rightSourcePanel.adjust();
        } else if (this.mode == Mode.FORWARD) {
            this.leftSourcePanel.adjust();
            this.rightSourcePanel.adjust(this.leftSourcePanel.getTopIndex());
        }
        this.mappingPanel.redraw();
    }

    private void adjustLabels(CloneClass cc) {
        this.cloneclass = cc;
        this.tableFragments.removeAll();
        for (Fragment f : cc.getVisibleFragments()) {
            TableItem ti = new TableItem(this.tableFragments, 0);
            ti.setText(0, "");
            ti.setText(1, "" + f.getID());
            ti.setText(2, "" + f.getStartLine());
            ti.setText(3, "" + f.getEndLine());
            ti.setText(4, "" + f.getLength());
            ti.setText(5, "" + f.getRelativeFilePath());
        }
        this.tableFragments.getItem(0).setImage(0, CycloneFrame.getImage("leftArrow.png"));
        this.tableFragments.getItem(1).setImage(0, CycloneFrame.getImage("rightArrow.png"));
        for (int i = 0; i < this.tableFragments.getColumnCount(); ++i) {
            this.tableFragments.getColumn(i).pack();
        }
        if (this.form.getSize().y > 0) {
            int desiredHeight = Math.min(60, this.tableFragments.computeSize((int)-1, (int)-1).y * 100 / this.form.getSize().y);
            this.form.setWeights(new int[]{desiredHeight, 100 - desiredHeight});
        }
        this.layout();
    }

    private ToolItem createButton(ToolBar t, int type, String imageName, SelectionAdapter s) {
        ToolItem button = new ToolItem(t, type);
        button.setImage(CycloneFrame.getImage(imageName));
        button.addSelectionListener((SelectionListener)s);
        return button;
    }

    private void displayFragment(Fragment f) {
        this.fragment = f;
        if (this.mode == Mode.BACKWARD) {
            this.displayFragmentBackward(f);
        } else if (this.mode == Mode.FORWARD) {
            this.displayFragmentForward(f);
        } else {
            this.displayFragmentSingle(f);
        }
        this.adjust();
    }

    private void displayFragmentBackward(Fragment f) {
        Fragment a;
        for (int i = 0; i < this.tableFragments.getItemCount(); ++i) {
            if (this.tableFragments.getItem(i).getText(1).equals(f.getID() + "")) {
                this.tableFragments.getItem(i).setImage(0, CycloneFrame.getImage("leftRightArrow.png"));
                continue;
            }
            this.tableFragments.getItem(i).setImage(0, null);
        }
        this.leftSourcePanel.clearHighlight();
        this.rightSourcePanel.clearHighlight();
        this.mappingPanel.clearMappings();
        this.rightSourcePanel.setSourceContext(this.sourceContexts.get(f.getID()));
        this.labelRight.setText(f.getFile());
        if (f.getCloneClass().getRevision().previous() == null) {
            this.leftSourcePanel.setSourceContext(null);
            this.labelLeft.setText("No previous version available");
            return;
        }
        String changesFilename = f.getCloneClass().getRevision().getChangesFilename();
        changesFilename = Cyclone.makeNativePath(changesFilename);
        Fragment fragment = a = f.getAncestors().isEmpty() ? null : f.getAncestors().get(0);
        if (a != null && a.getCloneClass().getRevision().next().equals(f.getCloneClass().getRevision())) {
            this.leftSourcePanel.setSourceContext(new SourceContext(a));
            this.labelLeft.setText(a.getFile());
        } else {
            SourceFile sf;
            String relocateFrom = null;
            String relocateTo = null;
            try {
                BufferedReader r = new BufferedReader(new FileReader(changesFilename));
                String line = r.readLine();
                while (line != null) {
                    String[] tokens = line.split(" ");
                    if (tokens[0].equals("R") && f.getFile().contains(tokens[2])) {
                        relocateFrom = tokens[1];
                        relocateTo = tokens[2];
                    }
                    line = r.readLine();
                }
                r.close();
            }
            catch (IOException e) {
                Console.error("I cannot read changes from " + changesFilename);
            }
            String filename = f.getCloneClass().getRevision().previous().getPath() + f.getFile().substring(f.getCloneClass().getRevision().getPath().length());
            if (relocateTo != null) {
                filename = filename.replace(relocateTo, relocateFrom);
            }
            if ((sf = f.getCloneClass().getRevision().previous().getFromPath(filename)) == null) {
                this.leftSourcePanel.setSourceContext(null);
                this.labelLeft.setText("No previous version available");
                return;
            }
            this.leftSourcePanel.setSourceContext(new SourceContext(sf));
            this.labelLeft.setText(filename);
        }
        this.highlightChanges();
    }

    private void displayFragmentForward(Fragment f) {
        for (int i = 0; i < this.tableFragments.getItemCount(); ++i) {
            if (this.tableFragments.getItem(i).getText(1).equals(f.getID() + "")) {
                this.tableFragments.getItem(i).setImage(0, CycloneFrame.getImage("leftRightArrow.png"));
                continue;
            }
            this.tableFragments.getItem(i).setImage(0, null);
        }
        this.leftSourcePanel.clearHighlight();
        this.rightSourcePanel.clearHighlight();
        this.mappingPanel.clearMappings();
        this.leftSourcePanel.setSourceContext(this.sourceContexts.get(f.getID()));
        this.labelLeft.setText(f.getFile());
        if (f.getCloneClass().getRevision().next() == null) {
            this.rightSourcePanel.setSourceContext(null);
            this.labelRight.setText("No next version available");
            return;
        }
        String changesFilename = f.getCloneClass().getRevision().next().getChangesFilename();
        changesFilename = Cyclone.makeNativePath(changesFilename);
        Fragment d = f.getDescendant();
        if (d != null && d.getCloneClass().getRevision().previous().equals(f.getCloneClass().getRevision())) {
            this.rightSourcePanel.setSourceContext(new SourceContext(d));
            this.labelRight.setText(d.getFile());
        } else {
            SourceFile sf;
            String relocateFrom = null;
            String relocateTo = null;
            try {
                BufferedReader r = new BufferedReader(new FileReader(changesFilename));
                String line = r.readLine();
                while (line != null) {
                    String[] tokens = line.split(" ");
                    if (tokens[0].equals("R")) {
                        relocateFrom = tokens[1].substring(1, tokens[1].length() - 1);
                        if (f.getFile().contains(relocateFrom)) {
                            relocateTo = tokens[2].substring(1, tokens[2].length() - 1);
                            break;
                        }
                    }
                    line = r.readLine();
                }
                r.close();
            }
            catch (IOException e) {
                Console.error("I cannot read changes from " + changesFilename);
            }
            String filename = f.getCloneClass().getRevision().next().getPath() + f.getFile().substring(f.getCloneClass().getRevision().getPath().length());
            if (relocateTo != null) {
                filename = filename.replace(relocateFrom, relocateTo);
            }
            if ((sf = f.getCloneClass().getRevision().next().getFromPath(filename)) == null) {
                this.labelRight.setText("No next version available");
                this.rightSourcePanel.setSourceContext(null);
                return;
            }
            this.rightSourcePanel.setSourceContext(new SourceContext(sf));
            this.labelRight.setText(filename);
        }
        this.highlightChanges();
    }

    private void displayFragmentSingle(Fragment f) {
        this.tableFragments.getItem(0).setImage(0, CycloneFrame.getImage("leftArrow.png"));
        for (int i = 0; i < this.tableFragments.getItemCount(); ++i) {
            if (this.tableFragments.getItem(i).getText(1).equals(f.getID() + "")) {
                this.tableFragments.getItem(i).setImage(0, i == 0 ? CycloneFrame.getImage("leftRightArrow.png") : CycloneFrame.getImage("rightArrow.png"));
                continue;
            }
            this.tableFragments.getItem(i).setImage(0, i == 0 ? CycloneFrame.getImage("leftArrow.png") : null);
        }
        this.leftSourcePanel.clearHighlight();
        this.rightSourcePanel.clearHighlight();
        this.leftSourcePanel.setHighlightedLines(new HashMap<Integer, Color>());
        this.rightSourcePanel.setHighlightedLines(new HashMap<Integer, Color>());
        this.leftSourcePanel.setStrokes(new HashMap<Integer, Color>());
        this.rightSourcePanel.setStrokes(new HashMap<Integer, Color>());
        this.mappingPanel.clearMappings();
        Fragment rf = f.getCloneClass().getVisibleFragments().get(0);
        this.leftSourcePanel.setSourceContext(this.sourceContexts.get(rf.getID()));
        this.labelLeft.setText(rf.getFile());
        this.rightSourcePanel.setSourceContext(this.sourceContexts.get(f.getID()));
        this.labelRight.setText(f.getFile());
        if (this.sourceContexts.get(rf.getID()) != null && this.sourceContexts.get(f.getID()) != null) {
            if (this.changeMode == ChangeMode.TOKEN) {
                Set<IToken>[] diff = Diff.diff(this.leftSourcePanel.getFragmentTokens(), this.rightSourcePanel.getFragmentTokens());
                this.setHighlightedTokens(this.leftSourcePanel, diff[0], SourceCodePanel.COLOR_DELETION);
                this.setHighlightedTokens(this.rightSourcePanel, diff[1], SourceCodePanel.COLOR_ADDITION);
            } else if (this.changeMode == ChangeMode.LINE) {
                Patch p = DiffUtils.diff(this.leftSourcePanel.getFragmentLines(), this.rightSourcePanel.getFragmentLines());
                this.setHighlightedLines(p, this.leftSourcePanel.getFragment().getStartLine(), this.rightSourcePanel.getFragment().getStartLine());
            }
        }
    }

    private void highlightChanges() {
        if (this.changeMode == ChangeMode.TOKEN) {
            Set<IToken>[] diff = Diff.diff(this.leftSourcePanel.getFileTokens(), this.rightSourcePanel.getFileTokens());
            this.setHighlightedTokens(this.leftSourcePanel, diff[0], SourceCodePanel.COLOR_DELETION);
            this.setHighlightedTokens(this.rightSourcePanel, diff[1], SourceCodePanel.COLOR_ADDITION);
        } else if (this.changeMode == ChangeMode.LINE) {
            this.setHighlightedLines(DiffUtils.diff(this.leftSourcePanel.getFileLines(), this.rightSourcePanel.getFileLines()), 1, 1);
        }
    }

    private void loadFragments(CloneClass cc) {
        this.sourceContexts.clear();
        for (Fragment f : cc.getVisibleFragments()) {
            assert (f != null);
            SourceContext sc = new SourceContext(f);
            this.sourceContexts.put(f.getID(), sc.isValid() ? sc : null);
        }
    }

    private void modeChanged() {
        this.buttonModeBackward.setSelection(this.mode == Mode.BACKWARD);
        this.buttonModeSingle.setSelection(this.mode == Mode.SINGLE);
        this.buttonModeForward.setSelection(this.mode == Mode.FORWARD);
        if (this.buttonSVNLog != null) {
            this.buttonSVNLog.setEnabled(this.mode != Mode.SINGLE);
        }
        this.displayFragment(this.fragment);
    }

    private void nextCloneClass() {
        if (this.cIterator.hasNext()) {
            CloneClass cc = this.cIterator.next();
            Controller.classSelectionChanged(cc, null);
        }
    }

    private void nextFragment() {
        this.buttonPrevFragment.setEnabled(true);
        Fragment f = this.fIterator.next();
        this.buttonNextFragment.setEnabled(this.fIterator.hasNext());
        this.displayFragment(f);
    }

    private CloneClass findNext(ListIterator<CloneClass> iter, boolean inconsitent, boolean consistent) {
        while (iter.hasNext()) {
            CloneClass cc = iter.next();
            if (!(inconsitent && consistent && cc.isChanged() || inconsitent && cc.isInconsistentlyChanged()) && (!consistent || !cc.isConsistentlyChanged())) continue;
            return cc;
        }
        return null;
    }

    private CloneClass findPrev(ListIterator<CloneClass> iter, boolean inconsitent, boolean consistent) {
        while (iter.hasPrevious()) {
            CloneClass cc = iter.previous();
            if (!(inconsitent && consistent && cc.isChanged() || inconsitent && cc.isInconsistentlyChanged()) && (!consistent || !cc.isConsistentlyChanged())) continue;
            return cc;
        }
        return null;
    }

    private void updateCCButtons() {
        if (this.cIterator == null) {
            this.buttonNextInconsistentCloneClass.setEnabled(false);
            this.buttonNextConsistentCloneClass.setEnabled(false);
            this.buttonNextChangedCloneClass.setEnabled(false);
            this.buttonPrevInconsistentCloneClass.setEnabled(false);
            this.buttonPrevConsistentCloneClass.setEnabled(false);
            this.buttonPrevChangedCloneClass.setEnabled(false);
            this.buttonNextCloneClass.setEnabled(false);
            this.buttonPrevCloneClass.setEnabled(false);
        } else {
            this.buttonNextInconsistentCloneClass.setEnabled(this.findNext(this.cloneClasses.listIterator(this.cIterator.nextIndex()), true, false) != null);
            this.buttonNextConsistentCloneClass.setEnabled(this.findNext(this.cloneClasses.listIterator(this.cIterator.nextIndex()), false, true) != null);
            this.buttonNextChangedCloneClass.setEnabled(this.buttonNextInconsistentCloneClass.isEnabled() || this.buttonNextConsistentCloneClass.isEnabled());
            this.buttonPrevInconsistentCloneClass.setEnabled(this.findPrev(this.cloneClasses.listIterator(this.cIterator.previousIndex()), true, false) != null);
            this.buttonPrevConsistentCloneClass.setEnabled(this.findPrev(this.cloneClasses.listIterator(this.cIterator.previousIndex()), false, true) != null);
            this.buttonPrevChangedCloneClass.setEnabled(this.buttonPrevInconsistentCloneClass.isEnabled() || this.buttonPrevConsistentCloneClass.isEnabled());
            this.buttonNextCloneClass.setEnabled(this.cIterator.hasNext());
            ListIterator<CloneClass> iter = this.cloneClasses.listIterator(this.cIterator.previousIndex());
            this.buttonPrevCloneClass.setEnabled(iter.hasPrevious());
        }
    }

    private void nextChangedCloneClass(boolean inconsitent, boolean consistent) {
        ListIterator<CloneClass> iter = this.cloneClasses.listIterator(this.cIterator.nextIndex());
        CloneClass cc = this.findNext(iter, inconsitent, consistent);
        if (cc == null) {
            Console.error("There was no appropriate next clone class found even though the button was enabled.");
        } else {
            this.cIterator = iter;
            Controller.classSelectionChanged(cc, null);
        }
    }

    private void randomCloneClass() {
        ArrayList<CloneClass> ccsOfVersion = new ArrayList<CloneClass>(this.cloneclass.getRevision().getCloneClasses().values());
        int range = ccsOfVersion.size();
        CloneClass rCC = this.cloneclass;
        while (range > 1 && rCC.equals(this.cloneclass)) {
            int i = this.randomGenerator.nextInt(range);
            rCC = ccsOfVersion.get(i);
        }
        Controller.classSelectionChanged(rCC, null);
    }

    private void previousCloneClass() {
        this.cIterator.previous();
        CloneClass cc = this.cIterator.previous();
        this.cIterator.next();
        Controller.classSelectionChanged(cc, null);
    }

    private void previousFragment() {
        this.buttonNextFragment.setEnabled(true);
        this.fIterator.previous();
        Fragment f = this.fIterator.previous();
        this.buttonPrevFragment.setEnabled(this.fIterator.hasPrevious());
        this.fIterator.next();
        this.displayFragment(f);
    }

    private void prevChangedCloneClass(boolean inconsitent, boolean consistent) {
        ListIterator<CloneClass> iter = this.cloneClasses.listIterator(this.cIterator.previousIndex());
        CloneClass cc = this.findPrev(iter, inconsitent, consistent);
        if (cc == null) {
            Console.error("There was no appropriate previous clone class found even though the button was enabled.");
        } else {
            this.cIterator = iter;
            this.cIterator.next();
            Controller.classSelectionChanged(cc, null);
        }
    }

    private void setHighlightedLines(Patch p, int leftStart, int rightStart) {
        HashMap<Integer, Color> leftLines = new HashMap<Integer, Color>();
        HashMap<Integer, Color> rightLines = new HashMap<Integer, Color>();
        HashMap<Integer, Color> leftStrokes = new HashMap<Integer, Color>();
        HashMap<Integer, Color> rightStrokes = new HashMap<Integer, Color>();
        for (Delta d : p.getDeltas()) {
            int i;
            Color c = d.getOriginal().getSize() == 0 ? SourceCodePanel.COLOR_ADDITION : (d.getRevised().getSize() == 0 ? SourceCodePanel.COLOR_DELETION : SourceCodePanel.COLOR_CHANGE);
            for (i = 0; i < d.getOriginal().getSize(); ++i) {
                leftLines.put(d.getOriginal().getPosition() + i + leftStart, c);
            }
            if (d.getRevised().getSize() == 0) {
                rightStrokes.put(d.getRevised().getPosition() + rightStart, c);
            }
            for (i = 0; i < d.getRevised().getSize(); ++i) {
                rightLines.put(d.getRevised().getPosition() + i + rightStart, c);
            }
            if (d.getOriginal().getSize() == 0) {
                leftStrokes.put(d.getOriginal().getPosition() + leftStart, c);
            }
            this.mappingPanel.addMapping(d.getOriginal().getPosition() + leftStart, d.getOriginal().getPosition() + leftStart + d.getOriginal().getSize(), d.getRevised().getPosition() + rightStart, d.getRevised().getPosition() + rightStart + d.getRevised().getSize(), c);
        }
        this.leftSourcePanel.setHighlightedLines(leftLines);
        this.leftSourcePanel.setStrokes(leftStrokes);
        this.rightSourcePanel.setHighlightedLines(rightLines);
        this.rightSourcePanel.setStrokes(rightStrokes);
    }

    private void setHighlightedTokens(SourceCodePanel p, Set<IToken> tokens, Color c) {
        HashMap<IToken, Color> highlight = new HashMap<IToken, Color>();
        for (IToken t : tokens) {
            highlight.put(t, c);
        }
        p.setHighlightedTokens(highlight);
    }

    private void showSVNLog() {
        String from = this.leftSourcePanel.getSourceFile().getVersion().getPath();
        from = from.substring(from.lastIndexOf(47) + 1);
        String to = this.rightSourcePanel.getSourceFile().getVersion().getPath();
        to = to.substring(to.lastIndexOf(47) + 1);
        String file = this.rightSourcePanel.getSourceFile().getName();
        try {
            from = Integer.parseInt(from) + 1 + "";
            Dialog.showMessageDialog(this.getShell(), "SVN log", SVNReader.getLog(from, to, file));
        }
        catch (NumberFormatException nfe) {
            Console.error("Cannot get revision form path: \"" + this.leftSourcePanel.getSourceFile().getVersion().getPath() + "\"");
        }
    }

    public static enum ChangeMode {
        LINE,
        TOKEN;

    }

    private static enum Mode {
        FORWARD,
        BACKWARD,
        SINGLE;

    }
}

