/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.source;

import de.uni_bremen.st.cyclone.ui.source.SourceCodePanel;
import java.util.LinkedList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MappingPanel
extends Canvas {
    private static final long serialVersionUID = 0L;
    private static int mappingWidth = 200;
    private SourceCodePanel leftSource = null;
    private SourceCodePanel rightSource = null;
    private LinkedList<Mapping> mappings = new LinkedList();

    public MappingPanel(Composite owner, SourceCodePanel leftSource, SourceCodePanel rightSource) {
        super(owner, 0);
        this.leftSource = leftSource;
        this.rightSource = rightSource;
        this.setSize(mappingWidth, this.getSize().y);
        this.setBackground(this.getDisplay().getSystemColor(2));
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                MappingPanel.this.paint(e.gc);
            }
        });
    }

    public void setSourcePanels(SourceCodePanel leftSource, SourceCodePanel rightSource) {
        this.leftSource = leftSource;
        this.rightSource = rightSource;
    }

    public void addMapping(int sourceStartLine, int sourceEndLine, int ghostStartLine, int ghostEndLine, Color color) {
        this.mappings.add(new Mapping(sourceStartLine, sourceEndLine, ghostStartLine, ghostEndLine, color));
    }

    public void clearMappings() {
        this.mappings.clear();
    }

    public void paint(GC gc) {
        gc.setBackground(this.getDisplay().getSystemColor(2));
        gc.fillRectangle(this.getBounds());
        mappingWidth = this.getSize().x;
        if (this.leftSource == null) {
            return;
        }
        for (Mapping m : this.mappings) {
            if (!this.leftSource.isInScope(m.sourceStartLine, m.sourceEndLine) && !this.rightSource.isInScope(m.ghostStartLine, m.ghostEndLine)) continue;
            gc.setBackground(m.color);
            int[] points = new int[]{0, this.leftSource.getY(m.sourceStartLine), mappingWidth, this.rightSource.getY(m.ghostStartLine), mappingWidth, this.rightSource.getY(m.ghostEndLine), 0, this.leftSource.getY(m.sourceEndLine)};
            gc.fillPolygon(points);
        }
    }

    private static class Mapping {
        private int sourceStartLine = 0;
        private int sourceEndLine = 0;
        private int ghostStartLine = 0;
        private int ghostEndLine = 0;
        private Color color = null;

        public Mapping(int sourceStartLine, int sourceEndLine, int ghostStartLine, int ghostEndLine, Color color) {
            this.sourceStartLine = sourceStartLine;
            this.sourceEndLine = sourceEndLine;
            this.ghostStartLine = ghostStartLine;
            this.ghostEndLine = ghostEndLine;
            this.color = color;
        }
    }
}

