/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.source;

import de.uni_bremen.st.cyclone.clones.Fragment;
import de.uni_bremen.st.cyclone.clones.SourceContext;
import de.uni_bremen.st.cyclone.system.SourceFile;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.source.MappingPanel;
import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.IToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SourceCodePanel {
    private static final long serialVersionUID = 0L;
    public static final Color COLOR_DIFF = new Color((Device)Display.getCurrent(), 255, 255, 128);
    public static final Color COLOR_CHANGE = new Color((Device)Display.getCurrent(), 220, 220, 255);
    public static final Color COLOR_ADDITION = new Color((Device)Display.getCurrent(), 220, 255, 220);
    public static final Color COLOR_DELETION = new Color((Device)Display.getCurrent(), 255, 220, 220);
    private static final Color COLOR_DEFAULT = Display.getCurrent().getSystemColor(1);
    private static final Color COLOR_TEXT = Display.getCurrent().getSystemColor(2);
    private static final Color COLOR_COMMENT = new Color((Device)Display.getCurrent(), 192, 192, 192);
    private static final Color COLOR_SHADE = new Color((Device)Display.getCurrent(), 128, 128, 128);
    private static final Color COLOR_KEYWORD = Display.getCurrent().getSystemColor(9);
    private static final Color COLOR_LITERAL = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private final Font FONT;
    private SourceContext sourceContext = null;
    private Map<Integer, Color> strokes = new HashMap<Integer, Color>();
    private StyledText st;
    private StyledText ln;
    private Map<IToken, Color> highlight;
    private MappingPanel mp;

    public SourceCodePanel(Composite owner) {
        this.FONT = System.getProperty("os.name").toLowerCase().contains("win") ? new Font((Device)owner.getDisplay(), "Courier New", 11, 0) : new Font((Device)owner.getDisplay(), "Bitstream Vera Sans Mono", 11, 0);
        this.ln = new StyledText(owner, 8);
        this.ln.setBackground(COLOR_SHADE);
        this.ln.setForeground(COLOR_COMMENT);
        this.ln.setFont(this.FONT);
        GridData layoutData = new GridData(4, 4, false, true);
        layoutData.widthHint = 0;
        this.ln.setLayoutData((Object)layoutData);
        this.ln.setEnabled(false);
        this.ln.setTopMargin(10);
        this.st = new StyledText(owner, 776);
        this.st.setBackground(COLOR_DEFAULT);
        this.st.setFont(this.FONT);
        this.st.setLayoutData((Object)new GridData(4, 4, true, true));
        this.st.setIndent(10);
        this.st.setTopMargin(10);
        ((GridData)this.st.getLayoutData()).widthHint = 200;
        this.st.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceCodePanel.this.ln.setTopPixel(SourceCodePanel.this.st.getTopPixel());
                if (SourceCodePanel.this.mp != null) {
                    SourceCodePanel.this.mp.redraw();
                }
            }
        });
        this.st.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                SourceCodePanel.this.paintStrokes(e.gc);
            }
        });
    }

    public void adjust() {
        if (this.sourceContext != null) {
            assert (this.sourceContext.hasFragment());
            this.adjust(Math.max(0, this.getFragment().getStartLine() - 4));
        }
    }

    public void adjust(int line) {
        this.st.setTopIndex(line);
        this.ln.setTopPixel(this.st.getTopPixel());
    }

    public void clearHighlight() {
        this.highlight = new HashMap<IToken, Color>();
        this.displaySource();
    }

    public List<String> getFileLines() {
        assert (this.sourceContext != null);
        return this.sourceContext.getFileLines();
    }

    public List<IToken> getFileTokens() {
        assert (this.sourceContext != null);
        return this.sourceContext.getFileTokens();
    }

    public Fragment getFragment() {
        if (this.sourceContext == null) {
            return null;
        }
        assert (this.sourceContext.hasFragment());
        return this.sourceContext.getFragment();
    }

    public List<String> getFragmentLines() {
        assert (this.sourceContext != null);
        assert (this.sourceContext.hasFragment());
        return this.sourceContext.getFragmentLines();
    }

    public List<IToken> getFragmentTokens() {
        assert (this.sourceContext != null);
        assert (this.sourceContext.hasFragment());
        return this.sourceContext.getFragmentTokens();
    }

    public SourceFile getSourceFile() {
        if (this.sourceContext == null) {
            return null;
        }
        return this.sourceContext.getSourceFile();
    }

    public int getTopIndex() {
        return this.st.getTopIndex();
    }

    public int getY(int lineNumber) {
        return this.st.getLinePixel(lineNumber - 1);
    }

    public boolean isInScope(int startLine, int endLine) {
        int firstLine = this.st.getLineIndex(0) + 1;
        int lastLine = this.st.getLineIndex(this.st.getSize().y) + 1;
        return endLine >= firstLine && startLine <= lastLine;
    }

    public void setHighlightedLines(Map<Integer, Color> highlightedLines) {
        this.displaySource();
        for (Map.Entry<Integer, Color> hl : highlightedLines.entrySet()) {
            this.st.setLineBackground(hl.getKey() - 1, 1, hl.getValue());
        }
    }

    public void setHighlightedTokens(Map<IToken, Color> highlight) {
        this.highlight = highlight;
        this.displaySource();
    }

    public void setMappingPanel(MappingPanel mp) {
        this.mp = mp;
    }

    public void setSourceContext(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
        this.highlight = new HashMap<IToken, Color>();
        this.displaySource();
    }

    public void setStrokes(Map<Integer, Color> strokes) {
        this.strokes = strokes;
    }

    private void displaySource() {
        this.ln.setText("");
        this.st.setText("");
        if (this.sourceContext == null) {
            return;
        }
        this.st.setText(this.sourceContext.getText());
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        for (IToken t : this.sourceContext.getFileTokens()) {
            StyleRange sr = new StyleRange();
            sr.start = t.getOffset();
            sr.length = t.getText().length();
            if (!this.sourceContext.hasFragment() || this.sourceContext.getFragment().isWithin(t.getOffset(), t.getLineNumber() + 1)) {
                ETokenType type = t.getType();
                if (type.isKeyword()) {
                    sr.foreground = COLOR_KEYWORD;
                    sr.fontStyle = 1;
                } else {
                    sr.foreground = type.getTokenClass() == ETokenType.ETokenClass.COMMENT ? COLOR_COMMENT : (type.isLiteral() ? COLOR_LITERAL : COLOR_TEXT);
                }
            } else {
                sr.foreground = COLOR_COMMENT;
            }
            if (this.highlight.containsKey(t)) {
                sr.background = this.highlight.get(t);
            }
            styles.add(sr);
        }
        StyleRange[] ranges = styles.toArray(new StyleRange[styles.size()]);
        try {
            this.st.setStyleRanges(ranges);
        }
        catch (IllegalArgumentException e) {
            Console.error("I have a problem applying syntax highlighting!");
        }
        StringBuffer sb = new StringBuffer("");
        int n = this.sourceContext.getLOC();
        for (int i = 1; i <= n; ++i) {
            if (i < 10 && n >= 10) {
                sb.append(" ");
            }
            if (i < 100 && n >= 100) {
                sb.append(" ");
            }
            if (i < 1000 && n >= 1000) {
                sb.append(" ");
            }
            if (i < 10000 && n >= 10000) {
                sb.append(" ");
            }
            sb.append("" + i + " \n");
        }
        sb.append("\n");
        this.ln.setText(sb.toString());
        this.ln.setLineIndent(0, this.ln.getLineCount(), 20);
        ((GridData)this.ln.getLayoutData()).widthHint = 20 + 20 * (int)Math.log10(this.sourceContext.getLOC());
        this.ln.getParent().layout();
        if (this.sourceContext.hasFragment()) {
            this.adjust();
        }
    }

    private void paintStrokes(GC gc) {
        for (Map.Entry<Integer, Color> e : this.strokes.entrySet()) {
            if (!this.isInScope(e.getKey(), e.getKey())) continue;
            gc.setForeground(e.getValue());
            int y = this.st.getLinePixel(e.getKey() - 1);
            gc.drawLine(0, y, this.st.getSize().x, y);
        }
    }
}

