/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.treemap;

import de.uni_bremen.st.cyclone.Cyclone;
import de.uni_bremen.st.cyclone.clones.CloneEvolutionGraph;
import de.uni_bremen.st.cyclone.control.CloneEvolutionGraphListener;
import de.uni_bremen.st.cyclone.system.Directory;
import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.system.Version;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.treemap.CloneCoverage;
import de.uni_bremen.st.cyclone.ui.treemap.Metric;
import de.uni_bremen.st.cyclone.ui.treemap.NumberOfFragments;
import de.uni_bremen.st.cyclone.ui.treemap.SystemPanel;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabItem;

public class SystemCtrlPanel
extends Composite
implements CloneEvolutionGraphListener {
    private static final long serialVersionUID = 0L;
    private Directory sources = null;
    private List<Version> revisions;
    private Version selectedRevision = null;
    private Map<String, Metric> metrics = new TreeMap<String, Metric>();
    private Combo cbVersions;
    private Combo cbMetrics;
    private Button chbOutline;
    private Button chbFiles;
    private Button chbAllLinks;
    private Spinner spDepth;
    private SystemPanel panel;
    private int maxDepth = 1;
    Button btnResetRoot;
    private Label lEntity;

    public SystemCtrlPanel(TabItem owner) {
        super((Composite)owner.getParent(), 0);
        owner.setControl((Control)this);
        GridLayout gl = new GridLayout();
        gl.numColumns = 9;
        this.setLayout((Layout)gl);
        Label label = new Label((Composite)this, 0);
        label.setText("Version:");
        this.cbVersions = new Combo((Composite)this, 8);
        this.cbVersions.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cbVersions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemCtrlPanel.this.versionChanged();
                SystemCtrlPanel.this.readSources();
            }
        });
        if (!Cyclone.isRelease()) {
            this.cbMetrics = new Combo((Composite)this, 8);
            this.cbMetrics.setLayoutData((Object)new GridData(4, 2, false, false));
            Metric m = new CloneCoverage();
            String defaultMetric = m.toString();
            this.metrics.put(m.toString(), m);
            m = new NumberOfFragments();
            this.metrics.put(m.toString(), m);
            for (String s : this.metrics.keySet()) {
                this.cbMetrics.add(s);
            }
            this.cbMetrics.select(this.cbMetrics.indexOf(defaultMetric));
            this.cbMetrics.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    Entity.metric = (Metric)SystemCtrlPanel.this.metrics.get(SystemCtrlPanel.this.cbMetrics.getItem(SystemCtrlPanel.this.cbMetrics.getSelectionIndex()));
                    SystemCtrlPanel.this.panel.redraw();
                }
            });
        }
        label = new Label((Composite)this, 0);
        label.setText("    Entity:  ");
        this.lEntity = new Label((Composite)this, 0);
        this.lEntity.setText("");
        this.lEntity.setLayoutData((Object)new GridData(4, 2, true, false));
        if (!Cyclone.isRelease()) {
            this.chbAllLinks = new Button((Composite)this, 32);
            this.chbAllLinks.setText("all links");
            this.chbAllLinks.setToolTipText("If this button is checked and no file is selceted, all links between the files are displayed.");
            this.chbAllLinks.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    SystemCtrlPanel.this.panel.setPaintAllLinks(SystemCtrlPanel.this.chbAllLinks.getSelection());
                }
            });
        }
        label = new Label((Composite)this, 0);
        label.setText("Depth: ");
        this.spDepth = new Spinner((Composite)this, 0);
        this.spDepth.setIncrement(1);
        this.spDepth.setMinimum(1);
        this.spDepth.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (SystemCtrlPanel.this.spDepth.getSelection() > SystemCtrlPanel.this.maxDepth) {
                    SystemCtrlPanel.this.spDepth.setSelection(SystemCtrlPanel.this.maxDepth);
                }
                SystemCtrlPanel.this.panel.setMaxPaintDepth(SystemCtrlPanel.this.spDepth.getSelection());
            }
        });
        this.btnResetRoot = new Button((Composite)this, 8);
        this.btnResetRoot.setText("Reset Root");
        this.btnResetRoot.setEnabled(false);
        this.btnResetRoot.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Entity sel = SystemCtrlPanel.this.panel.getSelectedEntity();
                SystemCtrlPanel.this.panel.setSources(SystemCtrlPanel.this.sources);
                Console.debug("source set to " + SystemCtrlPanel.this.sources.getPath());
                if (sel != null) {
                    SystemCtrlPanel.this.panel.setSelectedEntity(sel);
                }
                SystemCtrlPanel.this.btnResetRoot.setEnabled(false);
            }
        });
        this.chbFiles = new Button((Composite)this, 32);
        this.chbFiles.setText("Show Files");
        this.chbFiles.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemCtrlPanel.this.panel.setPaintFileOutline(!SystemCtrlPanel.this.chbFiles.getSelection());
            }
        });
        this.chbOutline = new Button((Composite)this, 32);
        this.chbOutline.setText("Show Directories");
        this.chbOutline.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemCtrlPanel.this.panel.setPaintDirectoryOutline(!SystemCtrlPanel.this.chbOutline.getSelection());
            }
        });
        this.panel = new SystemPanel(this);
        this.panel.setLayoutData(new GridData(4, 4, true, true, gl.numColumns, 1));
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                SystemCtrlPanel.this.readSources();
            }
        });
    }

    @Override
    public void cloneEvolutionGraphChanged(CloneEvolutionGraph g) {
        this.revisions = g.getVersions();
        this.cbVersions.removeAll();
        for (Version r : this.revisions) {
            this.cbVersions.add(r.getID() + " " + r.getPath());
        }
        if (this.revisions.isEmpty()) {
            this.selectedRevision = null;
            return;
        }
        this.cbVersions.select(0);
        if (this.selectedRevision != this.revisions.get(0)) {
            this.selectedRevision = this.revisions.size() > 0 ? this.revisions.get(0) : null;
        }
        this.layout();
        this.redraw();
    }

    public void versionChanged() {
        this.btnResetRoot.setEnabled(false);
        if (this.cbVersions.getSelectionIndex() >= 0) {
            this.selectedRevision = this.revisions.get(this.cbVersions.getSelectionIndex());
        }
    }

    public void setEntityLabelText(String t) {
        this.lEntity.setText(t);
    }

    private void readSources() {
        if (this.selectedRevision != null) {
            this.sources = this.selectedRevision.getSource();
            this.maxDepth = this.sources.getMaxDepth();
            this.panel.setSources(this.sources);
            this.spDepth.setSelection(this.maxDepth);
        }
    }
}

