/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.ui.treemap;

import de.uni_bremen.st.cyclone.system.Directory;
import de.uni_bremen.st.cyclone.system.Entity;
import de.uni_bremen.st.cyclone.ui.Console;
import de.uni_bremen.st.cyclone.ui.treemap.SystemCtrlPanel;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SystemPanel
extends Canvas {
    private static final long serialVersionUID = 0L;
    private Directory sources = null;
    private boolean paintDirectoryOutline = false;
    private boolean paintFileOutline = false;
    private boolean paintAllLinks = false;
    private int maxDepth = Integer.MAX_VALUE;
    private Entity selectedEntity = null;
    private SystemCtrlPanel scp = null;

    public SystemPanel(SystemCtrlPanel owner) {
        super((Composite)owner, 0);
        this.scp = owner;
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (SystemPanel.this.sources == null) {
                    return;
                }
                if (e.button == 3) {
                    Entity sel = SystemPanel.this.sources.getAt(e.x, e.y, SystemPanel.this.maxDepth);
                    if (sel != null && sel instanceof Directory) {
                        Menu menu = new Menu((Decorations)SystemPanel.this.getShell(), 8);
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText("Become Root");
                        item.addListener(13, (Listener)new ContextMenuListener(sel){

                            public void handleEvent(Event e) {
                                SystemPanel.this.setSources((Directory)this.context);
                                ((SystemPanel)SystemPanel.this).scp.btnResetRoot.setEnabled(true);
                            }
                        });
                        menu.setLocation(SystemPanel.this.toDisplay(e.x, e.y));
                        menu.setVisible(true);
                    }
                } else if (e.button == 2) {
                    SystemPanel.this.deselectEntity();
                } else {
                    SystemPanel.this.printInfo(e.x, e.y);
                    SystemPanel.this.selectEntity(SystemPanel.this.sources, e.x, e.y);
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                if (SystemPanel.this.sources != null) {
                    Entity en = SystemPanel.this.sources.getAt(e.x, e.y, SystemPanel.this.maxDepth);
                    if (en != null) {
                        SystemPanel.this.scp.setEntityLabelText(en.getPath().substring(SystemPanel.this.sources.getPath().length()));
                    } else {
                        SystemPanel.this.scp.setEntityLabelText("");
                    }
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                SystemPanel.this.paint(e.gc);
            }
        });
        this.setBackground(this.getDisplay().getSystemColor(1));
    }

    public void setMaxPaintDepth(int max) {
        this.maxDepth = max;
        this.deselectEntity();
        this.redraw();
    }

    public void setSources(Directory sources) {
        this.sources = sources;
        this.deselectEntity();
        this.scp.setEntityLabelText(sources.getPath());
        this.redraw();
    }

    public void setPaintDirectoryOutline(boolean paintDirectoryOutline) {
        this.paintDirectoryOutline = paintDirectoryOutline;
        this.redraw();
    }

    public void setPaintFileOutline(boolean paintFileOutline) {
        this.paintFileOutline = paintFileOutline;
        this.redraw();
    }

    public void setPaintAllLinks(boolean paintAllLinks) {
        this.paintAllLinks = paintAllLinks;
        this.redraw();
    }

    public void paint(GC gc) {
        if (this.sources == null) {
            return;
        }
        this.sources.paintForTreemap(gc, new Rectangle(0, 0, this.getSize().x, this.getSize().y), true, this.maxDepth);
        if (this.paintFileOutline) {
            this.sources.paintOutline(gc, false, true, this.maxDepth);
        }
        if (this.paintDirectoryOutline) {
            this.sources.paintOutline(gc, true, false, this.maxDepth);
        }
        if (this.selectedEntity != null) {
            this.selectedEntity.paintLinks(gc, this.sources.getDepth(), this.maxDepth);
        } else if (this.paintAllLinks) {
            for (Entity e : this.sources.getEntities()) {
                e.paintLinksRecursive(gc, this.sources.getDepth(), this.maxDepth);
            }
        }
    }

    public void printInfo(int x, int y) {
        if (this.sources == null) {
            return;
        }
        Entity e = this.sources.getAt(x, y, this.maxDepth);
        if (e == null) {
            return;
        }
        Console.message("\n" + e.getPath() + ", " + e.getCLOC() + "/" + e.getLOC() + " = " + (double)((int)(e.getCloneCoverage() * 10000.0)) / 100.0 + "%");
    }

    private void selectEntity(Entity e, int x, int y) {
        if (e != null) {
            if (this.selectedEntity != null) {
                this.selectedEntity.deselect();
            }
            this.selectedEntity = e.getAt(x, y, this.maxDepth);
            if (this.selectedEntity != null) {
                this.selectedEntity.select(this.maxDepth);
                this.redraw();
            }
        }
    }

    private void deselectEntity() {
        if (this.selectedEntity != null) {
            this.selectedEntity.deselect();
            this.selectedEntity = null;
            this.redraw();
        }
    }

    public Entity getSelectedEntity() {
        return this.selectedEntity;
    }

    public void setSelectedEntity(Entity e) {
        if (e != null) {
            if (this.selectedEntity != null) {
                this.selectedEntity.deselect();
            }
            this.selectedEntity = e;
            this.selectedEntity.select(this.maxDepth);
            this.redraw();
        }
    }

    private abstract class ContextMenuListener
    implements Listener {
        protected Entity context;

        public ContextMenuListener(Entity context) {
            this.context = context;
        }
    }
}

