/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.util;

import de.uni_bremen.st.cyclone.control.ProgressListener;
import java.util.LinkedList;

public class Counter {
    private LinkedList<ProgressListener> pListeners = new LinkedList();
    private int count;
    private int end;
    private boolean cancelled = false;

    public Counter(int start, int end) {
        this.count = start;
        this.end = end;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        this.pListeners.add(pl);
    }

    public synchronized void increment(int delta) {
        this.count += delta;
        for (ProgressListener pl : this.pListeners) {
            pl.progressMade(1.0 * (double)this.count / (double)this.end);
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }
}

