/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.util;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import edu.tum.cs.scanner.IToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Diff {
    public static Set<IToken>[] diff(List<IToken> a, List<IToken> b) {
        Set[] result = new Set[]{new HashSet(), new HashSet()};
        ArrayList<Token> at = new ArrayList<Token>();
        ArrayList<Token> bt = new ArrayList<Token>();
        for (IToken t : a) {
            at.add(new Token(t));
        }
        for (IToken t : b) {
            bt.add(new Token(t));
        }
        Patch p = DiffUtils.diff(at, bt);
        for (Delta d : p.getDeltas()) {
            int i;
            for (i = 0; i < d.getOriginal().getSize(); ++i) {
                result[0].add(a.get(d.getOriginal().getPosition() + i));
            }
            for (i = 0; i < d.getRevised().getSize(); ++i) {
                result[1].add(b.get(d.getRevised().getPosition() + i));
            }
        }
        return result;
    }

    private static class Token {
        public IToken token;

        public Token(IToken t) {
            this.token = t;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Token)) {
                return false;
            }
            Token o = (Token)other;
            if (this.token.getType() != o.token.getType()) {
                return false;
            }
            if (this.token.getType().isIdentifier() || this.token.getType().isLiteral()) {
                return this.token.getText().equals(o.token.getText());
            }
            return true;
        }
    }

    public static enum Type {
        ADD,
        DEL,
        MOD;

    }
}

