/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Statistics {
    public static double getMean(List<Number> values) {
        double sum = 0.0;
        for (Number n : values) {
            sum += n.doubleValue();
        }
        return values.size() == 0 ? 0.0 : sum / (double)values.size();
    }

    public static double getMedian(List<Number> values) {
        if (values.size() == 0) {
            return 0.0;
        }
        Collections.sort(values, new Comparator<Number>(){

            @Override
            public int compare(Number m, Number n) {
                double b;
                double a = m.doubleValue();
                return a < (b = n.doubleValue()) ? -1 : (a > b ? 1 : 0);
            }
        });
        int m = values.size() / 2;
        return values.size() % 2 == 0 ? (values.get(m - 1).doubleValue() + values.get(m).doubleValue()) / 2.0 : values.get(m).doubleValue();
    }

    public static double getStandardDeviationMean(List<Number> values) {
        return Statistics.getStandardDeviation(values, Statistics.getMean(values));
    }

    public static double getStandardDeviationMedian(List<Number> values) {
        return Statistics.getStandardDeviation(values, Statistics.getMedian(values));
    }

    private static double getStandardDeviation(List<Number> values, double average) {
        double d = 0.0;
        for (Number n : values) {
            d += Math.pow(n.doubleValue() - average, 2.0);
        }
        return Math.sqrt(d / (double)values.size());
    }
}

