/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.cyclone.util.math;

public class Vector2D {
    private double x;
    private double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D normalize() {
        double length = this.length();
        return new Vector2D(this.x / length, this.y / length);
    }

    public Vector2D rotate(double rad) {
        return new Vector2D(this.x * Math.cos(rad) - this.y * Math.sin(rad), this.y * Math.cos(rad) + this.x * Math.sin(rad));
    }

    public Vector2D multiply(double d) {
        return new Vector2D(this.x * d, this.y * d);
    }

    public Vector2D minus(Vector2D v) {
        return new Vector2D(this.x - v.getX(), this.y - v.getY());
    }

    public Vector2D plus(Vector2D v) {
        return new Vector2D(this.x + v.getX(), this.y + v.getY());
    }
}

