/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SWTEventObject;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;

class AccessibleObject {
    int handle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static int actionNamePtr = -1;
    static int descriptionPtr = -1;
    static int keybindingPtr = -1;
    static int namePtr = -1;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final boolean DEBUG = Device.DEBUG;
    static final int ROW_ROLE = ATK.atk_role_register(Converter.wcsToMbcs(null, "row", true));
    static final int COLUMN_ROLE = ATK.atk_role_register(Converter.wcsToMbcs(null, "column", true));

    AccessibleObject(int n, int n2, Accessible accessible, boolean bl) {
        this.handle = ATK.g_object_new(n, 0);
        ATK.atk_object_initialize(this.handle, n2);
        this.accessible = accessible;
        this.isLightweight = bl;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            AccessibleObject.print("new AccessibleObject: " + this.handle + " control=" + accessible.control + " lw=" + bl);
        }
    }

    static void print(String string) {
        System.out.println(string);
    }

    static AtkActionIface getActionIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface atkActionIface = new AtkActionIface();
            ATK.memmove(atkActionIface, ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(n)));
            return atkActionIface;
        }
        return null;
    }

    static int atkAction_do_action(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_do_action");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleActionListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)((Vector)object).elementAt(n4);
                    accessibleActionListener.doAction(accessibleActionEvent);
                    ++n4;
                }
                return "OK".equals(accessibleActionEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getActionIface(n);
        if (object != null && ((AtkActionIface)object).do_action != 0) {
            n5 = ATK.call(((AtkActionIface)object).do_action, n, n2);
        }
        return n5;
    }

    static int atkAction_get_n_actions(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_n_actions");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleActionListeners;
            int n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)((Vector)object).elementAt(n3);
                    accessibleActionListener.getActionCount(accessibleActionEvent);
                    ++n3;
                }
                return accessibleActionEvent.count;
            }
        }
        int n4 = 0;
        object = AccessibleObject.getActionIface(n);
        if (object != null && ((AtkActionIface)object).get_n_actions != 0) {
            n4 = ATK.call(((AtkActionIface)object).get_n_actions, n);
        }
        return n4;
    }

    static int atkAction_get_description(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_description");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleActionListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)((Vector)object).elementAt(n4);
                    accessibleActionListener.getDescription(accessibleActionEvent);
                    ++n4;
                }
                if (accessibleActionEvent.result == null) {
                    return 0;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleActionEvent.result);
                return descriptionPtr;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getActionIface(n);
        if (object != null && ((AtkActionIface)object).get_description != 0) {
            n5 = ATK.call(((AtkActionIface)object).get_description, n, n2);
        }
        return n5;
    }

    static int atkAction_get_keybinding(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_keybinding");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(n);
        if (atkActionIface != null && atkActionIface.get_keybinding != 0) {
            n3 = ATK.call(atkActionIface.get_keybinding, n, n2);
        }
        if (accessibleObject != null) {
            SWTEventListener sWTEventListener;
            int n4;
            SWTEventObject sWTEventObject;
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                sWTEventObject = new AccessibleActionEvent(accessible);
                sWTEventObject.index = n2;
                n4 = 0;
                while (n4 < n5) {
                    sWTEventListener = (AccessibleActionListener)vector.elementAt(n4);
                    sWTEventListener.getKeyBinding((AccessibleActionEvent)sWTEventObject);
                    ++n4;
                }
                if (sWTEventObject.result != null) {
                    if (keybindingPtr != -1) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(sWTEventObject.result);
                    return keybindingPtr;
                }
            }
            if ((n5 = (vector = accessible.accessibleListeners).size()) > 0) {
                sWTEventObject = new AccessibleEvent(accessible);
                ((AccessibleEvent)sWTEventObject).childID = accessibleObject.id;
                if (n3 != 0) {
                    ((AccessibleEvent)sWTEventObject).result = AccessibleObject.getString(n3);
                }
                n4 = 0;
                while (n4 < n5) {
                    sWTEventListener = (AccessibleListener)vector.elementAt(n4);
                    sWTEventListener.getKeyboardShortcut((AccessibleEvent)sWTEventObject);
                    ++n4;
                }
                if (((AccessibleEvent)sWTEventObject).result != null) {
                    if (keybindingPtr != -1) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(((AccessibleEvent)sWTEventObject).result);
                    return keybindingPtr;
                }
            }
        }
        return n3;
    }

    static int atkAction_get_name(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_name");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(n);
        if (atkActionIface != null && atkActionIface.get_name != 0) {
            n3 = ATK.call(atkActionIface.get_name, n, n2);
        }
        if (accessibleObject != null) {
            SWTEventListener sWTEventListener;
            int n4;
            SWTEventObject sWTEventObject;
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                sWTEventObject = new AccessibleActionEvent(accessible);
                sWTEventObject.index = n2;
                n4 = 0;
                while (n4 < n5) {
                    sWTEventListener = (AccessibleActionListener)vector.elementAt(n4);
                    sWTEventListener.getName((AccessibleActionEvent)sWTEventObject);
                    ++n4;
                }
                if (sWTEventObject.result != null) {
                    if (actionNamePtr != -1) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(sWTEventObject.result);
                    return actionNamePtr;
                }
            }
            if (n2 == 0 && (n5 = (vector = accessible.accessibleControlListeners).size()) > 0) {
                sWTEventObject = new AccessibleControlEvent(accessible);
                ((AccessibleControlEvent)sWTEventObject).childID = accessibleObject.id;
                if (n3 != 0) {
                    ((AccessibleControlEvent)sWTEventObject).result = AccessibleObject.getString(n3);
                }
                n4 = 0;
                while (n4 < n5) {
                    sWTEventListener = (AccessibleControlListener)vector.elementAt(n4);
                    sWTEventListener.getDefaultAction((AccessibleControlEvent)sWTEventObject);
                    ++n4;
                }
                if (((AccessibleControlEvent)sWTEventObject).result != null) {
                    if (actionNamePtr != -1) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(((AccessibleControlEvent)sWTEventObject).result);
                    return actionNamePtr;
                }
            }
        }
        return n3;
    }

    static AtkComponentIface getComponentIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface atkComponentIface = new AtkComponentIface();
            ATK.memmove(atkComponentIface, ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(n)));
            return atkComponentIface;
        }
        return null;
    }

    static int atkComponent_get_extents(int n, int n2, int n3, int n4, int n5, int n6) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_extents: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        OS.memmove(n4, new int[1], 4);
        OS.memmove(n5, new int[1], 4);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(n);
        if (atkComponentIface != null && atkComponentIface.get_extents != 0) {
            ATK.call(atkComponentIface.get_extents, n, n2, n3, n4, n5, n6);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n7 = vector.size();
            if (n7 > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.memmove(nArray, n2, 4);
                OS.memmove(nArray2, n3, 4);
                OS.memmove(nArray3, n4, 4);
                OS.memmove(nArray4, n5, 4);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                accessibleControlEvent.width = nArray3[0];
                accessibleControlEvent.height = nArray4[0];
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[1];
                if (n6 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray5, nArray6);
                    accessibleControlEvent.x += nArray5[0];
                    accessibleControlEvent.y += nArray6[0];
                }
                int n8 = 0;
                while (n8 < n7) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n8);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n8;
                }
                if (n6 == 1) {
                    accessibleControlEvent.x -= nArray5[0];
                    accessibleControlEvent.y -= nArray6[0];
                }
                OS.memmove(n2, new int[]{accessibleControlEvent.x}, 4);
                OS.memmove(n3, new int[]{accessibleControlEvent.y}, 4);
                OS.memmove(n4, new int[]{accessibleControlEvent.width}, 4);
                OS.memmove(n5, new int[]{accessibleControlEvent.height}, 4);
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.x + "," + accessibleControlEvent.y + "," + accessibleControlEvent.width + "x" + accessibleControlEvent.height);
                }
            }
        }
        return 0;
    }

    static int atkComponent_get_position(int n, int n2, int n3, int n4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_position, object: " + n + " x: " + n2 + " y: " + n3 + " coord: " + n4);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(n);
        if (atkComponentIface != null && atkComponentIface.get_position != 0) {
            ATK.call(atkComponentIface.get_position, n, n2, n3, n4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, n2, 4);
                OS.memmove(nArray2, n3, 4);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                if (n4 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray3, nArray4);
                    accessibleControlEvent.x += nArray3[0];
                    accessibleControlEvent.y += nArray4[0];
                }
                int n6 = 0;
                while (n6 < n5) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n6;
                }
                if (n4 == 1) {
                    accessibleControlEvent.x -= nArray3[0];
                    accessibleControlEvent.y -= nArray4[0];
                }
                OS.memmove(n2, new int[]{accessibleControlEvent.x}, 4);
                OS.memmove(n3, new int[]{accessibleControlEvent.y}, 4);
            }
        }
        return 0;
    }

    static int atkComponent_get_size(int n, int n2, int n3, int n4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_size");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(n);
        if (atkComponentIface != null && atkComponentIface.get_size != 0) {
            ATK.call(atkComponentIface.get_size, n, n2, n3, n4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, n2, 4);
                OS.memmove(nArray2, n3, 4);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.width = nArray[0];
                accessibleControlEvent.height = nArray2[0];
                int n6 = 0;
                while (n6 < n5) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n6;
                }
                OS.memmove(n2, new int[]{accessibleControlEvent.width}, 4);
                OS.memmove(n3, new int[]{accessibleControlEvent.height}, 4);
            }
        }
        return 0;
    }

    static int atkComponent_ref_accessible_at_point(int n, int n2, int n3, int n4) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_ref_accessible_at_point: " + n + " " + n2 + "," + n3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleControlListeners;
            int n5 = ((Vector)object).size();
            if (n5 > 0) {
                Accessible accessible2;
                Object object2;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = n2;
                accessibleControlEvent.y = n3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (n4 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleControlEvent.x += nArray[0];
                    accessibleControlEvent.y += nArray2[0];
                }
                int n6 = 0;
                while (n6 < n5) {
                    object2 = (AccessibleControlListener)((Vector)object).elementAt(n6);
                    object2.getChildAtPoint(accessibleControlEvent);
                    ++n6;
                }
                if (accessibleControlEvent.childID == accessibleObject.id) {
                    accessibleControlEvent.childID = -1;
                }
                Object object3 = object2 = (accessible2 = accessibleControlEvent.accessible) != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object2 != null) {
                    return OS.g_object_ref(((AccessibleObject)object2).handle);
                }
            }
        }
        int n7 = 0;
        object = AccessibleObject.getComponentIface(n);
        if (object != null && ((AtkComponentIface)object).ref_accessible_at_point != 0) {
            n7 = ATK.call(((AtkComponentIface)object).ref_accessible_at_point, n, n2, n3, n4);
        }
        return n7;
    }

    static AtkHypertextIface getHypertextIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface atkHypertextIface = new AtkHypertextIface();
            ATK.memmove(atkHypertextIface, ATK.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(n)));
            return atkHypertextIface;
        }
        return null;
    }

    static int atkHypertext_get_link(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n4);
                    accessibleTextExtendedListener.getHyperlink(accessibleTextEvent);
                    ++n4;
                }
                Accessible accessible2 = accessibleTextEvent.accessible;
                return accessible2 != null ? accessible2.getAccessibleObject().handle : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getHypertextIface(n);
        if (object != null && ((AtkHypertextIface)object).get_link != 0) {
            n5 = ATK.call(((AtkHypertextIface)object).get_link, n, n2);
        }
        return n5;
    }

    static int atkHypertext_get_n_links(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_n_links");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n3);
                    accessibleTextExtendedListener.getHyperlinkCount(accessibleTextEvent);
                    ++n3;
                }
                return accessibleTextEvent.count;
            }
        }
        int n4 = 0;
        object = AccessibleObject.getHypertextIface(n);
        if (object != null && ((AtkHypertextIface)object).get_n_links != 0) {
            n4 = ATK.call(((AtkHypertextIface)object).get_n_links, n);
        }
        return n4;
    }

    static int atkHypertext_get_link_index(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link_index");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.offset = n2;
                accessibleTextEvent.index = -1;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n4);
                    accessibleTextExtendedListener.getHyperlinkIndex(accessibleTextEvent);
                    ++n4;
                }
                return accessibleTextEvent.index;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getHypertextIface(n);
        if (object != null && ((AtkHypertextIface)object).get_link_index != 0) {
            n5 = ATK.call(((AtkHypertextIface)object).get_link_index, n, n2);
        }
        return n5;
    }

    static AtkObjectClass getObjectClass(int n) {
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, ATK.g_type_class_peek(OS.g_type_parent(OS.G_OBJECT_TYPE(n))));
        return atkObjectClass;
    }

    static int atkObject_get_description(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_description: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.get_description != 0) {
            n2 = ATK.call(atkObjectClass.get_description, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (n2 != 0) {
                    accessibleEvent.result = AccessibleObject.getString(n2);
                }
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleListener accessibleListener = (AccessibleListener)vector.elementAt(n4);
                    accessibleListener.getDescription(accessibleEvent);
                    ++n4;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return n2;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return descriptionPtr;
            }
        }
        return n2;
    }

    static int atkObject_get_attributes(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_attributes: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.get_attributes != 0) {
            n2 = ATK.call(atkObjectClass.get_attributes, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleAttributeListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(accessible);
                accessibleAttributeEvent.indent = -1;
                accessibleAttributeEvent.alignment = -1;
                accessibleAttributeEvent.rightMargin = -1;
                accessibleAttributeEvent.leftMargin = -1;
                accessibleAttributeEvent.bottomMargin = -1;
                accessibleAttributeEvent.topMargin = -1;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)vector.elementAt(n4);
                    accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
                    ++n4;
                }
                AtkAttribute atkAttribute = new AtkAttribute();
                if (accessibleAttributeEvent.leftMargin != -1) {
                    int n5 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(1));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.leftMargin));
                    ATK.memmove(n5, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n5);
                }
                if (accessibleAttributeEvent.rightMargin != -1) {
                    int n6 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(2));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.rightMargin));
                    ATK.memmove(n6, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n6);
                }
                if (accessibleAttributeEvent.topMargin != -1) {
                    int n7 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("top-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.topMargin));
                    ATK.memmove(n7, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n7);
                }
                if (accessibleAttributeEvent.bottomMargin != -1) {
                    int n8 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("bottom-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.bottomMargin));
                    ATK.memmove(n8, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n8);
                }
                if (accessibleAttributeEvent.indent != -1) {
                    int n9 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(3));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.indent));
                    ATK.memmove(n9, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n9);
                }
                if (accessibleAttributeEvent.justify) {
                    int n10 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    atkAttribute.value = AccessibleObject.getStringPtr("fill");
                    ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n10);
                } else if (accessibleAttributeEvent.alignment != -1) {
                    int n11 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    String string = "left";
                    switch (accessibleAttributeEvent.alignment) {
                        case 16384: {
                            string = "left";
                            break;
                        }
                        case 131072: {
                            string = "right";
                            break;
                        }
                        case 0x1000000: {
                            string = "center";
                        }
                    }
                    atkAttribute.value = AccessibleObject.getStringPtr(string);
                    ATK.memmove(n11, atkAttribute, AtkAttribute.sizeof);
                    n2 = OS.g_list_append(n2, n11);
                }
                if (accessibleAttributeEvent.attributes != null) {
                    int n12 = accessibleAttributeEvent.attributes.length / 2 * 2;
                    int n13 = 0;
                    while (n13 < n12) {
                        int n14 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[n13]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[n13 + 1]);
                        ATK.memmove(n14, atkAttribute, AtkAttribute.sizeof);
                        n2 = OS.g_list_append(n2, n14);
                        n13 += 2;
                    }
                }
            }
        }
        return n2;
    }

    static int atkObject_get_name(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_name: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.get_name != 0) {
            n2 = ATK.call(atkObjectClass.get_name, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (n2 != 0) {
                    accessibleEvent.result = AccessibleObject.getString(n2);
                }
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleListener accessibleListener = (AccessibleListener)vector.elementAt(n4);
                    accessibleListener.getName(accessibleEvent);
                    ++n4;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return n2;
                }
                if (namePtr != -1) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return namePtr;
            }
        }
        return n2;
    }

    static int atkObject_get_n_children(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_n_children: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.get_n_children != 0) {
            n2 = ATK.call(atkObjectClass.get_n_children, n);
        }
        if (accessibleObject != null && accessibleObject.id == -1) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n4);
                    accessibleControlListener.getChildCount(accessibleControlEvent);
                    ++n4;
                }
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.detail);
                }
                return accessibleControlEvent.detail;
            }
        }
        return n2;
    }

    static int atkObject_get_index_in_parent(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_index_in_parent: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
            accessibleControlEvent.childID = -5;
            accessibleControlEvent.detail = -1;
            int n2 = 0;
            while (n2 < vector.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                accessibleControlListener.getChild(accessibleControlEvent);
                ++n2;
            }
            if (accessibleControlEvent.detail != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleControlEvent.detail;
            }
            if (accessibleObject.index != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleObject.index;
            }
        }
        object = AccessibleObject.getObjectClass(n);
        if (((AtkObjectClass)object).get_index_in_parent == 0) {
            return 0;
        }
        int n3 = ATK.call(((AtkObjectClass)object).get_index_in_parent, n);
        if (DEBUG) {
            AccessibleObject.print("---*> " + n3);
        }
        return n3;
    }

    static int atkObject_get_parent(int n) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_parent: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null && accessibleObject.parent != null) {
            if (DEBUG) {
                AccessibleObject.print("---> " + accessibleObject.parent.accessible.accessibleObject.handle);
            }
            return accessibleObject.parent.handle;
        }
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.get_parent == 0) {
            return 0;
        }
        int n2 = ATK.call(atkObjectClass.get_parent, n);
        if (DEBUG) {
            AccessibleObject.print("---> " + n2);
        }
        return n2;
    }

    static int atkObject_get_role(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_role: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            int n2 = vector.size();
            if (n2 > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n3);
                    accessibleControlListener.getRole(accessibleControlEvent);
                    ++n3;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleControlEvent.detail);
                }
                if (accessibleControlEvent.detail != -1) {
                    switch (accessibleControlEvent.detail) {
                        case 44: {
                            return 7;
                        }
                        case 10: {
                            return 18;
                        }
                        case 46: {
                            return 11;
                        }
                        case 18: {
                            return 16;
                        }
                        case 41: {
                            return 28;
                        }
                        case 30: {
                            return 60;
                        }
                        case 33: {
                            return 30;
                        }
                        case 34: {
                            return 31;
                        }
                        case 11: {
                            return 32;
                        }
                        case 2: {
                            return 33;
                        }
                        case 12: {
                            return 34;
                        }
                        case 48: {
                            return 41;
                        }
                        case 43: {
                            return 42;
                        }
                        case 3: {
                            return 47;
                        }
                        case 21: {
                            return 49;
                        }
                        case 51: {
                            return 50;
                        }
                        case 24: {
                            return 54;
                        }
                        case 29: {
                            return 55;
                        }
                        case 25: {
                            return 56;
                        }
                        case 26: {
                            return 57;
                        }
                        case 60: {
                            return 37;
                        }
                        case 37: {
                            return 36;
                        }
                        case 42: {
                            return 60;
                        }
                        case 22: {
                            return 62;
                        }
                        case 13: {
                            return 63;
                        }
                        case 35: {
                            return 64;
                        }
                        case 36: {
                            return 31;
                        }
                        case 45: {
                            return 43;
                        }
                        case 62: {
                            return 42;
                        }
                        case 9: {
                            return 68;
                        }
                        case 28: {
                            return ROW_ROLE;
                        }
                        case 27: {
                            return COLUMN_ROLE;
                        }
                        case 8: {
                            return 2;
                        }
                        case 54: {
                            return 3;
                        }
                        case 1025: {
                            return 6;
                        }
                        case 20: {
                            return 38;
                        }
                        case 52: {
                            return 52;
                        }
                        case 23: {
                            return 53;
                        }
                        case 1027: {
                            return 8;
                        }
                        case 1073: {
                            return 44;
                        }
                        case 61: {
                            return 66;
                        }
                        case 47: {
                            return 4;
                        }
                        case 1029: {
                            return 12;
                        }
                        case 1038: {
                            return 70;
                        }
                        case 1040: {
                            return 85;
                        }
                        case 1043: {
                            return 69;
                        }
                        case 1044: {
                            return 81;
                        }
                        case 1053: {
                            return 82;
                        }
                        case 1054: {
                            return 71;
                        }
                        case 1060: {
                            return 83;
                        }
                        case 15: {
                            return 80;
                        }
                        case 40: {
                            return 26;
                        }
                    }
                }
            }
        }
        object = AccessibleObject.getObjectClass(n);
        if (((AtkObjectClass)object).get_role == 0) {
            return 0;
        }
        return ATK.call(((AtkObjectClass)object).get_role, n);
    }

    static int atkObject_ref_child(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_child: " + n2 + " of: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null && accessibleObject.id == -1) {
            Object object2;
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleObject accessibleObject2;
                object2 = new AccessibleControlEvent(object);
                ((AccessibleControlEvent)object2).childID = -4;
                ((AccessibleControlEvent)object2).detail = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n4);
                    accessibleControlListener.getChild((AccessibleControlEvent)object2);
                    ++n4;
                }
                if (((AccessibleControlEvent)object2).accessible != null && (accessibleObject2 = ((AccessibleControlEvent)object2).accessible.getAccessibleObject()) != null) {
                    return OS.g_object_ref(accessibleObject2.handle);
                }
            }
            accessibleObject.updateChildren();
            object2 = accessibleObject.getChildByIndex(n2);
            if (object2 != null) {
                return OS.g_object_ref(((AccessibleObject)object2).handle);
            }
        }
        object = AccessibleObject.getObjectClass(n);
        if (((AtkObjectClass)object).ref_child == 0) {
            return 0;
        }
        return ATK.call(((AtkObjectClass)object).ref_child, n, n2);
    }

    static int atkObject_ref_state_set(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_state_set: " + n);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(n);
        if (atkObjectClass.ref_state_set != 0) {
            n2 = ATK.call(atkObjectClass.ref_state_set, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                int n4 = n2;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                int n5 = 0;
                while (n5 < n3) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n5);
                    accessibleControlListener.getState(accessibleControlEvent);
                    ++n5;
                }
                if (accessibleControlEvent.detail != -1) {
                    n5 = accessibleControlEvent.detail;
                    if ((n5 & 0x800) != 0) {
                        ATK.atk_state_set_add_state(n4, 3);
                    }
                    if ((n5 & 0x10) != 0) {
                        ATK.atk_state_set_add_state(n4, 4);
                    }
                    if ((n5 & 0x200) != 0) {
                        ATK.atk_state_set_add_state(n4, 9);
                    }
                    if ((n5 & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(n4, 10);
                    }
                    if ((n5 & 4) != 0) {
                        ATK.atk_state_set_add_state(n4, 11);
                    }
                    if ((n5 & 0x80) != 0) {
                        ATK.atk_state_set_add_state(n4, 2);
                    }
                    if ((n5 & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(n4, 28);
                    }
                    if ((n5 & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 16);
                    }
                    if ((n5 & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(n4, 23);
                    }
                    if ((n5 & 8) != 0) {
                        ATK.atk_state_set_add_state(n4, 18);
                    }
                    if ((n5 & 0x40) == 0) {
                        ATK.atk_state_set_add_state(n4, 6);
                    }
                    if ((n5 & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(n4, 20);
                    }
                    if ((n5 & 2) != 0) {
                        ATK.atk_state_set_add_state(n4, 21);
                    }
                    if ((n5 & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(n4, 19);
                    }
                    if ((n5 & 1) == 0) {
                        ATK.atk_state_set_add_state(n4, 7);
                    }
                    if ((n5 & 0x4000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 1);
                    }
                    if ((n5 & 0x8000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 24);
                    }
                    if ((n5 & 0x10000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 15);
                    }
                    if ((n5 & 0x2000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 32);
                    }
                    if ((n5 & 0x20000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 33);
                    }
                    if ((n5 & 0x40000000) != 0) {
                        ATK.atk_state_set_add_state(n4, 34);
                    }
                }
                return n4;
            }
        }
        return n2;
    }

    static AtkSelectionIface getSelectionIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
            ATK.memmove(atkSelectionIface, ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(n)));
            return atkSelectionIface;
        }
        return null;
    }

    static int atkSelection_is_child_selected(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_is_child_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(n);
        if (atkSelectionIface != null && atkSelectionIface.is_child_selected != 0) {
            n3 = ATK.call(atkSelectionIface.is_child_selected, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                Object object;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                int n5 = 0;
                while (n5 < n4) {
                    object = (AccessibleControlListener)vector.elementAt(n5);
                    object.getSelection(accessibleControlEvent);
                    ++n5;
                }
                Accessible accessible2 = accessibleControlEvent.accessible;
                Object object2 = object = accessible2 != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object != null) {
                    return ((AccessibleObject)object).index == n2 ? 1 : 0;
                }
            }
        }
        return n3;
    }

    static int atkSelection_ref_selection(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_ref_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(n);
        if (atkSelectionIface != null && atkSelectionIface.ref_selection != 0) {
            n3 = ATK.call(atkSelectionIface.ref_selection, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n5);
                    accessibleControlListener.getSelection(accessibleControlEvent);
                    ++n5;
                }
                AccessibleObject accessibleObject2 = accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (accessibleObject2 != null) {
                    if (n3 != 0) {
                        OS.g_object_unref(n3);
                    }
                    OS.g_object_ref(accessibleObject2.handle);
                    return accessibleObject2.handle;
                }
            }
        }
        return n3;
    }

    static AtkTableIface getTableIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface atkTableIface = new AtkTableIface();
            ATK.memmove(atkTableIface, ATK.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(n)));
            return atkTableIface;
        }
        return null;
    }

    static int atkTable_ref_at(int n, int n2, int n3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_ref_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n4 = ((Vector)object).size();
            if (n4 > 0) {
                Object object2;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                accessibleTableEvent.column = n3;
                int n5 = 0;
                while (n5 < n4) {
                    object2 = (AccessibleTableListener)((Vector)object).elementAt(n5);
                    object2.getCell(accessibleTableEvent);
                    ++n5;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    object2 = accessible2.getAccessibleObject();
                    OS.g_object_ref(((AccessibleObject)object2).handle);
                    return ((AccessibleObject)object2).handle;
                }
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).ref_at != 0) {
            n6 = ATK.call(((AtkTableIface)object).ref_at, n, n2, n3);
        }
        return n6;
    }

    static int atkTable_get_index_at(int n, int n2, int n3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_index_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n4 = ((Vector)object).size();
            if (n4 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                accessibleTableEvent.column = n3;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n5);
                    accessibleTableListener.getCell(accessibleTableEvent);
                    ++n5;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 == null) {
                    return -1;
                }
                accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n6 = 0;
                while (n6 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n6);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n6;
                }
                return n2 * accessibleTableEvent.count + n3;
            }
        }
        int n7 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_index_at != 0) {
            n7 = ATK.call(((AtkTableIface)object).get_index_at, n, n2, n3);
        }
        return n7;
    }

    static int atkTable_get_column_at_index(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_at_index: " + n + " " + n2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n4;
                }
                int n5 = n4 = accessibleTableEvent.count == 0 ? -1 : n2 % accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + n4);
                }
                return n4;
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_column_at_index != 0) {
            n6 = ATK.call(((AtkTableIface)object).get_column_at_index, n, n2);
        }
        return n6;
    }

    static int atkTable_get_row_at_index(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_at_index: " + n + " " + n2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n4;
                }
                int n5 = n4 = accessibleTableEvent.count == 0 ? -1 : n2 / accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + n4);
                }
                return n4;
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_row_at_index != 0) {
            n6 = ATK.call(((AtkTableIface)object).get_row_at_index, n, n2);
        }
        return n6;
    }

    static int atkTable_get_n_columns(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_columns");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_n_columns != 0) {
            n2 = ATK.call(atkTableIface.get_n_columns, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n4);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    n2 = accessibleTableEvent.count;
                    ++n4;
                }
            }
        }
        return n2;
    }

    static int atkTable_get_n_rows(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_rows");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_n_rows != 0) {
            n2 = ATK.call(atkTableIface.get_n_rows, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n4);
                    accessibleTableListener.getRowCount(accessibleTableEvent);
                    n2 = accessibleTableEvent.count;
                    ++n4;
                }
            }
        }
        return n2;
    }

    static int atkTable_get_column_extent_at(int n, int n2, int n3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n4 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_column_extent_at != 0) {
            n4 = ATK.call(atkTableIface.get_column_extent_at, n, n2, n3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                accessibleTableEvent.column = n3;
                int n6 = 0;
                while (n6 < n5) {
                    object = (AccessibleTableListener)vector.elementAt(n6);
                    object.getCell(accessibleTableEvent);
                    ++n6;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n5 = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).count = n4;
                    int n7 = 0;
                    while (n7 < n5) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n7);
                        accessibleTableCellListener.getColumnSpan((AccessibleTableCellEvent)object);
                        ++n7;
                    }
                    return ((AccessibleTableCellEvent)object).count;
                }
            }
        }
        return n4;
    }

    static int atkTable_get_row_extent_at(int n, int n2, int n3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n4 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_row_extent_at != 0) {
            n4 = ATK.call(atkTableIface.get_row_extent_at, n, n2, n3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                accessibleTableEvent.column = n3;
                int n6 = 0;
                while (n6 < n5) {
                    object = (AccessibleTableListener)vector.elementAt(n6);
                    object.getCell(accessibleTableEvent);
                    ++n6;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n5 = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).count = n4;
                    int n7 = 0;
                    while (n7 < n5) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n7);
                        accessibleTableCellListener.getRowSpan((AccessibleTableCellEvent)object);
                        ++n7;
                    }
                    return ((AccessibleTableCellEvent)object).count;
                }
            }
        }
        return n4;
    }

    static int atkTable_get_caption(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_caption");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n3);
                    accessibleTableListener.getCaption(accessibleTableEvent);
                    ++n3;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        int n4 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_caption != 0) {
            n4 = ATK.call(((AtkTableIface)object).get_caption, n);
        }
        return n4;
    }

    static int atkTable_get_summary(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_summary");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n3);
                    accessibleTableListener.getSummary(accessibleTableEvent);
                    ++n3;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        int n4 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_summary != 0) {
            n4 = ATK.call(((AtkTableIface)object).get_summary, n);
        }
        return n4;
    }

    static int atkTable_get_column_description(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_column_description != 0) {
            n3 = ATK.call(atkTableIface.get_column_description, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = n2;
                if (n3 != 0) {
                    accessibleTableEvent.result = AccessibleObject.getString(n3);
                }
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n5);
                    accessibleTableListener.getColumnDescription(accessibleTableEvent);
                    ++n5;
                }
                if (accessibleTableEvent.result == null) {
                    return n3;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return n3;
    }

    static int atkTable_get_column_header(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                    ++n4;
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && n2 >= 0 && n2 < accessibleArray.length) {
                    return accessibleArray[n2].getAccessibleObject().handle;
                }
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_column_header != 0) {
            n5 = ATK.call(((AtkTableIface)object).get_column_header, n, n2);
        }
        return n5;
    }

    static int atkTable_get_row_description(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.get_row_description != 0) {
            n3 = ATK.call(atkTableIface.get_row_description, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                if (n3 != 0) {
                    accessibleTableEvent.result = AccessibleObject.getString(n3);
                }
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n5);
                    accessibleTableListener.getRowDescription(accessibleTableEvent);
                    ++n5;
                }
                if (accessibleTableEvent.result == null) {
                    return n3;
                }
                if (descriptionPtr != -1) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return n3;
    }

    static int atkTable_get_row_header(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                    ++n4;
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && n2 >= 0 && n2 < accessibleArray.length) {
                    return accessibleArray[n2].getAccessibleObject().handle;
                }
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_row_header != 0) {
            n5 = ATK.call(((AtkTableIface)object).get_row_header, n, n2);
        }
        return n5;
    }

    static int atkTable_get_selected_columns(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_columns");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getSelectedColumns(accessibleTableEvent);
                    ++n4;
                }
                n4 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                int n5 = OS.g_malloc(n4 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(n5, accessibleTableEvent.selected, n4 * 4);
                }
                if (n2 != 0) {
                    OS.memmove(n2, new int[]{n5}, C.PTR_SIZEOF);
                }
                return n4;
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_selected_columns != 0) {
            n6 = ATK.call(((AtkTableIface)object).get_selected_columns, n, n2);
        }
        return n6;
    }

    static int atkTable_get_selected_rows(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_rows");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.getSelectedRows(accessibleTableEvent);
                    ++n4;
                }
                n4 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                int n5 = OS.g_malloc(n4 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(n5, accessibleTableEvent.selected, n4 * 4);
                }
                if (n2 != 0) {
                    OS.memmove(n2, new int[]{n5}, C.PTR_SIZEOF);
                }
                return n4;
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).get_selected_rows != 0) {
            n6 = ATK.call(((AtkTableIface)object).get_selected_rows, n, n2);
        }
        return n6;
    }

    static int atkTable_is_column_selected(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_column_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.is_column_selected != 0) {
            n3 = ATK.call(atkTableIface.is_column_selected, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = n3 != 0;
                accessibleTableEvent.column = n2;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n5);
                    accessibleTableListener.isColumnSelected(accessibleTableEvent);
                    ++n5;
                }
                return accessibleTableEvent.isSelected ? 1 : 0;
            }
        }
        return n3;
    }

    static int atkTable_is_row_selected(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_row_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n3 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.is_row_selected != 0) {
            n3 = ATK.call(atkTableIface.is_row_selected, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = n3 != 0;
                accessibleTableEvent.row = n2;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n5);
                    accessibleTableListener.isRowSelected(accessibleTableEvent);
                    ++n5;
                }
                return accessibleTableEvent.isSelected ? 1 : 0;
            }
        }
        return n3;
    }

    static int atkTable_is_selected(int n, int n2, int n3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n4 = 0;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(n);
        if (atkTableIface != null && atkTableIface.is_selected != 0) {
            n4 = ATK.call(atkTableIface.is_selected, n, n2, n3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n5 = vector.size();
            if (n5 > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                accessibleTableEvent.column = n3;
                int n6 = 0;
                while (n6 < n5) {
                    object = (AccessibleTableListener)vector.elementAt(n6);
                    object.getCell(accessibleTableEvent);
                    ++n6;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n5 = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).isSelected = n4 != 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n7);
                        accessibleTableCellListener.isSelected((AccessibleTableCellEvent)object);
                        ++n7;
                    }
                    return ((AccessibleTableCellEvent)object).isSelected ? 1 : 0;
                }
            }
        }
        return n4;
    }

    static int atkTable_add_row_selection(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.selectRow(accessibleTableEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).add_row_selection != 0) {
            n5 = ATK.call(((AtkTableIface)object).add_row_selection, n, n2);
        }
        return n5;
    }

    static int atkTable_remove_row_selection(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.deselectRow(accessibleTableEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).remove_row_selection != 0) {
            n5 = ATK.call(((AtkTableIface)object).remove_row_selection, n, n2);
        }
        return n5;
    }

    static int atkTable_add_column_selection(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.selectColumn(accessibleTableEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).add_column_selection != 0) {
            n5 = ATK.call(((AtkTableIface)object).add_column_selection, n, n2);
        }
        return n5;
    }

    static int atkTable_remove_column_selection(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTableListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)((Vector)object).elementAt(n4);
                    accessibleTableListener.deselectColumn(accessibleTableEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTableIface(n);
        if (object != null && ((AtkTableIface)object).remove_column_selection != 0) {
            n5 = ATK.call(((AtkTableIface)object).remove_column_selection, n, n2);
        }
        return n5;
    }

    static AtkTextIface getTextIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(n)));
            return atkTextIface;
        }
        return null;
    }

    static int atkText_get_character_extents(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n8 = vector.size();
            if (n8 > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n2 + 1;
                int n9 = 0;
                while (n9 < n8) {
                    object2 = (AccessibleTextExtendedListener)vector.elementAt(n9);
                    object2.getTextBounds(accessibleTextEvent);
                    ++n9;
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (n7 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                OS.memmove(n3, new int[]{accessibleTextEvent.x}, 4);
                OS.memmove(n4, new int[]{accessibleTextEvent.y}, 4);
                OS.memmove(n5, new int[]{accessibleTextEvent.width}, 4);
                OS.memmove(n6, new int[]{accessibleTextEvent.height}, 4);
                return 0;
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_character_extents != 0) {
            ATK.call(((AtkTextIface)object).get_character_extents, n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    static String getString(int n) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    static int getStringPtr(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string != null ? string : "", true);
        int n = OS.g_malloc(byArray.length);
        OS.memmove(n, byArray, byArray.length);
        return n;
    }

    static int atkText_get_range_extents(int n, int n2, int n3, int n4, int n5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_range_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n6 = vector.size();
            if (n6 > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n3;
                int n7 = 0;
                while (n7 < n6) {
                    object2 = (AccessibleTextExtendedListener)vector.elementAt(n7);
                    object2.getTextBounds(accessibleTextEvent);
                    ++n7;
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (n4 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                atkTextRectangle.x = accessibleTextEvent.x;
                atkTextRectangle.y = accessibleTextEvent.y;
                atkTextRectangle.width = accessibleTextEvent.width;
                atkTextRectangle.height = accessibleTextEvent.height;
                ATK.memmove(n5, atkTextRectangle, AtkTextRectangle.sizeof);
                return 0;
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_range_extents != 0) {
            ATK.call(((AtkTextIface)object).get_range_extents, n, n2, n3, n4, n5);
        }
        return 0;
    }

    static int atkText_get_run_attributes(int n, int n2, int n3, int n4) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_run_attributes");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleAttributeListeners;
            int n5 = ((Vector)object).size();
            if (n5 > 0) {
                int n6;
                AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(accessible);
                accessibleTextAttributeEvent.offset = n2;
                int n7 = 0;
                while (n7 < n5) {
                    AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)((Vector)object).elementAt(n7);
                    accessibleAttributeListener.getTextAttributes(accessibleTextAttributeEvent);
                    ++n7;
                }
                OS.memmove(n3, new int[]{accessibleTextAttributeEvent.start}, 4);
                OS.memmove(n4, new int[]{accessibleTextAttributeEvent.end}, 4);
                TextStyle textStyle = accessibleTextAttributeEvent.textStyle;
                int n8 = 0;
                AtkAttribute atkAttribute = new AtkAttribute();
                if (textStyle != null) {
                    Color color;
                    Font font;
                    int n9;
                    if (textStyle.rise != 0) {
                        n9 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(10));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(textStyle.rise));
                        ATK.memmove(n9, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n9);
                    }
                    if (textStyle.underline) {
                        n9 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(11));
                        String string = "none";
                        switch (textStyle.underlineStyle) {
                            case 1: {
                                string = "double";
                                break;
                            }
                            case 0: {
                                string = "single";
                                break;
                            }
                            case 2: {
                                string = "error";
                                break;
                            }
                            case 3: {
                                string = "squiggle";
                            }
                        }
                        atkAttribute.value = AccessibleObject.getStringPtr(string);
                        ATK.memmove(n9, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n9);
                    }
                    if (textStyle.strikeout) {
                        n9 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(12));
                        atkAttribute.value = AccessibleObject.getStringPtr("1");
                        ATK.memmove(n9, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n9);
                    }
                    if ((font = textStyle.font) != null && !font.isDisposed()) {
                        int n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(17));
                        atkAttribute.value = ATK.g_strdup(OS.pango_font_description_get_family(font.handle));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                        n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(13));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                        n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(27));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                        n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(26));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                        n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(25));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                        n10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(15));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                        ATK.memmove(n10, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n10);
                    }
                    if ((color = textStyle.foreground) != null && !color.isDisposed()) {
                        n6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(19));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(n6, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n6);
                    }
                    if ((color = textStyle.background) != null && !color.isDisposed()) {
                        n6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(18));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(n6, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n6);
                    }
                }
                if (accessibleTextAttributeEvent.attributes != null) {
                    int n11 = accessibleTextAttributeEvent.attributes.length / 2 * 2;
                    int n12 = 0;
                    while (n12 < n11) {
                        n6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[n12]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[n12 + 1]);
                        ATK.memmove(n6, atkAttribute, AtkAttribute.sizeof);
                        n8 = OS.g_list_append(n8, n6);
                        n12 += 2;
                    }
                }
                return n8;
            }
        }
        int n13 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).get_run_attributes != 0) {
            n13 = ATK.call(((AtkTextIface)object).get_run_attributes, n, n2, n3, n4);
        }
        return n13;
    }

    static int atkText_get_offset_at_point(int n, int n2, int n3, int n4) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_offset_at_point");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n5 = ((Vector)object).size();
            if (n5 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.x = n2;
                accessibleTextEvent.y = n3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (n4 == 1) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleTextEvent.x += nArray[0];
                    accessibleTextEvent.y += nArray2[0];
                }
                int n6 = 0;
                while (n6 < n5) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n6);
                    accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
                    ++n6;
                }
                return accessibleTextEvent.offset;
            }
        }
        int n7 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).get_offset_at_point != 0) {
            n7 = ATK.call(((AtkTextIface)object).get_offset_at_point, n, n2, n3, n4);
        }
        return n7;
    }

    static int atkText_add_selection(int n, int n2, int n3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_add_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n4 = ((Vector)object).size();
            if (n4 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n3;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n5);
                    accessibleTextExtendedListener.addSelection(accessibleTextEvent);
                    ++n5;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        int n6 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).add_selection != 0) {
            n6 = ATK.call(((AtkTextIface)object).add_selection, n, n2, n3);
        }
        return n6;
    }

    static int atkText_remove_selection(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_remove_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n4);
                    accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).remove_selection != 0) {
            n5 = ATK.call(((AtkTextIface)object).remove_selection, n, n2);
        }
        return n5;
    }

    static int atkText_set_caret_offset(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_caret_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.offset = n2;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.setCaretOffset(accessibleTextEvent);
                    ++n4;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).set_caret_offset != 0) {
            return ATK.call(((AtkTextIface)object).set_caret_offset, n, n2);
        }
        return 0;
    }

    static int atkText_set_selection(int n, int n2, int n3, int n4) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n5 = ((Vector)object).size();
            if (n5 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = n2;
                accessibleTextEvent.start = n3;
                accessibleTextEvent.end = n4;
                int n6 = 0;
                while (n6 < n5) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n6);
                    accessibleTextExtendedListener.setSelection(accessibleTextEvent);
                    ++n6;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        int n7 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).set_selection != 0) {
            n7 = ATK.call(((AtkTextIface)object).set_selection, n, n2, n3, n4);
        }
        return n7;
    }

    static int atkText_get_caret_offset(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_caret_offset");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n2 = 0;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(n);
        if (atkTextIface != null && atkTextIface.get_caret_offset != 0) {
            n2 = ATK.call(atkTextIface.get_caret_offset, n);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.getCaretOffset(accessibleTextEvent);
                    ++n4;
                }
                return accessibleTextEvent.offset;
            }
            vector = accessible.accessibleTextListeners;
            n3 = vector.size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = n2;
                int n5 = 0;
                while (n5 < n3) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n5);
                    accessibleTextListener.getCaretOffset(accessibleTextEvent);
                    ++n5;
                }
                return accessibleTextEvent.offset;
            }
        }
        return n2;
    }

    static int atkText_get_bounded_ranges(int n, int n2, int n3, int n4, int n5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_bounded_ranges");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n6 = ((Vector)object).size();
            if (n6 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                ATK.memmove(atkTextRectangle, n2, AtkTextRectangle.sizeof);
                accessibleTextEvent.x = atkTextRectangle.x;
                accessibleTextEvent.y = atkTextRectangle.y;
                accessibleTextEvent.width = atkTextRectangle.width;
                accessibleTextEvent.height = atkTextRectangle.height;
                int n7 = 0;
                while (n7 < n6) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n7);
                    accessibleTextExtendedListener.getRanges(accessibleTextEvent);
                    ++n7;
                }
                int[] nArray = accessibleTextEvent.ranges;
                int n8 = nArray == null ? 1 : nArray.length / 2;
                int n9 = OS.malloc(n8 * AtkTextRange.sizeof);
                AtkTextRange atkTextRange = new AtkTextRange();
                int n10 = 0;
                int n11 = nArray != null ? nArray.length / 2 : 1;
                while (n10 < n11) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n12;
                    if (nArray != null) {
                        n12 = n10 * 2;
                        accessibleTextEvent.start = nArray[n12];
                        accessibleTextEvent.end = nArray[n12 + 1];
                    }
                    accessibleTextEvent.count = 0;
                    accessibleTextEvent.type = 5;
                    n12 = 0;
                    while (n12 < n6) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n12);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n12;
                    }
                    atkTextRange.start_offset = accessibleTextEvent.start;
                    atkTextRange.end_offset = accessibleTextEvent.end;
                    atkTextRange.content = AccessibleObject.getStringPtr(accessibleTextEvent.result);
                    accessibleTextEvent.result = null;
                    accessibleTextEvent.height = 0;
                    accessibleTextEvent.width = 0;
                    accessibleTextEvent.y = 0;
                    accessibleTextEvent.x = 0;
                    accessibleTextEvent.type = 0;
                    accessibleTextEvent.count = 0;
                    n12 = 0;
                    while (n12 < n6) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n12);
                        accessibleTextExtendedListener.getTextBounds(accessibleTextEvent);
                        ++n12;
                    }
                    atkTextRange.bounds.x = accessibleTextEvent.x;
                    atkTextRange.bounds.y = accessibleTextEvent.y;
                    atkTextRange.bounds.width = accessibleTextEvent.width;
                    atkTextRange.bounds.height = accessibleTextEvent.height;
                    ATK.memmove(n9 + n10 * AtkTextRange.sizeof, atkTextRange, AtkTextRange.sizeof);
                    ++n10;
                }
                return n9;
            }
        }
        int n13 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).get_bounded_ranges != 0) {
            n13 = ATK.call(((AtkTextIface)object).get_bounded_ranges, n);
        }
        return n13;
    }

    static int atkText_get_character_at_offset(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_at_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n2 + 1;
                accessibleTextEvent.type = 0;
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n4;
                }
                String string = accessibleTextEvent.result;
                return string != null && string.length() > 0 ? (int)string.charAt(0) : 0;
            }
            String string = accessibleObject.getText();
            if (string != null && string.length() > n2) {
                return string.charAt(n2);
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_character_at_offset != 0) {
            return ATK.call(((AtkTextIface)object).get_character_at_offset, n, n2);
        }
        return 0;
    }

    static int atkText_get_character_count(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_count");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n2 = vector.size();
            if (n2 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n3);
                    accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
                    ++n3;
                }
                return accessibleTextEvent.count;
            }
            String string = accessibleObject.getText();
            if (string != null) {
                return string.length();
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_character_count != 0) {
            return ATK.call(((AtkTextIface)object).get_character_count, n);
        }
        return 0;
    }

    static int atkText_get_n_selections(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_n_selections");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleTextExtendedListeners;
            int n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n3 = 0;
                while (n3 < n2) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)((Vector)object).elementAt(n3);
                    accessibleTextExtendedListener.getSelectionCount(accessibleTextEvent);
                    ++n3;
                }
                return accessibleTextEvent.count;
            }
            object = accessible.accessibleTextListeners;
            n2 = ((Vector)object).size();
            if (n2 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                int n4 = 0;
                while (n4 < n2) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)((Vector)object).elementAt(n4);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                    ++n4;
                }
                if (accessibleTextEvent.length > 0) {
                    return 1;
                }
            }
        }
        int n5 = 0;
        object = AccessibleObject.getTextIface(n);
        if (object != null && ((AtkTextIface)object).get_n_selections != 0) {
            n5 = ATK.call(((AtkTextIface)object).get_n_selections, n);
        }
        return n5;
    }

    static int atkText_get_selection(int n, int n2, int n3, int n4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        int n5 = 0;
        OS.memmove(n3, new int[1], 4);
        OS.memmove(n4, new int[1], 4);
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(n);
        if (atkTextIface != null && atkTextIface.get_selection != 0) {
            n5 = ATK.call(atkTextIface.get_selection, n, n2, n3, n4);
        }
        if (accessibleObject != null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.memmove(nArray, n3, 4);
            OS.memmove(nArray2, n4, 4);
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n6 = vector.size();
            if (n6 > 0) {
                AccessibleTextExtendedListener accessibleTextExtendedListener;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = n2;
                accessibleTextEvent.start = nArray[0];
                accessibleTextEvent.end = nArray2[0];
                int n7 = 0;
                while (n7 < n6) {
                    accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n7);
                    accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                    ++n7;
                }
                nArray[0] = accessibleTextEvent.start;
                nArray2[0] = accessibleTextEvent.end;
                OS.memmove(n3, nArray, 4);
                OS.memmove(n4, nArray2, 4);
                accessibleTextEvent.index = 0;
                accessibleTextEvent.count = 0;
                accessibleTextEvent.type = 5;
                n7 = 0;
                while (n7 < n6) {
                    accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n7);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n7;
                }
                if (n5 != 0) {
                    OS.g_free(n5);
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            if (n2 == 0 && (n6 = (vector = accessible.accessibleTextListeners).size()) > 0) {
                String string;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = nArray[0];
                accessibleTextEvent.length = nArray2[0] - nArray[0];
                int n8 = 0;
                while (n8 < n6) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n8);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                    ++n8;
                }
                OS.memmove(n3, new int[]{accessibleTextEvent.offset}, 4);
                OS.memmove(n4, new int[]{accessibleTextEvent.offset + accessibleTextEvent.length}, 4);
                if (n5 != 0) {
                    OS.g_free(n5);
                }
                if ((string = accessibleObject.getText()) != null && string.length() > accessibleTextEvent.offset && string.length() >= accessibleTextEvent.offset + accessibleTextEvent.length) {
                    return AccessibleObject.getStringPtr(string.substring(accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length));
                }
                if (atkTextIface != null && atkTextIface.get_text != 0) {
                    return ATK.call(atkTextIface.get_text, n, accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length);
                }
                return 0;
            }
        }
        return n5;
    }

    static int atkText_get_text(int n, int n2, int n3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text: " + n + " " + n2 + "," + n3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n4 = vector.size();
            if (n4 > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = n2;
                accessibleTextEvent.end = n3;
                accessibleTextEvent.type = 5;
                int n5 = 0;
                while (n5 < n4) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n5;
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n3 = n3 == -1 ? string.length() : Math.min(n3, string.length());
                n2 = Math.min(n2, n3);
                string = string.substring(n2, n3);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_text != 0) {
            return ATK.call(((AtkTextIface)object).get_text, n, n2, n3);
        }
        return 0;
    }

    static int atkText_get_text_after_offset(int n, int n2, int n3, int n4, int n5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_after_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n6 = vector.size();
            if (n6 > 0) {
                int n7 = AccessibleObject.atkText_get_character_count(n);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = n2;
                accessibleTextEvent.count = 1;
                switch (n3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n8 = accessibleTextEvent.start;
                int n9 = accessibleTextEvent.end;
                int n10 = 0;
                while (n10 < n6) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n10);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n10;
                }
                switch (n3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.end >= n7) break;
                        n10 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = 2;
                        int n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n10 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = 0;
                        int n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        break;
                    }
                }
                OS.memmove(n4, new int[]{accessibleTextEvent.start}, 4);
                OS.memmove(n5, new int[]{accessibleTextEvent.end}, 4);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n13 = n2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n6 = string.length();
                int n14 = n13 = Math.min(n13, n6 - 1);
                int n15 = n13;
                switch (n3) {
                    case 0: {
                        if (n6 <= n13) break;
                        break;
                    }
                    case 1: {
                        int n16 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n13 - 1);
                        if (n16 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n16 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n16)) == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n16;
                        int n17 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n16);
                        if (n17 == -1) {
                            n15 = n6;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n17);
                        break;
                    }
                    case 2: {
                        int n18 = AccessibleObject.previousIndexOfNotChar(string, " \n", n13);
                        if (n18 == -1 || n18 != n13 - 1) {
                            n13 = AccessibleObject.nextIndexOfNotChar(string, " \n", n13);
                        }
                        if (n13 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        int n19 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n13);
                        if (n19 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n19 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n19)) == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n19;
                        int n20 = AccessibleObject.nextIndexOfNotChar(string, " \n", n19);
                        if (n20 == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n20 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n20)) == -1) {
                            n15 = n6;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n20);
                        break;
                    }
                    case 3: {
                        int n21 = AccessibleObject.previousIndexOfChar(string, "!?.", n13);
                        int n22 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n13);
                        int n23 = 0;
                        if (n21 >= n22) {
                            n23 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n13);
                        } else {
                            n23 = AccessibleObject.nextIndexOfChar(string, "!?.", n13);
                            if (n23 == -1) {
                                n14 = n15 = n6;
                                break;
                            }
                            n23 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n23);
                        }
                        if (n23 == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n23;
                        int n24 = AccessibleObject.nextIndexOfChar(string, "!?.", n23);
                        if (n24 == -1) {
                            n15 = n6;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n24);
                        break;
                    }
                    case 4: {
                        int n25 = AccessibleObject.nextIndexOfChar(string, "!?.", n13);
                        if (n25 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n25 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n25)) == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n25;
                        int n26 = AccessibleObject.nextIndexOfNotChar(string, " \n", n25);
                        if (n26 == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n26 = AccessibleObject.nextIndexOfChar(string, "!?.", n26)) == -1) {
                            n15 = n6;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n26);
                        break;
                    }
                    case 5: {
                        int n27 = string.indexOf(10, n13 - 1);
                        if (n27 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        if ((n27 = AccessibleObject.nextIndexOfNotChar(string, "\n", n27)) == n6) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n27;
                        int n28 = string.indexOf(10, n27);
                        if (n28 == -1) {
                            n15 = n6;
                            break;
                        }
                        n15 = n28 = AccessibleObject.nextIndexOfNotChar(string, "\n", n28);
                        break;
                    }
                    case 6: {
                        int n29;
                        int n30 = AccessibleObject.nextIndexOfChar(string, "\n", n13);
                        if (n30 == -1) {
                            n14 = n15 = n6;
                            break;
                        }
                        n14 = n30;
                        n15 = n14 == n6 ? n6 : ((n29 = AccessibleObject.nextIndexOfChar(string, "\n", n30 + 1)) == -1 ? n6 : n29);
                    }
                }
                OS.memmove(n4, new int[]{n14}, 4);
                OS.memmove(n5, new int[]{++n15}, 4);
                string = string.substring(n14, n15);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_text_after_offset != 0) {
            return ATK.call(((AtkTextIface)object).get_text_after_offset, n, n2, n3, n4, n5);
        }
        return 0;
    }

    static int atkText_get_text_at_offset(int n, int n2, int n3, int n4, int n5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_at_offset: " + n2 + " start: " + n4 + " end: " + n5);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n6 = vector.size();
            if (n6 > 0) {
                int n7 = AccessibleObject.atkText_get_character_count(n);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = n2;
                accessibleTextEvent.count = 0;
                switch (n3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n8 = accessibleTextEvent.start;
                int n9 = accessibleTextEvent.end;
                int n10 = 0;
                while (n10 < n6) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n10);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n10;
                }
                switch (n3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.end >= n7) break;
                        n10 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = 1;
                        int n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n10 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = -1;
                        int n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        break;
                    }
                }
                OS.memmove(n4, new int[]{accessibleTextEvent.start}, 4);
                OS.memmove(n5, new int[]{accessibleTextEvent.end}, 4);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n13 = n2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n6 = string.length();
                int n14 = n13 = Math.min(n13, n6 - 1);
                int n15 = n13;
                switch (n3) {
                    case 0: {
                        if (n6 <= n13) break;
                        break;
                    }
                    case 1: {
                        int n16 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n13);
                        if (n16 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        if ((n16 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n16) + 1) == -1) {
                            n14 = 0;
                            break;
                        }
                        n14 = n16;
                        int n17 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n16);
                        n15 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n17);
                        break;
                    }
                    case 2: {
                        int n18 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n13 + 1);
                        n18 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n18);
                        n18 = AccessibleObject.previousIndexOfNotChar(string, " \n", n18 + 1);
                        if (n18 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n14 = n18 + 1;
                        int n19 = AccessibleObject.nextIndexOfNotChar(string, " \n", n14);
                        if (n19 == n6) {
                            n15 = n14;
                            break;
                        }
                        if ((n19 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n19)) == -1) {
                            n15 = n14;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n19);
                        break;
                    }
                    case 3: {
                        int n20 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n13 + 1);
                        if (n20 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n20 = AccessibleObject.previousIndexOfChar(string, "!?.", n20) + 1;
                        n14 = AccessibleObject.nextIndexOfNotChar(string, " \n", n20);
                        int n21 = AccessibleObject.nextIndexOfChar(string, "!?.", n14);
                        n15 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n21);
                        break;
                    }
                    case 4: {
                        int n22 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n13 + 1);
                        n22 = AccessibleObject.previousIndexOfChar(string, "!?.", n22);
                        n22 = AccessibleObject.previousIndexOfNotChar(string, " \n", n22 + 1);
                        if (n22 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n14 = n22 + 1;
                        int n23 = AccessibleObject.nextIndexOfNotChar(string, " \n", n14);
                        if (n23 == n6) {
                            n15 = n14;
                            break;
                        }
                        if ((n23 = AccessibleObject.nextIndexOfChar(string, "!?.", n23)) == -1) {
                            n15 = n14;
                            break;
                        }
                        n15 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n23);
                        break;
                    }
                    case 5: {
                        n14 = AccessibleObject.previousIndexOfChar(string, "\n", n13) + 1;
                        int n24 = AccessibleObject.nextIndexOfChar(string, "\n", n14);
                        if (n24 < n6) {
                            ++n24;
                        }
                        n15 = n24;
                        break;
                    }
                    case 6: {
                        int n25 = AccessibleObject.previousIndexOfChar(string, "\n", n13);
                        if (n25 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n14 = n25;
                        n15 = AccessibleObject.nextIndexOfChar(string, "\n", n25 + 1);
                    }
                }
                OS.memmove(n4, new int[]{n14}, 4);
                OS.memmove(n5, new int[]{++n15}, 4);
                string = string.substring(n14, n15);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_text_at_offset != 0) {
            return ATK.call(((AtkTextIface)object).get_text_at_offset, n, n2, n3, n4, n5);
        }
        return 0;
    }

    static int atkText_get_text_before_offset(int n, int n2, int n3, int n4, int n5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_before_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n6 = vector.size();
            if (n6 > 0) {
                int n7 = AccessibleObject.atkText_get_character_count(n);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = n2;
                accessibleTextEvent.count = -1;
                switch (n3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n8 = accessibleTextEvent.start;
                int n9 = accessibleTextEvent.end;
                int n10 = 0;
                while (n10 < n6) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n10);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n10;
                }
                OS.memmove(n4, new int[]{accessibleTextEvent.start}, 4);
                OS.memmove(n5, new int[]{accessibleTextEvent.end}, 4);
                switch (n3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.end >= n7) break;
                        n10 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = 0;
                        int n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n11 = 0;
                        while (n11 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n11);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n11;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n10 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n8;
                        accessibleTextEvent.end = n9;
                        accessibleTextEvent.count = -2;
                        int n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n10;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n12 = 0;
                        while (n12 < n6) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n12);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n12;
                        }
                        break;
                    }
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n13 = n2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n6 = string.length();
                int n14 = n13 = Math.min(n13, n6 - 1);
                int n15 = n13;
                switch (n3) {
                    case 0: {
                        if (n6 < n13 || n13 <= 0) break;
                        break;
                    }
                    case 1: {
                        int n16 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n13 - 1);
                        if (n16 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        int n17 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n16);
                        if (n17 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n16 + 1;
                        n14 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n17) + 1;
                        break;
                    }
                    case 2: {
                        int n18 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n13);
                        if (n18 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        if ((n18 = AccessibleObject.previousIndexOfNotChar(string, " \n", n18 + 1)) == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n18 + 1;
                        int n19 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n15);
                        if ((n19 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n19)) == -1) {
                            n14 = 0;
                            break;
                        }
                        n14 = AccessibleObject.previousIndexOfNotChar(string, " \n", n19 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int n20 = AccessibleObject.previousIndexOfChar(string, "!?.", n13);
                        if (n20 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        int n21 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n20);
                        if (n21 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n20 + 1;
                        n14 = AccessibleObject.previousIndexOfChar(string, "!?.", n21) + 1;
                        break;
                    }
                    case 4: {
                        int n22 = AccessibleObject.previousIndexOfChar(string, "!?.", n13);
                        if (n22 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        if ((n22 = AccessibleObject.previousIndexOfNotChar(string, " \n", n22 + 1)) == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n22 + 1;
                        int n23 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n15);
                        if ((n23 = AccessibleObject.previousIndexOfChar(string, "!?.", n23)) == -1) {
                            n14 = 0;
                            break;
                        }
                        n14 = AccessibleObject.previousIndexOfNotChar(string, " \n", n23 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int n24 = AccessibleObject.previousIndexOfChar(string, "\n", n13);
                        if (n24 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n24 + 1;
                        n14 = AccessibleObject.previousIndexOfChar(string, "\n", n24) + 1;
                        break;
                    }
                    case 6: {
                        int n25 = AccessibleObject.previousIndexOfChar(string, "\n", n13);
                        if (n25 == -1) {
                            n15 = 0;
                            n14 = 0;
                            break;
                        }
                        n15 = n25;
                        n14 = AccessibleObject.previousIndexOfChar(string, "\n", n25);
                        if (n14 != -1) break;
                        n14 = 0;
                    }
                }
                OS.memmove(n4, new int[]{--n14}, 4);
                OS.memmove(n5, new int[]{n15}, 4);
                string = string.substring(n14, n15);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(n)) != null && ((AtkTextIface)object).get_text_before_offset != 0) {
            return ATK.call(((AtkTextIface)object).get_text_before_offset, n, n2, n3, n4, n5);
        }
        return 0;
    }

    static void setGValue(int n, Number number) {
        if (number == null) {
            return;
        }
        if (OS.G_VALUE_TYPE(n) != 0) {
            OS.g_value_unset(n);
        }
        if (number instanceof Double) {
            OS.g_value_init(n, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(n, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(n, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(n, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(n, OS.G_TYPE_INT64());
            OS.g_value_set_int64(n, number.longValue());
        } else {
            OS.g_value_init(n, OS.G_TYPE_INT());
            OS.g_value_set_int(n, number.intValue());
        }
    }

    static Number getGValue(int n) {
        int n2 = OS.G_VALUE_TYPE(n);
        if (n2 == 0) {
            return null;
        }
        if (n2 == OS.G_TYPE_DOUBLE()) {
            return new Double(OS.g_value_get_double(n));
        }
        if (n2 == OS.G_TYPE_FLOAT()) {
            return new Float(OS.g_value_get_float(n));
        }
        if (n2 == OS.G_TYPE_INT64()) {
            return new Long(OS.g_value_get_int64(n));
        }
        return new Integer(OS.g_value_get_int(n));
    }

    static AtkValueIface getValueIface(int n) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(n)), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface atkValueIface = new AtkValueIface();
            ATK.memmove(atkValueIface, ATK.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(n)));
            return atkValueIface;
        }
        return null;
    }

    static int atkValue_get_current_value(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_current_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(n);
        if (atkValueIface != null && atkValueIface.get_current_value != 0) {
            ATK.call(atkValueIface.get_current_value, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(n2);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n4);
                    accessibleValueListener.getCurrentValue(accessibleValueEvent);
                    ++n4;
                }
                AccessibleObject.setGValue(n2, accessibleValueEvent.value);
            }
        }
        return 0;
    }

    static int atkValue_get_maximum_value(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_maximum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(n);
        if (atkValueIface != null && atkValueIface.get_maximum_value != 0) {
            ATK.call(atkValueIface.get_maximum_value, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(n2);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n4);
                    accessibleValueListener.getMaximumValue(accessibleValueEvent);
                    ++n4;
                }
                AccessibleObject.setGValue(n2, accessibleValueEvent.value);
            }
        }
        return 0;
    }

    static int atkValue_get_minimum_value(int n, int n2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_minimum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(n);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(n);
        if (atkValueIface != null && atkValueIface.get_minimum_value != 0) {
            ATK.call(atkValueIface.get_minimum_value, n, n2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n3 = vector.size();
            if (n3 > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(n2);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n4);
                    accessibleValueListener.getMinimumValue(accessibleValueEvent);
                    ++n4;
                }
                AccessibleObject.setGValue(n2, accessibleValueEvent.value);
            }
        }
        return 0;
    }

    static int atkValue_set_current_value(int n, int n2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_set_current_value");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) != null) {
            Accessible accessible = accessibleObject.accessible;
            object = accessible.accessibleValueListeners;
            int n3 = ((Vector)object).size();
            if (n3 > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(n2);
                int n4 = 0;
                while (n4 < n3) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)((Vector)object).elementAt(n4);
                    accessibleValueListener.setCurrentValue(accessibleValueEvent);
                    ++n4;
                }
                return accessibleValueEvent.value != null ? 1 : 0;
            }
        }
        int n5 = 0;
        object = AccessibleObject.getValueIface(n);
        if (object != null && ((AtkValueIface)object).set_current_value != 0) {
            n5 = ATK.call(((AtkValueIface)object).set_current_value, n, n2);
        }
        return n5;
    }

    static AccessibleObject getAccessibleObject(int n) {
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(n));
        if (accessibleObject == null) {
            return null;
        }
        if (accessibleObject.accessible == null) {
            return null;
        }
        Control control = accessibleObject.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return accessibleObject;
    }

    AccessibleObject getChildByID(int n) {
        if (n == -1) {
            return this;
        }
        if (n == -2 || n == -3) {
            return null;
        }
        if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.length) {
                AccessibleObject accessibleObject = this.children[n2];
                if (accessibleObject != null && accessibleObject.id == n) {
                    return accessibleObject;
                }
                ++n2;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int n) {
        if (this.children != null && n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    String getText() {
        Vector vector = this.accessible.accessibleControlListeners;
        int n = vector.size();
        if (n > 0) {
            int n2;
            int n3;
            String string = "";
            AtkTextIface atkTextIface = AccessibleObject.getTextIface(this.handle);
            if (atkTextIface != null && atkTextIface.get_character_count != 0 && (n3 = ATK.call(atkTextIface.get_character_count, this.handle)) > 0 && atkTextIface.get_text != 0 && (n2 = ATK.call(atkTextIface.get_text, this.handle, 0, n3)) != 0) {
                string = AccessibleObject.getString(n2);
                OS.g_free(n2);
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
            accessibleControlEvent.childID = this.id;
            accessibleControlEvent.result = string;
            n2 = 0;
            while (n2 < n) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n2;
            }
            return accessibleControlEvent.result;
        }
        return null;
    }

    static int gObjectClass_finalize(int n) {
        if (DEBUG) {
            AccessibleObject.print("-->gObjectClass_finalize: " + n);
        }
        int n2 = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(n));
        int n3 = ATK.G_OBJECT_CLASS(n2);
        GObjectClass gObjectClass = new GObjectClass();
        ATK.memmove(gObjectClass, n3);
        ATK.call(gObjectClass.finalize, n);
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(n));
        if (accessibleObject != null) {
            AccessibleObjects.remove(new LONG(n));
        }
        return 0;
    }

    static int toATKRelation(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject accessibleObject, int[] nArray, int[] nArray2) {
        GtkAccessible gtkAccessible = new GtkAccessible();
        ATK.memmove(gtkAccessible, accessibleObject.handle);
        while (gtkAccessible.widget == 0 && accessibleObject.parent != null) {
            accessibleObject = accessibleObject.parent;
            ATK.memmove(gtkAccessible, accessibleObject.handle);
        }
        if (gtkAccessible.widget == 0) {
            return;
        }
        int n = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
        int n2 = OS.GTK_WIDGET_WINDOW(n);
        OS.gdk_window_get_origin(n2, nArray, nArray2);
    }

    static int nextIndexOfChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.indexOf(c, n);
            if (n4 != -1) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int nextIndexOfNotChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (string2.indexOf(c) == -1) break;
            ++n3;
        }
        return n3;
    }

    static int previousIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        if (n < 0) {
            return n2;
        }
        string = string.substring(0, n);
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.lastIndexOf(c);
            if (n4 != -1) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int previousIndexOfNotChar(String string, String string2, int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) == -1) break;
            --n2;
        }
        return n2;
    }

    void addRelation(int n, Accessible accessible) {
        OS.atk_object_add_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void release() {
        if (DEBUG) {
            AccessibleObject.print("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                AccessibleObject accessibleObject = this.children[n];
                if (accessibleObject != null) {
                    OS.g_object_unref(accessibleObject.handle);
                }
                ++n;
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.handle);
        }
    }

    void removeRelation(int n, Accessible accessible) {
        OS.atk_object_remove_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void sendEvent(int n, Object object) {
        block0 : switch (n) {
            case 32777: {
                OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
                break;
            }
            case 32788: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
                break;
            }
            case 32778: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = -1;
                switch (n2) {
                    case 2: {
                        n4 = 21;
                        break;
                    }
                    case 0x200000: {
                        n4 = 20;
                        break;
                    }
                    case 0x1000000: {
                        n4 = 16;
                        break;
                    }
                    case 4: {
                        n4 = 11;
                        break;
                    }
                    case 0x100000: {
                        n4 = 10;
                        break;
                    }
                    case 8: {
                        n4 = 18;
                        break;
                    }
                    case 16: {
                        n4 = 4;
                        break;
                    }
                    case 512: {
                        n4 = 9;
                        break;
                    }
                    case 1024: {
                        n4 = 9;
                        break;
                    }
                    case 128: {
                        n4 = 2;
                        break;
                    }
                    case 2048: {
                        n4 = 3;
                        break;
                    }
                    case 64: {
                        n4 = 6;
                        break;
                    }
                    case 32768: {
                        n4 = 28;
                        break;
                    }
                    case 65536: {
                        n4 = 23;
                        break;
                    }
                    case 131072: {
                        n4 = 19;
                        break;
                    }
                    case 0x400000: {
                        break;
                    }
                    case 1: {
                        n4 = 7;
                        break;
                    }
                    case 0x4000000: {
                        n4 = 1;
                        break;
                    }
                    case 0x8000000: {
                        n4 = 24;
                        break;
                    }
                    case 0x10000000: {
                        n4 = 15;
                        break;
                    }
                    case 0x2000000: {
                        n4 = 32;
                        break;
                    }
                    case 0x20000000: {
                        n4 = 33;
                        break;
                    }
                    case 0x40000000: {
                        n4 = 34;
                    }
                }
                if (n4 == -1) break;
                ATK.atk_object_notify_state_change(this.handle, n4, n3 != 0);
                break;
            }
            case 32779: {
                Vector vector = this.accessible.accessibleControlListeners;
                int n5 = vector.size();
                GdkRectangle gdkRectangle = new GdkRectangle();
                if (n5 > 0) {
                    AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = this.id;
                    int n6 = 0;
                    while (n6 < n5) {
                        AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                        accessibleControlListener.getLocation(accessibleControlEvent);
                        ++n6;
                    }
                    gdkRectangle.x = accessibleControlEvent.x;
                    gdkRectangle.y = accessibleControlEvent.y;
                    gdkRectangle.width = accessibleControlEvent.width;
                    gdkRectangle.height = accessibleControlEvent.height;
                }
                OS.g_signal_emit_by_name(this.handle, ATK.bounds_changed, gdkRectangle);
                break;
            }
            case 32780: {
                OS.g_object_notify(this.handle, ATK.accessible_name);
                break;
            }
            case 32781: {
                OS.g_object_notify(this.handle, ATK.accessible_description);
                break;
            }
            case 32782: {
                OS.g_object_notify(this.handle, ATK.accessible_value);
                break;
            }
            case 261: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_complete);
                break;
            }
            case 262: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_stopped);
                break;
            }
            case 263: {
                OS.g_signal_emit_by_name(this.handle, ATK.reload);
                break;
            }
            case 273: {
                break;
            }
            case 274: {
                break;
            }
            case 256: {
                break;
            }
            case 264: {
                OS.g_object_notify(this.handle, ATK.end_index);
                break;
            }
            case 265: {
                OS.g_object_notify(this.handle, ATK.number_of_anchors);
                break;
            }
            case 266: {
                OS.g_object_notify(this.handle, ATK.selected_link);
                break;
            }
            case 269: {
                OS.g_object_notify(this.handle, ATK.start_index);
                break;
            }
            case 267: {
                OS.g_signal_emit_by_name(this.handle, ATK.link_activated);
                break;
            }
            case 268: {
                if (!(object instanceof Integer)) break;
                int n7 = (Integer)object;
                OS.g_signal_emit_by_name(this.handle, ATK.link_selected, n7);
                break;
            }
            case 271: {
                OS.g_object_notify(this.handle, ATK.accessible_hypertext_nlinks);
                break;
            }
            case 512: {
                OS.g_signal_emit_by_name(this.handle, ATK.attributes_changed);
                break;
            }
            case 515: {
                OS.g_object_notify(this.handle, ATK.accessible_table_caption_object);
                break;
            }
            case 516: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_description);
                break;
            }
            case 517: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_header);
                break;
            }
            case 518: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n8 = nArray[0];
                int n9 = nArray[1];
                int n10 = nArray[2];
                int n11 = nArray[3];
                int n12 = nArray[4];
                switch (n8) {
                    case 1: {
                        if (n10 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_deleted, n9, n10);
                        }
                        if (n12 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_deleted, n11, n12);
                        break;
                    }
                    case 0: {
                        if (n10 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_inserted, n9, n10);
                        }
                        if (n12 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_inserted, n11, n12);
                    }
                }
                break;
            }
            case 519: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_description);
                break;
            }
            case 520: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_header);
                break;
            }
            case 521: {
                OS.g_object_notify(this.handle, ATK.accessible_table_summary);
                break;
            }
            case 522: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_attributes_changed);
                break;
            }
            case 283: 
            case 285: {
                int n13 = 0;
                Vector vector = this.accessible.accessibleTextExtendedListeners;
                int n14 = vector.size();
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this.accessible);
                if (n14 > 0) {
                    int n15 = 0;
                    while (n15 < n14) {
                        AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n15);
                        accessibleTextListener.getCaretOffset(accessibleTextEvent);
                        ++n15;
                    }
                } else {
                    vector = this.accessible.accessibleTextListeners;
                    n14 = vector.size();
                    if (n14 > 0) {
                        accessibleTextEvent.childID = this.id;
                        int n16 = 0;
                        while (n16 < n14) {
                            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n16);
                            accessibleTextListener.getCaretOffset(accessibleTextEvent);
                            ++n16;
                        }
                    }
                }
                n13 = accessibleTextEvent.offset;
                OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n13);
                break;
            }
            case 524: {
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                int n17 = (Integer)objectArray[0];
                int n18 = (Integer)objectArray[1];
                int n19 = (Integer)objectArray[2];
                switch (n17) {
                    case 1: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n18, n19 - n18);
                        break block0;
                    }
                    case 0: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n18, n19 - n18);
                    }
                }
            }
        }
    }

    void setFocus(int n) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n);
        if (accessibleObject != null) {
            OS.g_signal_emit_by_name(accessibleObject.handle, ATK.focus_event, 1, 0);
            ATK.atk_object_notify_state_change(accessibleObject.handle, 11, true);
        }
    }

    void textCaretMoved(int n) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n);
    }

    void textChanged(int n, int n2, int n3) {
        if (n == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n2, n3);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n2, n3);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        Object object;
        AccessibleObject[] accessibleObjectArray;
        Vector vector = this.accessible.accessibleControlListeners;
        int n = vector.size();
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
        accessibleControlEvent.childID = this.id;
        int n2 = 0;
        while (n2 < n) {
            accessibleObjectArray = (AccessibleObject[])vector.elementAt(n2);
            accessibleObjectArray.getChildren(accessibleControlEvent);
            ++n2;
        }
        Object[] objectArray = accessibleControlEvent.children;
        accessibleObjectArray = this.children;
        int n3 = objectArray != null ? objectArray.length : 0;
        AccessibleObject[] accessibleObjectArray2 = new AccessibleObject[n3];
        int n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            AccessibleObject accessibleObject = null;
            if (object instanceof Integer) {
                int n5 = (Integer)object;
                AccessibleObject accessibleObject2 = accessibleObject = accessibleObjectArray != null && n4 < accessibleObjectArray.length ? accessibleObjectArray[n4] : null;
                if (accessibleObject == null || accessibleObject.id != n5) {
                    accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = n5;
                    int n6 = 0;
                    while (n6 < n) {
                        AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                        accessibleControlListener.getChild(accessibleControlEvent);
                        ++n6;
                    }
                    if (accessibleControlEvent.accessible != null) {
                        accessibleObject = accessibleControlEvent.accessible.getAccessibleObject();
                        if (accessibleObject != null) {
                            OS.g_object_ref(accessibleObject.handle);
                        }
                    } else {
                        accessibleObject = AccessibleFactory.createChildAccessible(this.accessible, n5);
                    }
                    accessibleObject.id = n5;
                } else {
                    OS.g_object_ref(accessibleObject.handle);
                }
            } else if (object instanceof Accessible && (accessibleObject = ((Accessible)object).getAccessibleObject()) != null) {
                OS.g_object_ref(accessibleObject.handle);
            }
            if (accessibleObject != null) {
                accessibleObject.index = n4;
                accessibleObject.parent = this;
                accessibleObjectArray2[n4] = accessibleObject;
            }
            ++n4;
        }
        if (accessibleObjectArray != null) {
            n4 = 0;
            while (n4 < accessibleObjectArray.length) {
                object = accessibleObjectArray[n4];
                if (object != null) {
                    OS.g_object_unref(((AccessibleObject)object).handle);
                }
                ++n4;
            }
        }
        this.children = accessibleObjectArray2;
    }
}

