package org.eclipse.expi;

import java.io.File;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.eclipse.expi"; //$NON-NLS-1$

    // The shared instance
    private static Activator   plugin;

    /** The number of the user. It is used to name the zip file. */
    private String             number    = null;

    /**
     * The constructor
     */
    public Activator() {
    }

    /**
     * @param number
     *            The number of the user.
     */
    public void setNumber(final String number) {
        this.number = number;
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(final BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        final ActionMonitor m = ActionMonitor.getInstance();
        for (final IWorkbenchWindow window : plugin.getWorkbench().getWorkbenchWindows()) {
            final Display d = window.getWorkbench().getDisplay();
            d.addFilter(SWT.KeyUp, m);
            d.addFilter(SWT.KeyDown, m);
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(final BundleContext context) throws Exception {
        if (number != null) {
            final File workSpace = new File(Util.getWorkspacePath());
            Zipper.zip(new File(workSpace.getParentFile(), number + ".zip"), workSpace);
        }
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    /**
     * Returns an image descriptor for the image file at the given plug-in relative path
     *
     * @param path
     *            the path
     * @return the image descriptor
     */
    public static ImageDescriptor getImageDescriptor(final String path) {
        return imageDescriptorFromPlugin(PLUGIN_ID, path);
    }
}
