package org.eclipse.expi;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.ResourcesPlugin;

/**
 * A simple file logger.
 *
 * @author beccs
 */
public final class FileLogger {
    private static Map<String, FileLogger> mInstances = new HashMap<String, FileLogger>();
    private final String                   id;

    public static FileLogger getLogger(final String id) {
        if (mInstances.containsKey(id)) {
            return mInstances.get(id);
        }
        final FileLogger inst = new FileLogger(id);
        mInstances.put(id, inst);
        return inst;
    }

    private FileLogger(final String id) {
        this.id = id;
        log("--- start ---");
    }

    /**
     * Writes a line to the file.
     * 
     * @param msg
     *            The message that should be written to the file.
     */
    public void log(final String msg) {
        try {
            final FileWriter fw = new FileWriter(getProjectPath() + "/" + id + ".log", true);
            fw.write(DateFormat.getDateTimeInstance().format(new Date()) + " " + msg
                    + System.getProperty("line.separator"));
            fw.flush();
            fw.close();
        } catch (final IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Writes the stack trace of the given exception to the file.
     * 
     * @param exception
     *            The exception whose stack trace should be written to the file.
     */
    public void log(final Exception exception) {
        FileOutputStream fout;
        try {
            fout = new FileOutputStream(getProjectPath() + "/" + id + ".log", true);
            exception.printStackTrace(new PrintStream(fout));
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String getProjectPath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    }
}
