package org.eclipse.expi;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.swt.widgets.Control;

/**
 * Launches an embedded program in a new java virtual machine, when the user activates the control
 * button.
 * 
 */
public class ProgramLauncherJDT extends AbstractProgramLauncher {
    public ProgramLauncherJDT(final Control control) {
        super(control);
    }

    @Override
    protected void launch() throws LaunchFailedException {
        final IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            throw new LaunchFailedException("Can't get default VM.");
        }
        final IVMRunner vmRunner = vmInstall.getVMRunner(ILaunchManager.RUN_MODE);
        if (vmRunner == null) {
            throw new LaunchFailedException("The default VM can't *run* programs.");
        }
        final StringBuilder cpbuilder = new StringBuilder(Util.getWorkspacePath()).append('/')
                .append(getProgram());
        final String[] classpath = new String[] { cpbuilder.toString() };
        final String mainClass = getMainClass(getProgramUrl());
        final VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(mainClass, classpath);
        vmConfig.setWorkingDirectory(Util.getWorkspacePath());
        final ILaunch launch = new Launch(null, ILaunchManager.RUN_MODE, null);
        try {
            vmRunner.run(vmConfig, launch, null);
        } catch (final CoreException e) {
            new LaunchFailedException("Cannot start new VM to run " + getProgram(), e);
        }
    }
}
