package org.eclipse.expi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

import org.eclipse.core.resources.ResourcesPlugin;

public final class Util {
    private Util() {
    }

    public static String getWorkspacePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    }

    /**
     * Read environment variables for either some Windows version or Unix.
     */
    public static Properties getEnvVars() throws IOException {
        Process p = null;
        final Properties envVars = new Properties();
        final Runtime r = Runtime.getRuntime();
        final String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows 9") > -1) {
            p = r.exec("command.com /c set");
        } else if ((os.indexOf("nt") > -1) || (os.indexOf("windows 2000") > -1)
                || (os.indexOf("windows xp") > -1)) {
            // thanks to JuanFran for the xp fix!
            p = r.exec("cmd.exe /c set");
        } else {
            // our last hope, we assume Unix (thanks to H. Ware for the fix)
            p = r.exec("env");
        }
        final BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line;
        while ((line = br.readLine()) != null) {
            final int idx = line.indexOf('=');
            if (idx >= 0) {
                final String key = line.substring(0, idx);
                final String value = line.substring(idx + 1);
                envVars.setProperty(key, value);
            }
        }
        return envVars;
    }
}
