package org.eclipse.expi.forms;

/**
 * Is used to return multiple values by forms.
 *
 * @author ojlr
 *
 */
public class Answer {
    /** The name of the answer. */
    private final String name;
    /** The string representation of the answered value. */
    private final String value;

    /**
     * Constructs a new answer object and initializes the name and the value.
     * 
     * @param name
     *            The name of the answer.
     * @param value
     *            The value of the answer.
     */
    public Answer(final String name, final String value) {
        assert name != null;
        assert value != null;
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }
}
