package org.eclipse.expi.forms;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.swt.SWTResourceManager;

/**
 * Can be used to ask a yes-no question.
 *
 * @author ojlr
 *
 */
public class FormBool extends Composite implements Form {

    /** The number of columns of the layout of the form. */
    private static final int NUM_COLUMNS = 3;
    /** The question that should be asked. */
    private final String question;
    /** The yes option. */
    private final Button btnYes;
    /** The no option. */
    private final Button btnNo;

    /**
     * Create the composite.
     *
     * @param parent
     *            The containing composite.
     * @param style
     *            The swt style.
     * @param question
     *            The question.
     */
    public FormBool(final Composite parent, final int style, final String question) {
        super(parent, style);
        this.question = question;
        setLayout(new GridLayout(NUM_COLUMNS, false));

        final Label lblQuestion = new Label(this, SWT.NONE);
        lblQuestion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
        lblQuestion.setText(question);

        btnYes = new Button(this, SWT.RADIO);
        btnYes.setText("yes");
        final Color yesDefaultColor = btnYes.getForeground();

        btnNo = new Button(this, SWT.RADIO);
        btnNo.setText("no");
        final Color noDefaultColor = btnNo.getForeground();

        final Listener l = new Listener() {
            @Override
            public void handleEvent(final Event event) {
                btnYes.setForeground(yesDefaultColor);
                btnNo.setForeground(noDefaultColor);
            }
        };
        btnYes.addListener(SWT.Selection, l);
        btnNo.addListener(SWT.Selection, l);

    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    /**
     * This implementation checks if at least one option is chosen.
     * 
     * @see Form.validate
     */
    @Override
    public boolean validate() {
        if (!(btnYes.getSelection() || btnNo.getSelection())) {
            btnYes.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
            btnNo.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
            return false;
        }
        return true;
    }

    @Override
    public Collection<Answer> getAnswers() {
        final ArrayList<Answer> r = new ArrayList<Answer>(1);
        r.add(new Answer(question, btnYes.getSelection() ? "yes" : "no"));
        return r;
    }

}
