package org.eclipse.expi.forms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * Is used to create differed dialogs depended to their names.
 *
 * @author ojlr
 *
 */
public final class FormFactory {
    private FormFactory() {
    }

    /** The descriptions of that are used to create dialogs after a task. */
    private static final Map<String, String> DESCRIPTIONS;
    static {
        final Map<String, String> modifiable = new HashMap<String, String>();
        modifiable.put("Mental Demand", "How mentally demanding was the task?");
        modifiable.put("Performance",
                "How successful were you in accomplishing what you were asked to do?");
        modifiable.put("Effort",
                "How hard did you have to work to accomplish your level of performance?");
        modifiable.put("Frustration",
                "How insecure, discouraged, irritated, stressed and annoyed were you?");
        DESCRIPTIONS = Collections.unmodifiableMap(modifiable);
    }

    /**
     * Creates a dialog that is ready to use.
     * 
     * @param parent
     *            The parent composite.
     * @param name
     *            The name of the dialog. It is used to decide which dialog should be created. Valid
     *            values: "General questions", "Task", "Workload"
     * @param isModal
     *            Decides if the created dialog is modal.
     * @return The created dialog or <code>null</code> if name is not valid.
     */
    public static FormDialog createDialog(final Composite parent, final String name,
            final boolean isModal) {
        final FormDialog fd = new FormDialog(parent, SWT.NONE, name, isModal);
        if (name.equalsIgnoreCase("general questions")) {
            final FormGeneral fg = new FormGeneral(fd, SWT.NONE);
            fd.setForm(fg, fg);
        } else if (name.contains("Task")) {
            final FormTask ft = new FormTask(fd, SWT.NONE, DESCRIPTIONS);
            fd.setForm(ft, ft);
        } else if (name.contains("Workload")) {
            final FormRatingTotal frt = new FormRatingTotal(fd, SWT.NONE, DESCRIPTIONS);
            fd.setForm(frt, frt);
        }
        return fd;
    }
}
