package org.eclipse.expi.forms;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.wb.swt.SWTResourceManager;

// CHECKSTYLE:OFF
/**
 * This form is used to choose a value of a scale.
 *
 * @author ojlr
 *
 */
public class FormSlider extends Composite implements Form {

    /** The question. */
    private final String name;
    /** The scale of the slider. */
    private final Scale  scale;

    /**
     * Create the composite.
     * 
     * @param parent
     *            The containing composite.
     * @param style
     *            The swt style.
     * @param name
     *            The question.
     * @param desc
     *            The description of the question.
     */
    public FormSlider(final Composite parent, final int style, final String name,
            final String desc) {
        super(parent, style);
        this.name = name;
        setLayout(new FormLayout());

        final Label lblMentalDemand = new Label(this, SWT.NONE);
        final FormData fd_lblMentalDemand = new FormData();
        fd_lblMentalDemand.top = new FormAttachment(0, 5);
        fd_lblMentalDemand.left = new FormAttachment(0, 5);
        lblMentalDemand.setLayoutData(fd_lblMentalDemand);
        lblMentalDemand.setText(name);

        final Label lblDescription = new Label(this, SWT.NONE);
        lblDescription.setFont(SWTResourceManager.getFont(
                SWTResourceManager.getDefaultFontName(), 9, SWT.ITALIC));
        final FormData fd_lblDescription = new FormData();
        fd_lblDescription.top = new FormAttachment(lblMentalDemand, 6);
        fd_lblDescription.left = new FormAttachment(lblMentalDemand, 0, SWT.LEFT);
        lblDescription.setLayoutData(fd_lblDescription);
        lblDescription.setText(desc);

        scale = new Scale(this, SWT.NONE);
        final FormData fd_scale = new FormData();
        fd_scale.bottom = new FormAttachment(lblDescription, 24, SWT.BOTTOM);
        fd_scale.top = new FormAttachment(lblDescription, 6);
        fd_scale.left = new FormAttachment(0, 5);
        fd_scale.right = new FormAttachment(100, -10);
        scale.setLayoutData(fd_scale);

        final Label lblVeryLow = new Label(this, SWT.NONE);
        lblVeryLow.setFont(SWTResourceManager.getFont(SWTResourceManager.getDefaultFontName(),
                8, SWT.ITALIC));
        final FormData fd_lblVeryLow = new FormData();
        fd_lblVeryLow.right = new FormAttachment(lblDescription, 25, SWT.RIGHT);
        fd_lblVeryLow.top = new FormAttachment(scale, 6);
        fd_lblVeryLow.left = new FormAttachment(lblMentalDemand, 0, SWT.LEFT);
        lblVeryLow.setLayoutData(fd_lblVeryLow);
        lblVeryLow.setText("Very Low ");

        final Label lblVeryHigh = new Label(this, SWT.NONE);
        lblVeryHigh.setAlignment(SWT.RIGHT);
        lblVeryHigh.setText("Very High");
        lblVeryHigh.setFont(SWTResourceManager.getFont(
                SWTResourceManager.getDefaultFontName(), 8, SWT.ITALIC));
        final FormData fd_lblVeryHigh = new FormData();
        fd_lblVeryHigh.left = new FormAttachment(lblVeryLow, 39);
        fd_lblVeryHigh.right = new FormAttachment(100, -10);
        fd_lblVeryHigh.top = new FormAttachment(scale, 6);
        lblVeryHigh.setLayoutData(fd_lblVeryHigh);

    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public Collection<Answer> getAnswers() {
        final ArrayList<Answer> r = new ArrayList<Answer>(1);
        r.add(new Answer(name, Integer.toString(scale.getSelection())));
        return r;
    }
}
// CHECKSTYLE:ON