package org.eclipse.expi.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;

// CHECKSTYLE:OFF
/**
 * This form is used to let the user recapitulate the last task.
 *
 * @author ojlr
 *
 */
public class FormTask extends Composite implements Form {

    /** The sliders to rate the workload. */
    private final List<FormSlider> sliders = new ArrayList<FormSlider>();
    /** Ask if the user accomplished the task. */
    private final FormBool         boolTime;
    /** Free text about the strategy. */
    private final FormText         textStrategy;
    /** A Reference to the dialog for error reporting. */
    private final FormDialog       fd;

    /**
     * Create the composite.
     *
     * @param parent
     * @param style
     */
    public FormTask(final FormDialog fd, final int style,
            final Map<String, String> descriptions) {
        super(fd.getFormComposite(), style);
        this.fd = fd;
        final RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
        rowLayout.spacing = 10;
        rowLayout.fill = true;
        setLayout(rowLayout);

        for (final Map.Entry<String, String> e : descriptions.entrySet()) {
            final FormSlider slider = new FormSlider(this, SWT.None, e.getKey(), e.getValue());
            sliders.add(slider);
        }

        boolTime = new FormBool(this, SWT.NONE, "Did you accomplish the task?");

        textStrategy = new FormText(this, SWT.NONE, "Strategy",
                "Which strategy did you use to locate the bug?");
        textStrategy.setLayoutData(new RowData(356, 154));
        pack();
    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    @Override
    public boolean validate() {
        for (final FormSlider s : sliders) {
            if (!s.validate()) {
                return false;
            }
        }
        if (!boolTime.validate()) {
            fd.setError("Please specify if you accomplished the task.");
            return false;
        }
        return true;
    }

    @Override
    public Collection<Answer> getAnswers() {
        final ArrayList<Answer> r = new ArrayList<Answer>();
        for (final FormSlider s : sliders) {
            r.addAll(s.getAnswers());
        }
        r.addAll(boolTime.getAnswers());
        r.addAll(textStrategy.getAnswers());
        return r;
    }

}
// CHECKSTYLE:OFF