package org.eclipse.expi.forms;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

/**
 * This form is used to ask open questions.
 * 
 * @author ojlr
 * 
 */
public class FormText extends Composite implements Form {
    private static final int FONT_SIZE = 9;
    private final Text   text;
    private final String name;

    /**
     * Create the composite.
     *
     * @param parent
     * @param style
     */
    public FormText(final Composite parent, final int style, final String name,
            final String desc) {
        super(parent, style);
        this.name = name;
        setLayout(new GridLayout(1, false));

        final Label lblName = new Label(this, SWT.NONE);
        lblName.setText(name);

        final Label lblDescription = new Label(this, SWT.NONE);
        lblDescription.setFont(SWTResourceManager.getFont(
                SWTResourceManager.getDefaultFontName(), FONT_SIZE, SWT.ITALIC));
        lblDescription.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
        lblDescription.setText(desc);

        text = new Text(this, SWT.BORDER | SWT.WRAP | SWT.V_SCROLL | SWT.MULTI);
        text.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    @Override
    public boolean validate() {
        return text.getText().length() > 0;
    }

    @Override
    public Collection<Answer> getAnswers() {
        final ArrayList<Answer> r = new ArrayList<Answer>(1);
        r.add(new Answer(name, text.getText()));
        return r;
    }

}
