package org.eclipse.expi.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

import swing2swt.layout.BorderLayout;

/**
 * Class wrapping the user interface elements to display tasks and switch between them.
 *
 * @author Felix Wenk
 */
public class TaskPlayer extends Composite {

    private static final int NUM_COLUMNS = 4;
    private final FormToolkit toolkit;
    private final Label       timerLabel;
    private final Label       taskNumberLabel;
    private final Button      runButton;
    private final Button      nextButton;
    private final StyledText  content;

    public TaskPlayer(final Composite parent, final FormToolkit toolkit, final int style) {
        super(parent, style);
        this.toolkit = toolkit;
        addDisposeListener(new DisposeListener() {
            @Override
            public void widgetDisposed(final DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        setLayout(new BorderLayout(2, 2));

        content = new StyledText(this, SWT.BORDER | SWT.V_SCROLL);
        content.setEditable(false);
        content.setEnabled(true);
        this.toolkit.adapt(content);
        this.toolkit.paintBordersFor(content);

        final Composite timerAndButtonsComposite = new Composite(this, 0);
        timerAndButtonsComposite.setLayoutData(BorderLayout.SOUTH);
        timerAndButtonsComposite.setLayout(new GridLayout(NUM_COLUMNS, false));

        GridData gd;
        taskNumberLabel = new Label(timerAndButtonsComposite, 0);
        gd = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
        gd.grabExcessHorizontalSpace = false;
        taskNumberLabel.setLayoutData(gd);
        taskNumberLabel.setVisible(true);

        timerLabel = new Label(timerAndButtonsComposite, 0);
        timerLabel.setText("00:00");
        gd = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
        gd.grabExcessHorizontalSpace = false;
        timerLabel.setLayoutData(gd);
        timerLabel.setVisible(false);

        runButton = new Button(timerAndButtonsComposite, SWT.NONE);
        runButton.setText("Run");
        gd = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
        gd.grabExcessHorizontalSpace = true;
        runButton.setLayoutData(gd);
        this.toolkit.adapt(runButton, true, true);
        runButton.setVisible(false);
        runButton.setEnabled(false);

        nextButton = new Button(timerAndButtonsComposite, SWT.NONE);
        nextButton.setText("next");
        gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
        gd.grabExcessHorizontalSpace = false;
        nextButton.setLayoutData(gd);
        this.toolkit.adapt(nextButton, true, true);
    }

    public Button getRunControl() {
        return runButton;
    }

    public Button getNextControl() {
        return nextButton;
    }

    public void setTimerText(final String timerText) {
        timerLabel.setText(timerText);
    }

    public void setContent(final String content) {
        this.content.setText(content);
    }

    public void setTimerVisible(final boolean visible) {
        timerLabel.setVisible(visible);
    }

    public void setTaskNumber(final String numberLabel) {
        taskNumberLabel.setText(numberLabel);
    }

    public void setRunControlText(final String name) {
        // Set new text and fix the position of the resized button afterwards.
        final String textNew = name == null ? "Run" : name;
        final Rectangle boundsOld = runButton.getBounds();
        runButton.setText(textNew);
        toolkit.adapt(runButton, true, true);
        runButton.pack();
        final Rectangle boundsNew = runButton.getBounds();
        final double m = 0.5;
        boundsNew.x -= (int) (m * (boundsNew.width - boundsOld.width));
        runButton.setBounds(boundsNew);
    }
}
