package screens;
/*
 *                 [[ Frozen-Bubble ]]
 *
 * Copyright (c) 2000-2003 Guillaume Cottenceau.
 * Java sourcecode - Copyright (c) 2003 Glenn Sanson.
 *
 * This code is distributed under the GNU General Public License 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Artwork:
 *    Alexis Younes <73lab at free.fr>
 *      (everything but the bubbles)
 *    Amaury Amblard-Ladurantie <amaury at linuxfr.org>
 *      (the bubbles)
 *
 * Soundtrack:
 *    Matthias Le Bidan <matthias.le_bidan at caramail.com>
 *      (the three musics and all the sound effects)
 *
 * Design & Programming:
 *    Guillaume Cottenceau <guillaume.cottenceau at free.fr>
 *      (design and manage the project, whole Perl sourcecode)
 *
 * Java version:
 *    Glenn Sanson <glenn.sanson at free.fr>
 *      (whole Java sourcecode, including JIGA classes 
 *             http://glenn.sanson.free.fr/jiga/)
 *
 *          [[ http://glenn.sanson.free.fr/fb/ ]]
 *          [[ http://www.frozen-bubble.org/   ]]
 */

import FrozenBubble;
import FrozenGame;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Random;

import lib.GameApplet;
import lib.GameFont;
import lib.GameMedia;
import lib.GameScreen;
import lib.ImageSprite;
import lib.ScrollingTextSprite;
import lib.SoundManager;
import lib.TextSprite;
import manager.HighscoreManager;
import manager.LevelManager;
import manager.LifeManager;

public class SplashScreen extends GameScreen {
    private final static String[] MODE_DESC = { "normal mode", "colorblind mode" };
    private final static String[] SOUND_DESC = { "sound enabled", "sound disabled" };
    private final int MODE_TIMING = 30;

    private TextSprite modeMessage;
    private int modeTiming;

    private final TextSprite[] flashingMessage;

    private final Random rand;

    private final ImageSprite penguinEyes;
    private int eyesClosed;

    private final Image fullBackground;
    private final Image splashBackground;

    private int flashDelay;

    private boolean modeKeyPressed, soundKeyPressed;
    private boolean gameInitialized;

    private final GameFont font;

    public SplashScreen(GameApplet gameApplet) {
        super(gameApplet);

        final GameMedia media = gameApplet.getGameMedia();

        fullBackground = media.loadImage("background.jpg");
        splashBackground = media.loadImage("splash.jpg");

        font = (GameFont) gameApplet.getGameContext().getObject("bubbleFont");

        flashingMessage = new TextSprite[3];
        flashingMessage[0] = new TextSprite(new Rectangle(289, 383, 100, 22), font, "PRESS");
        flashingMessage[1] = new TextSprite(new Rectangle(300, 407, 100, 22), font, "FIRE");
        flashingMessage[2] = new TextSprite(new Rectangle(276, 430, 100, 22), font, "TO START");
        for (int i = 0; i < 3; i++) {
            this.addSprite(flashingMessage[i]);
        }

        penguinEyes = new ImageSprite(new Rectangle(370, 280, 19, 9),
                media.loadImage("close_eyes.gif"));

        String message = "| FROZEN BUBBLE 1UP V 1.0.1 - JAVA RELEASE 4  {  DESIGN & PROGRAMMING - Guillaume Cottenceau";
        message += "  }  GRAPHICS - Alexis Younes (AYO73)  [  GRAPHICS (BUBBLES) - Amaury Amblard-Ladurantie";
        message += "  ]  SOUND & MUSIC - Matthias Le Bidan (Matths)  �  JAVA 1.1+ VERSION - Glenn sanson ";
        message += "  \\ SPECIAL THANKS to Benoit dien for his help & to my wife for her patience";
        message += "  �  PLEASE VISIT THE FROZEN BUBBLE OFFICIAL WEB SITE AT HTTP://WWW.FROZEN-BUBBLE.ORG  �";

        final ScrollingTextSprite scrollingMessage = new ScrollingTextSprite(new Rectangle(168, 9,
                300, 22), font, message, 1);
        this.addSprite(scrollingMessage);

        rand = new Random(System.currentTimeMillis());

        // Reset any previously registered data
        ((HighscoreManager) this.getGameApplet().getGameContext().getObject("highscoreManager"))
                .reset();

        ((LifeManager) gameApplet.getGameContext().getObject("lifeManager")).restart();

        modeTiming = -1;
    }

    public void initBackground() {
        addToBackground(fullBackground, new Point(0, 0));
        addToBackground(splashBackground, new Point(116, 0));
    }

    public void play(int[] keyCodes, Point mouseCoord, boolean leftButton, boolean rightButton) {
        boolean newModeKeyState = false;
        boolean newSoundKeyState = false;

        if (gameInitialized) {
            for (int i = 0; i < keyCodes.length; i++) {
                final int current = keyCodes[i];

                if (current == FrozenGame.KEY_M) {
                    newModeKeyState = true;
                }

                if (current == FrozenGame.KEY_S) {
                    newSoundKeyState = true;
                }

                if (current == FrozenGame.KEY_UP || current == FrozenGame.KEY_SHIFT) {
                    ((LevelManager) getGameApplet().getGameContext().getObject("levelManager"))
                            .goToFirstLevel();
                    gameInitialized = false;
                    getGameApplet().setCurrentScreen(new FrozenGame(getGameApplet()));
                }
            }
        } else {
            if (keyCodes.length == 0) {
                gameInitialized = true;
            }
        }

        // Add mode information
        if (newModeKeyState != modeKeyPressed) {
            if (newModeKeyState) {
                FrozenBubble.switchMode();

                if (modeTiming != -1) {
                    this.removeSprite(modeMessage);
                }

                modeMessage = new TextSprite(new Rectangle((640 - getTextSize(
                        MODE_DESC[FrozenBubble.getMode()], font) >> 1), 80, 400, 100), font,
                        MODE_DESC[FrozenBubble.getMode()]);
                this.addSprite(modeMessage);
                modeTiming = MODE_TIMING;
            }

            modeKeyPressed = newModeKeyState;
        }

        if (newSoundKeyState != soundKeyPressed) {
            if (newSoundKeyState) {
                final SoundManager sm = (SoundManager) this.getGameApplet().getGameContext()
                        .getObject("soundManager");

                sm.setSoundState(!sm.getSoundState());

                if (modeTiming != -1) {
                    this.removeSprite(modeMessage);
                }

                if (sm.getSoundState()) {
                    modeMessage = new TextSprite(new Rectangle((640 - getTextSize(SOUND_DESC[0],
                            font) >> 1), 80, 400, 100), font, SOUND_DESC[0]);
                } else {
                    modeMessage = new TextSprite(new Rectangle((640 - getTextSize(SOUND_DESC[1],
                            font) >> 1), 80, 400, 100), font, SOUND_DESC[1]);
                }
                this.addSprite(modeMessage);
                modeTiming = MODE_TIMING;
            }

            soundKeyPressed = newSoundKeyState;
        }

        if (modeTiming != -1) {

            if (modeTiming == 0) {
                this.removeSprite(modeMessage);
                modeMessage = null;
            }

            modeTiming--;
        }

        flashDelay++;
        if (flashDelay == 30) {
            for (int i = 0; i < 3; i++) {
                this.removeSprite(flashingMessage[i]);
            }
        } else if (flashDelay == 50) {
            for (int i = 0; i < 3; i++) {
                this.addSprite(flashingMessage[i]);
            }

            flashDelay = 0;
        }

        if (rand.nextInt() % 100 == 0 && eyesClosed == 0) {
            eyesClosed = 20;
            this.addSprite(penguinEyes);
        } else if (eyesClosed != 0) {
            eyesClosed--;

            if (eyesClosed == 10) {
                this.removeSprite(penguinEyes);
            }
        }
    }

    private int getTextSize(String text, GameFont font) {
        int size = 0;

        for (int i = 0; i < text.length(); i++) {
            size += font.charSize(text.charAt(i));
            size += font.SEPARATOR_WIDTH;
        }

        return size - font.SEPARATOR_WIDTH;
    }
}