package pacman.ai;
import pacman.actors.Actor;
import pacman.map.Map;

/**
 * A heuristic that uses the tile that is closest to the target as the next best
 * tile.
 * 
 * @author Kevin Glass
 */
public class AStarHeuristic {

    /**
     * Get the additional heuristic cost of the given tile. This controls the
     * order in which tiles are searched while attempting to find a path to the
     * target location. The lower the cost the more likely the tile will be
     * searched.
     * 
     * @param map
     *            The map on which the path is being found
     * @param mover
     *            The entity that is moving along the path
     * @param x
     *            The x coordinate of the tile being evaluated
     * @param y
     *            The y coordinate of the tile being evaluated
     * @param tx
     *            The x coordinate of the target location
     * @param ty
     *            Teh y coordinate of the target location
     * @return The cost associated with the given tile
     */
    public float getCost(Map map, Actor mover, int x, int y, int tx, int ty) {
        final float dx = tx - x;
        final float dy = ty - y;

        final float result = (float) (Math.sqrt((dx * dx) + (dy * dy)));

        return result;
    }

}
