import java.awt.Color;
import java.awt.Graphics2D;

/**
 * The EditorMarker is used by the StateEditor for navigation and selecting tiles on the map
 * EditorMarker is NOT tracked inside the Map
 * EditorMarker is a subclass of GameObject
 * 
 * @author Ramsey Kant
 */
public class EditorMarker extends GameObject {

	/**
	 * Class constructor for EditorMarker
	 * 
	 * @param color Color of the marker
	 * @param map Reference to the map object
	 * @param x X coordinate to initially place the marker
	 * @param y Y coordinate to initially place the marker
	 */
	public EditorMarker(Color color, Map map, int x, int y) {
		super(GameObject.OBJECT_MARKER, color, map, x, y);
	}
	
	// Public Methods
	
	/**
	 * Change tile is the EditorMarker's version of Actor's move() method. Called by keyPressed in StateEditor
	 * Moves the Marker on the screen
	 * 
	 * @param dx Amount to change the current X coordinate by
	 * @param dy Amount to change the current Y coordinate by
	 * @see StateEditor#keyPressed(KeyEvent)
	 */
	public void changeTile(int dx, int dy) {
		// Check bounds
		if(m_iX+dx < 0 || m_iY+dy < 0 || m_iX+dx >= g_map.getWidth() || m_iY+dy >= g_map.getHeight())
			return;
		
		m_iX += dx;
		m_iY += dy;
	}

	/**
	 * EditorMarker has a blank act() method
	 * 
	 * @see GameObject#act()
	 */
	@Override
	public void act() {
	}

	/**
	 * EditorMarker appears as a circle around the tile being edited. The color is set in the constructor
	 * 
	 * @see GameObject#paint(Graphics2D)
	 */
	@Override
	public void paint(Graphics2D g) {
		int screenX = (int)(g_map.CELL_SIZE * m_iX);
		int screenY = (int)(g_map.CELL_SIZE * m_iY);
			
		g.setColor(m_color);
		
		g.drawOval(screenX, screenY, g_map.CELL_SIZE, g_map.CELL_SIZE);
	}

}
