/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.util.HashMap;
import java.util.Map;

public class Directories
extends Relation<Directory> {
    private final Attribute id;
    private final Attribute clientId;
    private final Attribute path;
    private final Attribute version;
    private final Attribute files;
    private Map<String, Integer> cache = new HashMap<String, Integer>();

    protected Directories(AbstractRelationBinding binding, AbstractRCF rcf) {
        super(binding, rcf, EntryType.toEntryType("Directory"), true);
        this.id = this.getAttribute("id");
        this.clientId = this.getAttribute("clientId");
        this.path = this.getAttribute("path");
        this.version = this.getAttribute("version");
        this.files = this.getAttribute("files");
    }

    public Attribute getIdAttribute() {
        return this.id;
    }

    public Attribute getClientIdAttribute() {
        return this.clientId;
    }

    public Attribute getPathAttribute() {
        return this.path;
    }

    public Attribute getVersionAttribute() {
        return this.version;
    }

    public Attribute getFilesAttribute() {
        return this.files;
    }

    private String makeDirKey(Directory d, Version v) {
        return this.makeDirKey(d.getPath(), v);
    }

    private String makeDirKey(String path, Version v) {
        return v.getId() + ":" + path;
    }

    @Override
    protected void initCache() {
        for (Directory d : this) {
            if (!d.isVersionSet() || !d.isPathSet()) continue;
            this.cache.put(this.makeDirKey(d, d.getVersion()), d.getId());
        }
    }

    @Override
    protected void removeFromCache(AbstractEntryBinding aeb) {
        Directory d = new Directory(this, aeb);
        if (!d.isVersionSet() || !d.isPathSet()) {
            return;
        }
        String key = this.makeDirKey(d, d.getVersion());
        this.cache.remove(key);
    }

    @Override
    protected void updateCache(AbstractEntryBinding aeb) {
        Directory d = new Directory(this, aeb);
        if (!d.isVersionSet() || !d.isPathSet()) {
            return;
        }
        String key = this.makeDirKey(d, d.getVersion());
        this.cache.put(key, d.getId());
    }

    public Directory getDirectory(String path, Version version) {
        if (path == null || version == null) {
            throw new IllegalArgumentException("Path and version must not be null!");
        }
        if (this.cache.containsKey(this.makeDirKey(path, version))) {
            return (Directory)this.getEntry(this.cache.get(this.makeDirKey(path, version)));
        }
        return null;
    }

    public Directory addDirectory(String path, Version version) {
        if (path == null || version == null) {
            throw new IllegalArgumentException("Path and version must not be null!");
        }
        Directory dir = this.getDirectory(path, version);
        if (dir != null) {
            return dir;
        }
        dir = (Directory)this.append();
        dir.setPath(path);
        dir.setVersion(version);
        version.getDirectories().add(dir);
        String parentPath = PathUtils.normalizePath(path);
        int lastSep = parentPath.lastIndexOf(47);
        if (lastSep > 0) {
            parentPath = parentPath.substring(0, lastSep);
            this.addDirectory(parentPath, version);
        }
        this.cache.put(this.makeDirKey(path, version), dir.getId());
        return dir;
    }
}

