/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.ClonePairs;
import de.uni_bremen.st.rcf.model.Directories;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.Metadata;
import de.uni_bremen.st.rcf.model.Metadatas;
import de.uni_bremen.st.rcf.model.ProcessData;
import de.uni_bremen.st.rcf.model.ProcessDatas;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.model.Versions;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;

public class EntryFactory {
    protected static Entry genericCreateEntry(Relation<? extends Entry> relation, AbstractEntryBinding aeb) {
        EntryType et = EntryType.toEntryType(relation.getName());
        switch (et) {
            case CLONEPAIR: {
                return EntryFactory.createClonePair((ClonePairs)relation, aeb);
            }
            case FILE: {
                return EntryFactory.createFile((Files)relation, aeb);
            }
            case CLONECLASS: {
                return EntryFactory.createCloneClass((CloneClasses)relation, aeb);
            }
            case SOURCEPOSITION: {
                return EntryFactory.createSourcePosition((SourcePositions)relation, aeb);
            }
            case METADATA: {
                return EntryFactory.createMetadata((Metadatas)relation, aeb);
            }
            case VERSION: {
                return EntryFactory.createVersion((Versions)relation, aeb);
            }
            case DIRECTORY: {
                return EntryFactory.createDirectory((Directories)relation, aeb);
            }
            case FRAGMENT: {
                return EntryFactory.createFragment((Fragments)relation, aeb);
            }
            case PROCESSDATA: {
                return EntryFactory.createProcessData((ProcessDatas)relation, aeb);
            }
            case ENTRY: {
                return EntryFactory.createEntry(relation, aeb);
            }
        }
        throw new AssertionError();
    }

    private static Entry createEntry(Relation<Entry> relation, AbstractEntryBinding aeb) {
        return new Entry(relation, aeb);
    }

    protected static ClonePair createClonePair(ClonePairs relation, AbstractEntryBinding aeb) {
        return new ClonePair(relation, aeb);
    }

    protected static File createFile(Files relation, AbstractEntryBinding aeb) {
        return new File(relation, aeb);
    }

    protected static CloneClass createCloneClass(CloneClasses relation, AbstractEntryBinding aeb) {
        return new CloneClass(relation, aeb);
    }

    protected static SourcePosition createSourcePosition(SourcePositions relation, AbstractEntryBinding aeb) {
        return new SourcePosition(relation, aeb);
    }

    protected static Metadata createMetadata(Metadatas relation, AbstractEntryBinding aeb) {
        return new Metadata(relation, aeb);
    }

    protected static Version createVersion(Versions relation, AbstractEntryBinding aeb) {
        return new Version(relation, aeb);
    }

    protected static Directory createDirectory(Directories relation, AbstractEntryBinding aeb) {
        return new Directory(relation, aeb);
    }

    protected static Fragment createFragment(Fragments relation, AbstractEntryBinding aeb) {
        return new Fragment(relation, aeb);
    }

    protected static ProcessData createProcessData(ProcessDatas relation, AbstractEntryBinding aeb) {
        return new ProcessData(relation, aeb);
    }
}

