/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.util.HashMap;
import java.util.Map;

public class Files
extends Relation<File> {
    private final Attribute id;
    private final Attribute clientId;
    private final Attribute name;
    private final Attribute loc;
    private final Attribute numTokens;
    private final Attribute directory;
    private final Attribute version;
    private final Attribute fragments;
    private Map<String, Integer> cache = new HashMap<String, Integer>();

    protected Files(AbstractRelationBinding binding, AbstractRCF rcf) {
        super(binding, rcf, EntryType.toEntryType("File"), true);
        this.id = this.getAttribute("id");
        this.clientId = this.getAttribute("clientId");
        this.name = this.getAttribute("name");
        this.loc = this.getAttribute("loc");
        this.numTokens = this.getAttribute("numTokens");
        this.directory = this.getAttribute("directory");
        this.version = this.getAttribute("version");
        this.fragments = this.getAttribute("fragments");
    }

    public Attribute getIdAttribute() {
        return this.id;
    }

    public Attribute getClientIdAttribute() {
        return this.clientId;
    }

    public Attribute getNameAttribute() {
        return this.name;
    }

    public Attribute getLocAttribute() {
        return this.loc;
    }

    public Attribute getNumTokensAttribute() {
        return this.numTokens;
    }

    public Attribute getDirectoryAttribute() {
        return this.directory;
    }

    public Attribute getVersionAttribute() {
        return this.version;
    }

    public Attribute getFragmentsAttribute() {
        return this.fragments;
    }

    private String makeKey(File f) {
        return this.makeKey(f.getName(), f.getDirectory());
    }

    private String makeKey(String name, Directory d) {
        return d.getId() + ":" + name;
    }

    @Override
    protected void initCache() {
        for (File f : this) {
            if (!f.isDirectorySet() || !f.isNameSet()) continue;
            this.cache.put(this.makeKey(f), f.getId());
        }
    }

    @Override
    protected void removeFromCache(AbstractEntryBinding aeb) {
        File f = new File(this, aeb);
        if (!f.isDirectorySet() || !f.isNameSet()) {
            return;
        }
        String key = this.makeKey(f);
        this.cache.remove(key);
    }

    @Override
    protected void updateCache(AbstractEntryBinding aeb) {
        File f = new File(this, aeb);
        if (!f.isDirectorySet() || !f.isNameSet()) {
            return;
        }
        String key = this.makeKey(f);
        this.cache.put(key, f.getId());
    }

    private String getDirPath(String path) {
        int lastSep = path.lastIndexOf(47);
        if (lastSep < 0) {
            lastSep = 0;
        }
        return path.substring(0, lastSep);
    }

    private String getFileName(String path) {
        int lastSep = path.lastIndexOf(47);
        int fileNameStart = lastSep > 0 ? lastSep + 1 : 0;
        return path.substring(fileNameStart);
    }

    private void validateParameters(String path, Version version) {
        if (path == null || version == null || path.endsWith("/") || path.endsWith("\\") || path.endsWith(".") || path.endsWith("..")) {
            throw new IllegalArgumentException();
        }
    }

    public File getFile(String path, Version version) {
        this.validateParameters(path, version);
        Directory dir = this.getRCF().getDirectories().getDirectory(this.getDirPath(path), version);
        if (dir == null) {
            return null;
        }
        return this.getFile(this.getFileName(path), dir);
    }

    public File getFile(String name, Directory dir) {
        if (this.cache.containsKey(this.makeKey(name, dir))) {
            return (File)this.getEntry(this.cache.get(this.makeKey(name, dir)));
        }
        return null;
    }

    public File addFile(String path, Version version) {
        this.validateParameters(path, version);
        path = PathUtils.stripBasepath(version.getBasepath(), path);
        String dirName = this.getDirPath(path);
        String fileName = this.getFileName(path);
        Directory d = this.getRCF().getDirectories().addDirectory(dirName, version);
        File file = this.getFile(fileName, d);
        if (file != null) {
            return file;
        }
        file = (File)this.append();
        file.setName(fileName);
        file.setDirectory(d);
        file.setVersion(version);
        version.getFiles().add(file);
        d.getFiles().add(file);
        this.cache.put(this.makeKey(file), file.getId());
        return file;
    }
}

