/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.exceptions.ValueNotSetException;
import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.Metadata;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;

public class Metadatas
extends Relation<Metadata> {
    private final Attribute id = this.getAttribute("id");
    private final Attribute key = this.getAttribute("key");
    private final Attribute value = this.getAttribute("value");
    private final Attribute type = this.getAttribute("type");

    protected Metadatas(AbstractRelationBinding binding, AbstractRCF rcf) {
        super(binding, rcf, EntryType.toEntryType("Metadata"), true);
    }

    public Attribute getIdAttribute() {
        return this.id;
    }

    public Attribute getKeyAttribute() {
        return this.key;
    }

    public Attribute getValueAttribute() {
        return this.value;
    }

    public Attribute getTypeAttribute() {
        return this.type;
    }

    private Metadata getMetadata(String key) {
        if (key == null) {
            throw new NullPointerException("null is not a valid key.");
        }
        for (Metadata m : this) {
            if (!key.equals(m.getKey())) continue;
            return m;
        }
        throw new ValueNotSetException();
    }

    private String get(String key, String rcfTypeName) {
        Metadata md = this.getMetadata(key);
        if (!rcfTypeName.equals(md.getType())) {
            throw new NoSuchAttributeException();
        }
        return md.getValue();
    }

    public int getInt(String key) {
        return Integer.valueOf(this.get(key, "INTEGER"));
    }

    public double getFloat(String key) {
        return Double.valueOf(this.get(key, "FLOAT"));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.get(key, "BOOLEAN"));
    }

    public String getString(String key) {
        return this.get(key, "STRING");
    }

    public int getInt(String key, int value) {
        try {
            return this.getInt(key);
        }
        catch (ValueNotSetException e) {
            return value;
        }
    }

    public double getFloat(String key, double value) {
        try {
            return this.getFloat(key);
        }
        catch (ValueNotSetException e) {
            return value;
        }
    }

    public boolean getBoolean(String key, boolean value) {
        try {
            return this.getBoolean(key);
        }
        catch (ValueNotSetException e) {
            return value;
        }
    }

    public String getString(String key, String value) {
        try {
            return this.getString(key);
        }
        catch (ValueNotSetException e) {
            return value;
        }
    }

    private Metadata createMetadata(String key) {
        try {
            return this.getMetadata(key);
        }
        catch (ValueNotSetException e) {
            Metadata m = (Metadata)this.append();
            m.setKey(key);
            return m;
        }
    }

    public void setInt(String key, int value) {
        Metadata m = this.createMetadata(key);
        m.setType("INTEGER");
        m.setValue(new Integer(value).toString());
    }

    public void setFloat(String key, double value) {
        Metadata m = this.createMetadata(key);
        m.setType("FLOAT");
        m.setValue(new Double(value).toString());
    }

    public void setBoolean(String key, boolean value) {
        Metadata m = this.createMetadata(key);
        m.setType("BOOLEAN");
        m.setValue(new Boolean(value).toString());
    }

    public void setString(String key, String value) {
        Metadata m = this.createMetadata(key);
        m.setType("STRING");
        m.setValue(value == null ? "null" : value);
    }
}

