/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.ClonePairs;
import de.uni_bremen.st.rcf.model.Directories;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.Metadatas;
import de.uni_bremen.st.rcf.model.ProcessDatas;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.RelationFactory;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Versions;
import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;

public final class RCF
extends AbstractRCF {
    private ClonePairs clonePairs = null;
    private Files files = null;
    private CloneClasses cloneClasses = null;
    private SourcePositions sourcePositions = null;
    private Metadatas metadatas = null;
    private Versions versions = null;
    private Directories directories = null;
    private Fragments fragments = null;
    private ProcessDatas processDatas = null;

    public RCF(AbstractRCFBinding binding) {
        super(binding);
        this.initAllDefinedRelations();
        this.initCustomRelations();
        this.fixReferencedRelations();
        this.initCaches();
    }

    private void initAllDefinedRelations() {
        this.clonePairs = new ClonePairs(this.getBinding().getRelation("ClonePair"), this);
        this.relationMap.put("ClonePair", this.clonePairs);
        this.files = new Files(this.getBinding().getRelation("File"), this);
        this.relationMap.put("File", this.files);
        this.cloneClasses = new CloneClasses(this.getBinding().getRelation("CloneClass"), this);
        this.relationMap.put("CloneClass", this.cloneClasses);
        this.sourcePositions = new SourcePositions(this.getBinding().getRelation("SourcePosition"), this);
        this.relationMap.put("SourcePosition", this.sourcePositions);
        this.metadatas = new Metadatas(this.getBinding().getRelation("Metadata"), this);
        this.relationMap.put("Metadata", this.metadatas);
        this.versions = new Versions(this.getBinding().getRelation("Version"), this);
        this.relationMap.put("Version", this.versions);
        this.directories = new Directories(this.getBinding().getRelation("Directory"), this);
        this.relationMap.put("Directory", this.directories);
        this.fragments = new Fragments(this.getBinding().getRelation("Fragment"), this);
        this.relationMap.put("Fragment", this.fragments);
        this.processDatas = new ProcessDatas(this.getBinding().getRelation("ProcessData"), this);
        this.relationMap.put("ProcessData", this.processDatas);
    }

    private void initCustomRelations() {
        for (AbstractRelationBinding arb : this.binding.getRelations()) {
            if (this.relationMap.containsKey(arb.getName())) continue;
            this.relationMap.put(arb.getName(), RelationFactory.createGenericRelation(arb.getName(), arb, this));
        }
    }

    private void fixReferencedRelations() {
        for (Relation rel : this.relationMap.values()) {
            for (Attribute att : rel.getAttributes()) {
                if (att.binding.getReferencedRelation() == null) continue;
                att.setReferencedRelation((Relation)this.relationMap.get(att.binding.getReferencedRelation().getName()));
            }
        }
    }

    private void initCaches() {
        for (Relation rel : this.relationMap.values()) {
            rel.initCache();
        }
    }

    public ClonePairs getClonePairs() {
        return this.clonePairs;
    }

    public Files getFiles() {
        return this.files;
    }

    public CloneClasses getCloneClasses() {
        return this.cloneClasses;
    }

    public SourcePositions getSourcePositions() {
        return this.sourcePositions;
    }

    public Metadatas getMetadatas() {
        return this.metadatas;
    }

    public Versions getVersions() {
        return this.versions;
    }

    public Directories getDirectories() {
        return this.directories;
    }

    public Fragments getFragments() {
        return this.fragments;
    }

    public ProcessDatas getProcessDatas() {
        return this.processDatas;
    }

    @Override
    public void save() {
        this.getBinding().save();
    }
}

