/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;

public abstract class AbstractEntryBinding {
    protected final AbstractRelationBinding relation;
    protected final int id;

    protected AbstractEntryBinding(AbstractRelationBinding relation, int id) {
        this.relation = relation;
        this.id = id;
    }

    public abstract int getId();

    public abstract int getInt(AbstractAttributeBinding var1);

    public abstract void setInt(AbstractAttributeBinding var1, int var2);

    public abstract float getFloat(AbstractAttributeBinding var1);

    public abstract void setFloat(AbstractAttributeBinding var1, float var2);

    public abstract String getString(AbstractAttributeBinding var1);

    public abstract void setString(AbstractAttributeBinding var1, String var2);

    public abstract boolean getBool(AbstractAttributeBinding var1);

    public abstract void setBool(AbstractAttributeBinding var1, boolean var2);

    public abstract <T> AbstractValueListBinding<T> getList(AbstractAttributeBinding var1);

    public abstract AbstractEntryBinding getEntry(AbstractAttributeBinding var1);

    public abstract void setEntry(AbstractAttributeBinding var1, AbstractEntryBinding var2);

    public abstract boolean isSet(AbstractAttributeBinding var1);

    public abstract void unset(AbstractAttributeBinding var1);

    public abstract void delete();

    private Object getValue(AbstractAttributeBinding a) {
        if (a.isList()) {
            return this.getList(a);
        }
        switch (a.getType()) {
            case BOOLEAN: {
                return this.getBool(a);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(a));
            }
            case INTEGER: {
                return this.getInt(a);
            }
            case REFERENCE: {
                return this.getEntry(a).getId();
            }
            case STRING: {
                return this.getString(a);
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractEntryBinding)) {
            return false;
        }
        AbstractEntryBinding other = (AbstractEntryBinding)obj;
        if (this.relation.hashCode() != other.relation.hashCode()) {
            return false;
        }
        if (this.id == other.id) {
            return true;
        }
        AbstractAttributeBinding attrId = this.relation.getAttribute("id");
        for (AbstractAttributeBinding a : this.relation.getAttributes()) {
            if (a == attrId) continue;
            boolean aSet = this.isSet(a);
            if (aSet != other.isSet(a)) {
                return false;
            }
            if (!aSet) continue;
            Object left = this.getValue(a);
            Object right = other.getValue(a);
            assert (left != null);
            assert (right != null);
            if (left.equals(right)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = this.relation.hashCode();
        AbstractAttributeBinding attrId = this.relation.getAttribute("id");
        for (AbstractAttributeBinding a : this.relation.getAttributes()) {
            if (a == attrId) continue;
            if (this.isSet(a)) {
                Object value = this.getValue(a);
                code = 31 * code + value.hashCode();
                continue;
            }
            code = 31 * code;
        }
        return code;
    }
}

