/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.bplus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bplus.ElementNotFoundException;
import de.uni_bremen.st.rcf.persistence.bplus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingBoolean;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingFloat;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingInt;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingReference;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingString;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.StringBlob;
import java.io.IOException;

public class EntryBinding
extends AbstractEntryBinding {
    protected EntryBinding(AbstractRelationBinding relation, int id) {
        super(relation, id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getInt(AbstractAttributeBinding attribute) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        if (attrbinding.isIdAttribute()) {
            if (this.isSet(attrbinding)) {
                return this.id;
            }
            this.notFound(null);
        }
        int value = -1;
        try {
            value = attrbinding.btree.getInt(this.id);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return value;
    }

    private void notFound(ElementNotFoundException e) throws RuntimeException {
        throw new RuntimeException("No element with id " + this.id, e);
    }

    @Override
    public void setInt(AbstractAttributeBinding attribute, int value) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        if (!attrbinding.isIdAttribute()) {
            try {
                attrbinding.btree.put(this.id, value);
                this.markSet(attrbinding.attributeId);
            }
            catch (IOException e) {
                this.ioerror(e);
            }
        } else if (value != this.id) {
            throw new RuntimeException("You cannot set the id to a number different from the id.");
        }
    }

    private void markSet(int attributeId) throws IOException {
        RelationBinding relbinding = (RelationBinding)this.relation;
        AttributeBinding idAttribute = relbinding.attributes.get("id");
        int bitlist = 0;
        try {
            bitlist = idAttribute.btree.getInt(this.id);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        int bitmask = 1 << attributeId;
        idAttribute.btree.put(this.id, bitlist |= bitmask);
    }

    private void ioerror(IOException e) throws RuntimeException {
        throw new RuntimeException("An I/O error occured.", e);
    }

    @Override
    public float getFloat(AbstractAttributeBinding attribute) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        float value = -1.0f;
        try {
            value = attrbinding.btree.getFloat(this.id);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        return value;
    }

    @Override
    public void setFloat(AbstractAttributeBinding attribute, float value) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        try {
            attrbinding.btree.put(this.id, value);
            this.markSet(attrbinding.attributeId);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
    }

    @Override
    public String getString(AbstractAttributeBinding attribute) {
        RelationBinding rbinding = (RelationBinding)this.relation;
        AttributeBinding abinding = (AttributeBinding)attribute;
        String result = null;
        try {
            long pos = abinding.btree.getLong(this.id);
            StringBlob stringBlob = rbinding.blobs.readStringBlob(pos);
            result = stringBlob.toString();
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return result;
    }

    @Override
    public void setString(AbstractAttributeBinding attribute, String value) {
        RelationBinding rbinding = (RelationBinding)this.relation;
        AttributeBinding abinding = (AttributeBinding)attribute;
        StringBlob valueBlob = new StringBlob(value);
        try {
            long pos = rbinding.blobs.appendBlob(valueBlob);
            abinding.btree.put(this.id, pos);
            this.markSet(abinding.attributeId);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
    }

    @Override
    public boolean getBool(AbstractAttributeBinding attribute) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        boolean value = false;
        try {
            value = attrbinding.btree.getBoolean(this.id);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return value;
    }

    @Override
    public void setBool(AbstractAttributeBinding attribute, boolean value) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        try {
            attrbinding.btree.put(this.id, value);
            this.markSet(attrbinding.attributeId);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
    }

    @Override
    public <T> AbstractValueListBinding<T> getList(AbstractAttributeBinding attribute) {
        assert (attribute.isList());
        try {
            switch (attribute.getType()) {
                case BOOLEAN: {
                    return new ValueListBindingBoolean(attribute, this);
                }
                case INTEGER: {
                    return new ValueListBindingInt(attribute, this);
                }
                case REFERENCE: {
                    return new ValueListBindingReference(attribute, this);
                }
                case FLOAT: {
                    return new ValueListBindingFloat(attribute, this);
                }
                case STRING: {
                    return new ValueListBindingString(attribute, this);
                }
            }
            throw new RuntimeException("Can't happen.");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create value list binding.", e);
        }
    }

    @Override
    public AbstractEntryBinding getEntry(AbstractAttributeBinding attribute) {
        AttributeBinding attrbinding = (AttributeBinding)attribute;
        int refId = 0;
        try {
            refId = attrbinding.btree.getInt(this.id);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        AbstractRelationBinding rel = attrbinding.getReferencedRelation();
        return new EntryBinding(rel, refId);
    }

    @Override
    public void setEntry(AbstractAttributeBinding attribute, AbstractEntryBinding value) {
        int refId = value.getId();
        this.setInt(attribute, refId);
    }

    @Override
    public boolean isSet(AbstractAttributeBinding binding) {
        RelationBinding relbinding = (RelationBinding)this.relation;
        AttributeBinding idAttribute = relbinding.attributes.get("id");
        int testId = ((AttributeBinding)binding).attributeId;
        int bitlist = 0;
        try {
            bitlist = idAttribute.btree.getInt(this.id);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        int bitmask = 1 << testId;
        int isSet = bitlist & bitmask;
        return isSet != 0;
    }

    @Override
    public void unset(AbstractAttributeBinding binding) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public void delete() {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof EntryBinding)) {
            return false;
        }
        EntryBinding o = (EntryBinding)other;
        return this.id == o.id && this.relation == o.relation;
    }

    @Override
    public int hashCode() {
        return this.id * this.relation.hashCode();
    }
}

