/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.bplus.ValueListBinding;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.AbstractChunk;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.BlobStore;
import java.io.IOException;
import java.util.Iterator;

public class ValueListBindingIterator<T>
implements Iterator<T> {
    ValueListBinding<T> valueListBinding;
    AbstractChunk currentChunk;
    long currentChunkPosition;
    BlobStore blobStore;
    int currentChunkIndex = 0;

    public ValueListBindingIterator(ValueListBinding<T> valueListBinding, AbstractChunk firstChunk, long firstChunkPosition, BlobStore blobStore) {
        this.valueListBinding = valueListBinding;
        this.currentChunk = firstChunk;
        this.currentChunkPosition = firstChunkPosition;
        this.blobStore = blobStore;
    }

    @Override
    public boolean hasNext() {
        return this.currentChunkIndex < this.currentChunk.size() || this.currentChunk.getSuccessor() != -1L;
    }

    @Override
    public T next() {
        if (this.currentChunkIndex >= this.currentChunk.size()) {
            this.currentChunkPosition = this.currentChunk.getSuccessor();
            assert (this.currentChunkPosition != 0L);
            this.currentChunk = this.valueListBinding.createChunk();
            try {
                this.blobStore.readChunk(this.currentChunk, this.currentChunkPosition);
            }
            catch (IOException e) {
                throw new RuntimeException("An I/O error occured.");
            }
            this.currentChunkIndex = 0;
        }
        T value = this.valueListBinding.getValueFromChunk(this.currentChunk, this.currentChunkIndex);
        ++this.currentChunkIndex;
        return value;
    }

    @Override
    public void remove() {
        throw new RuntimeException("TODO Implement me!");
    }
}

