/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.blobs;

import de.uni_bremen.st.rcf.persistence.bplus.blobs.Blob;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.BlobType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class StringBlob
implements Blob {
    public static final int kMaxLength = 4096;
    private static final Charset charset = Charset.forName("UTF-8");
    private byte[] stringBuffer = null;

    public StringBlob() {
    }

    public StringBlob(String string) {
        this.stringBuffer = string.getBytes(charset);
    }

    @Override
    public void writeToByteBuffer(ByteBuffer buffer) throws IOException {
        buffer.put((byte)BlobType.STRING.ordinal());
        buffer.putInt(this.stringBuffer.length);
        buffer.put(this.stringBuffer);
    }

    @Override
    public void readFromByteBuffer(ByteBuffer buffer) throws IOException {
        byte typeOrdinal = buffer.get();
        BlobType type = BlobType.fromOrdinal(typeOrdinal);
        if (type != BlobType.STRING) {
            throw new RuntimeException("The buffer didn't point to a string blob.");
        }
        int length = buffer.getInt();
        this.stringBuffer = new byte[length];
        buffer.get(this.stringBuffer);
    }

    public String toString() {
        if (this.stringBuffer == null) {
            return "";
        }
        return charset.decode(ByteBuffer.wrap(this.stringBuffer)).toString();
    }

    @Override
    public int sizeBytes() {
        if (this.stringBuffer == null) {
            throw new NullPointerException("The StringBlob is uninitialized.");
        }
        int size = 1;
        size += 4;
        return size += this.stringBuffer.length;
    }

    public static void main(String[] args) throws IOException {
        String hello = "Hello StringBlob world!";
        StringBlob helloBlob = new StringBlob(hello);
        ByteBuffer testBuffer = ByteBuffer.allocate(helloBlob.sizeBytes());
        helloBlob.writeToByteBuffer(testBuffer);
        testBuffer.rewind();
        helloBlob = new StringBlob();
        helloBlob.readFromByteBuffer(testBuffer);
        System.out.println(helloBlob);
    }
}

