/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.tree;

import de.uni_bremen.st.rcf.persistence.bplus.ElementNotFoundException;
import de.uni_bremen.st.rcf.persistence.bplus.tree.BTreeNode;
import de.uni_bremen.st.rcf.persistence.bplus.tree.DataType;
import de.uni_bremen.st.rcf.persistence.bplus.tree.Leaf;
import de.uni_bremen.st.rcf.persistence.bplus.tree.Node;
import gnu.trove.TLongStack;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class BTree {
    private static int kHeaderSize = 13;
    private long rootNodePos;
    private int nodeCapacity;
    private DataType dataType;
    private FileChannel fileChannel;
    private long currentNodePosition;
    private BTreeNode currentNode;
    private ByteBuffer currentNodeBuffer;
    private TLongStack parents = new TLongStack();

    private BTree(File file, DataType type, int capacity) throws IOException {
        this.fileChannel = this.createFileChannel(file);
        this.nodeCapacity = capacity;
        this.rootNodePos = -2L;
        this.dataType = type;
        ByteBuffer buffer = ByteBuffer.allocate(kHeaderSize);
        buffer.putLong(this.rootNodePos);
        buffer.putInt(this.nodeCapacity);
        buffer.put((byte)this.dataType.ordinal());
        buffer.rewind();
        int status = this.fileChannel.write(buffer);
        if (status < kHeaderSize) {
            throw new IOException("Could not write new tree file to disk.");
        }
    }

    private BTree(File file) throws IOException {
        this.fileChannel = this.createFileChannel(file);
        if (this.fileChannel.size() < 8L) {
            this.rootNodePos = -1L;
            this.nodeCapacity = -1;
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(kHeaderSize);
            int status = this.fileChannel.read(buffer);
            if (status < kHeaderSize) {
                throw new IOException("Could not read record id although the file is not empty.");
            }
            buffer.rewind();
            this.rootNodePos = buffer.getLong();
            this.nodeCapacity = buffer.getInt();
            byte byteOrdinal = buffer.get();
            int ordinal = byteOrdinal & 0xFF;
            this.dataType = DataType.fromOrdinal(ordinal);
        }
    }

    private FileChannel createFileChannel(File file) throws FileNotFoundException {
        RandomAccessFile rad = new RandomAccessFile(file, "rw");
        return rad.getChannel();
    }

    private void mapCurrentNodeBuffer() throws IOException {
        if (this.currentNode == null) {
            throw new RuntimeException("There's no current node!");
        }
        if (this.currentNodeBuffer == null) {
            this.currentNodeBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, this.currentNodePosition, this.currentNode.sizeBytes());
        }
    }

    private BTreeNode createRootNode() throws IOException {
        Leaf root = new Leaf(this.nodeCapacity, this.dataType);
        ByteBuffer rootBuffer = ByteBuffer.allocate(root.sizeBytes());
        root.writeToByteBuffer(rootBuffer);
        rootBuffer.flip();
        this.fileChannel.position(kHeaderSize);
        int status = this.fileChannel.write(rootBuffer);
        if (status != root.sizeBytes()) {
            throw new IOException("Did not store root node properly.");
        }
        this.rootNodePos = kHeaderSize;
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        headerBuffer.putLong(this.rootNodePos);
        headerBuffer.flip();
        this.fileChannel.position(0L);
        status = this.fileChannel.write(headerBuffer);
        if (status != 8) {
            throw new IOException("Didn't write new root node position.");
        }
        return root;
    }

    private BTreeNode getRootNode() throws IOException {
        if (this.rootNodePos < 0L) {
            BTreeNode root;
            this.currentNode = root = this.createRootNode();
            this.currentNodeBuffer = null;
            this.currentNodePosition = this.rootNodePos;
        }
        return this.loadNode(this.rootNodePos);
    }

    public BTreeNode loadNode(long nodePos) throws IOException {
        MappedByteBuffer buffer;
        int maxSize;
        long overhang;
        if (this.currentNode != null) {
            this.mapCurrentNodeBuffer();
            if (this.currentNodePosition == nodePos) {
                return this.currentNode;
            }
            this.currentNodeBuffer.rewind();
            this.currentNode.writeToByteBuffer(this.currentNodeBuffer);
        }
        if ((overhang = nodePos + (long)(maxSize = Math.max(Leaf.calculateMaxSizeBytes(this.nodeCapacity), Node.calculateMaxSizeBytes(this.nodeCapacity))) - this.fileChannel.size()) > 0L) {
            assert (overhang < (long)maxSize);
            maxSize = (int)((long)maxSize - overhang);
        }
        boolean isLeaf = (buffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, nodePos, maxSize)).get() != 0;
        BTreeNode node = isLeaf ? new Leaf(this.nodeCapacity, this.dataType) : new Node(this.nodeCapacity);
        ((ByteBuffer)buffer).rewind();
        node.loadFromByteBuffer(buffer);
        this.currentNodePosition = nodePos;
        this.currentNodeBuffer = buffer;
        this.currentNode = node;
        return node;
    }

    private long appendNodeToFile(BTreeNode node) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(node.sizeBytes());
        node.writeToByteBuffer(buffer);
        buffer.flip();
        long nodePos = this.fileChannel.size();
        this.fileChannel.position(nodePos);
        if (this.fileChannel.write(buffer) != node.sizeBytes()) {
            throw new IOException("Did not correctly append node to file.");
        }
        return nodePos;
    }

    public void put(int key, int value) throws IOException {
        long rightLeafPos;
        Leaf leaf = this.searchLeafWithKey(key);
        assert (leaf == this.currentNode);
        if (!leaf.isFull()) {
            leaf.insert(key, value);
            return;
        }
        Leaf right = new Leaf(this.nodeCapacity, this.dataType);
        leaf.split(right);
        if (key > leaf.largestKey()) {
            right.insert(key, value);
        } else {
            leaf.insert(key, value);
        }
        leaf.successor = rightLeafPos = this.appendNodeToFile(right);
        this.insertNewLeafIntoTree(leaf.largestKey(), rightLeafPos);
    }

    public void put(int key, float value) throws IOException {
        long rightLeafPos;
        Leaf leaf = this.searchLeafWithKey(key);
        assert (leaf == this.currentNode);
        if (!leaf.isFull()) {
            leaf.insert(key, value);
            return;
        }
        Leaf right = new Leaf(this.nodeCapacity, this.dataType);
        leaf.split(right);
        if (key > leaf.largestKey()) {
            right.insert(key, value);
        } else {
            leaf.insert(key, value);
        }
        leaf.successor = rightLeafPos = this.appendNodeToFile(right);
        this.insertNewLeafIntoTree(leaf.largestKey(), rightLeafPos);
    }

    public void put(int key, boolean value) throws IOException {
        long rightLeafPos;
        Leaf leaf = this.searchLeafWithKey(key);
        assert (leaf == this.currentNode);
        if (!leaf.isFull()) {
            leaf.insert(key, value);
            return;
        }
        Leaf right = new Leaf(this.nodeCapacity, this.dataType);
        leaf.split(right);
        if (key > leaf.largestKey()) {
            right.insert(key, value);
        } else {
            leaf.insert(key, value);
        }
        leaf.successor = rightLeafPos = this.appendNodeToFile(right);
        this.insertNewLeafIntoTree(leaf.largestKey(), rightLeafPos);
    }

    public void put(int key, long value) throws IOException {
        long rightLeafPos;
        Leaf leaf = this.searchLeafWithKey(key);
        assert (leaf == this.currentNode);
        if (!leaf.isFull()) {
            leaf.insert(key, value);
            return;
        }
        Leaf right = new Leaf(this.nodeCapacity, this.dataType);
        leaf.split(right);
        if (key > leaf.largestKey()) {
            right.insert(key, value);
        } else {
            leaf.insert(key, value);
        }
        leaf.successor = rightLeafPos = this.appendNodeToFile(right);
        this.insertNewLeafIntoTree(leaf.largestKey(), rightLeafPos);
    }

    private void insertNewLeafIntoTree(int insertKey, long insertNodePos) throws IOException {
        while (true) {
            if (this.parents.size() == 0) {
                Node newRootNode = new Node(this.nodeCapacity, insertKey, this.currentNodePosition, insertNodePos);
                this.rootNodePos = this.appendNodeToFile(newRootNode);
                return;
            }
            long parentPos = this.parents.pop();
            Node parentNode = (Node)this.loadNode(parentPos);
            if (!parentNode.isFull()) {
                parentNode.insert(insertKey, insertNodePos);
                return;
            }
            Node parentSplit = new Node(this.nodeCapacity);
            int parentSplitKey = parentNode.split(parentSplit);
            if (insertKey > parentSplitKey) {
                parentSplit.insert(insertKey, insertNodePos);
            } else {
                parentNode.insert(insertKey, insertNodePos);
            }
            insertKey = parentSplitKey;
            insertNodePos = this.appendNodeToFile(parentSplit);
        }
    }

    public Leaf leftmostLeaf() throws IOException {
        BTreeNode node = this.getRootNode();
        while (!node.isLeaf()) {
            Node n = (Node)node;
            long leftmostChild = n.children[0];
            node = this.loadNode(leftmostChild);
        }
        return (Leaf)node;
    }

    public Leaf rightmostLeaf() throws IOException {
        BTreeNode node = this.getRootNode();
        while (!node.isLeaf()) {
            Node n = (Node)node;
            long rightmostChild = n.children[n.numUsed - 1];
            node = this.loadNode(rightmostChild);
        }
        return (Leaf)node;
    }

    public int largestKey() throws IOException {
        return this.rightmostLeaf().largestKey();
    }

    private Leaf searchLeafWithKey(int key) throws IOException {
        BTreeNode node = this.getRootNode();
        this.parents.clear();
        while (!node.isLeaf()) {
            this.parents.push(this.currentNodePosition);
            long childPos = ((Node)node).getChildPosition(key);
            node = this.loadNode(childPos);
        }
        return (Leaf)node;
    }

    public int getInt(int key) throws IOException, ElementNotFoundException {
        Leaf leaf = this.searchLeafWithKey(key);
        return leaf.searchInt(key);
    }

    public float getFloat(int key) throws ElementNotFoundException, IOException {
        Leaf leaf = this.searchLeafWithKey(key);
        return leaf.searchFloat(key);
    }

    public boolean getBoolean(int key) throws IOException, ElementNotFoundException {
        Leaf leaf = this.searchLeafWithKey(key);
        return leaf.searchBoolean(key);
    }

    public long getLong(int key) throws IOException, ElementNotFoundException {
        Leaf leaf = this.searchLeafWithKey(key);
        return leaf.searchLong(key);
    }

    void close() throws IOException {
        if (this.currentNode != null) {
            this.mapCurrentNodeBuffer();
            this.currentNodeBuffer.rewind();
            this.currentNode.writeToByteBuffer(this.currentNodeBuffer);
        }
        ByteBuffer rootNodePosBuffer = ByteBuffer.allocate(8);
        rootNodePosBuffer.putLong(this.rootNodePos);
        rootNodePosBuffer.flip();
        this.fileChannel.position(0L);
        this.fileChannel.write(rootNodePosBuffer);
        this.fileChannel.close();
    }

    public DataType getValueType() {
        return this.dataType;
    }

    public static BTree load(File file) throws IOException {
        return new BTree(file);
    }

    public static BTree create(File file, DataType type, int capacity) throws IOException {
        return new BTree(file, type, capacity);
    }
}

