/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.jdbm;

import de.uni_bremen.st.rcf.exceptions.ValueNotSetException;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.ValueListBinding;
import java.util.List;

public class EntryBinding
extends AbstractEntryBinding {
    public EntryBinding(AbstractRelationBinding relation, int id) {
        super(relation, id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getInt(AbstractAttributeBinding attribute) {
        AttributeBinding ab = (AttributeBinding)attribute;
        Integer value = (Integer)ab.getValue(this.id);
        if (value == null) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setInt(AbstractAttributeBinding attribute, int value) {
        AttributeBinding ab = (AttributeBinding)attribute;
        ab.setValue(this.id, value);
    }

    @Override
    public float getFloat(AbstractAttributeBinding attribute) {
        AttributeBinding ab = (AttributeBinding)attribute;
        Float value = (Float)ab.getValue(this.id);
        if (value == null) {
            throw new ValueNotSetException();
        }
        return value.floatValue();
    }

    @Override
    public void setFloat(AbstractAttributeBinding attribute, float value) {
        AttributeBinding ab = (AttributeBinding)attribute;
        ab.setValue(this.id, Float.valueOf(value));
    }

    @Override
    public String getString(AbstractAttributeBinding attribute) {
        AttributeBinding ab = (AttributeBinding)attribute;
        String value = (String)ab.getValue(this.id);
        if (value == null) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setString(AbstractAttributeBinding attribute, String value) {
        AttributeBinding ab = (AttributeBinding)attribute;
        ab.setValue(this.id, value);
    }

    @Override
    public boolean getBool(AbstractAttributeBinding attribute) {
        AttributeBinding ab = (AttributeBinding)attribute;
        Boolean value = (Boolean)ab.getValue(this.id);
        if (value == null) {
            throw new ValueNotSetException();
        }
        return value;
    }

    @Override
    public void setBool(AbstractAttributeBinding attribute, boolean value) {
        AttributeBinding ab = (AttributeBinding)attribute;
        ab.setValue(this.id, value);
    }

    public <U> AbstractValueListBinding<U> getList(AbstractAttributeBinding attribute) {
        return new ValueListBinding(attribute, this);
    }

    @Override
    public AbstractEntryBinding getEntry(AbstractAttributeBinding attribute) {
        AttributeBinding ab = (AttributeBinding)attribute;
        Integer value = (Integer)ab.getValue(this.id);
        if (value == null) {
            throw new ValueNotSetException();
        }
        AbstractRelationBinding rel = ab.getReferencedRelation();
        return new EntryBinding(rel, value);
    }

    @Override
    public void setEntry(AbstractAttributeBinding attribute, AbstractEntryBinding value) {
        AttributeBinding ab = (AttributeBinding)attribute;
        ab.setValue(this.id, value.getId());
    }

    @Override
    public boolean isSet(AbstractAttributeBinding binding) {
        AttributeBinding ab = (AttributeBinding)binding;
        return ab.isSet(this.id);
    }

    @Override
    public void unset(AbstractAttributeBinding binding) {
        AttributeBinding ab = (AttributeBinding)binding;
        if (ab.isList()) {
            List list = ab.getList(this.id);
            list.clear();
        } else {
            ab.remove(this.id);
        }
    }

    @Override
    public void delete() {
        this.relation.deleteEntry(this.id);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof EntryBinding)) {
            return false;
        }
        EntryBinding o = (EntryBinding)other;
        return this.id == o.id && this.relation == o.relation;
    }
}

