/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.jdbm;

import de.uni_bremen.st.rcf.exceptions.AttributeExistsException;
import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationIteratorBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.EntryBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.IdAttributeBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.JDBMAttributeType;
import de.uni_bremen.st.rcf.persistence.jdbm.RCFBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.RelationIteratorBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class RelationBinding
extends AbstractRelationBinding {
    protected Map<String, AttributeBinding<?>> attributes = new HashMap();
    private int nextId;
    private int nextAttributeId;
    private IdAttributeBinding idAttribute;

    public RelationBinding(RCFBinding rcf, String name, List<String> attributeNames) {
        super(rcf, name);
        if (attributeNames != null) {
            for (String string : attributeNames) {
                this.attributes.put(string, this.createAttributeBinding(string, rcf));
            }
        }
        this.nextAttributeId = 0;
        this.nextId = 0;
        for (AttributeBinding attributeBinding : this.attributes.values()) {
            this.nextAttributeId = Math.max(this.nextAttributeId, attributeBinding.attributeId);
            try {
                this.nextId = Math.max(this.nextId, attributeBinding.lastKey());
            }
            catch (NoSuchElementException e) {}
        }
        if (this.nextAttributeId > 0) {
            ++this.nextAttributeId;
        }
        ++this.nextId;
    }

    private AttributeBinding<?> createAttributeBinding(String attributeName, RCFBinding rcf) {
        String fqname = this.name + "." + attributeName;
        JDBMAttributeType type = rcf.types.get(fqname);
        if (type == null) {
            throw new NoSuchAttributeException();
        }
        if ("id".equals(attributeName)) {
            return this.createIdAttributeBinding(attributeName, fqname, type);
        }
        switch (type.type()) {
            case REFERENCE: 
            case INTEGER: {
                if (type.isList()) {
                    AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), type.isList(), type.isEnum(), type.getEnumValues(), this, type.getReferencedRelationName());
                    SortedMap<Integer, int[]> lv = rcf.db.getTreeMap(fqname);
                    ab.setIntListValues(lv);
                    return ab;
                }
                AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), type.isList(), type.isEnum(), type.getEnumValues(), this, type.getReferencedRelationName());
                SortedMap values = rcf.db.getTreeMap(fqname);
                ab.setValues(values);
                return ab;
            }
            case BOOLEAN: {
                if (type.isList()) {
                    AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), true, false, null, this, null);
                    SortedMap<Integer, boolean[]> lv = rcf.db.createTreeMap(fqname);
                    ab.setBooleanListValues(lv);
                    return ab;
                }
                AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), false, false, null, this, null);
                SortedMap values = rcf.db.getTreeMap(fqname);
                ab.setValues(values);
                return ab;
            }
            case FLOAT: {
                if (type.isList()) {
                    AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), true, false, null, this, null);
                    SortedMap<Integer, float[]> lv = rcf.db.getTreeMap(fqname);
                    ab.setFloatListValues(lv);
                    return ab;
                }
                AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), false, false, null, this, null);
                SortedMap values = rcf.db.getTreeMap(fqname);
                ab.setValues(values);
                return ab;
            }
            case STRING: {
                if (type.isList()) {
                    AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), true, false, null, this, null);
                    SortedMap<Integer, String[]> lv = rcf.db.getTreeMap(fqname);
                    ab.setStringListValues(lv);
                    return ab;
                }
                AttributeBinding ab = new AttributeBinding(attributeName, type.type(), type.getAttributeId(), false, false, null, this, null);
                SortedMap values = rcf.db.getTreeMap(fqname);
                ab.setValues(values);
                return ab;
            }
        }
        throw new RuntimeException("Can't happen. Check the AttributeType enum if you see this.");
    }

    private AttributeBinding<?> createIdAttributeBinding(String attributeName, String fqname, JDBMAttributeType type) {
        assert (this.idAttribute == null);
        this.idAttribute = new IdAttributeBinding(attributeName, type.type(), type.getAttributeId(), type.isList(), type.isEnum(), type.getEnumValues(), this, type.getReferencedRelationName());
        SortedMap values = ((RCFBinding)this.rcf).db.getTreeMap(fqname);
        this.idAttribute.setValues(values);
        return this.idAttribute;
    }

    @Override
    public AbstractEntryBinding getEntry(int id) {
        return new EntryBinding(this, id);
    }

    @Override
    public AbstractEntryBinding createEntry() {
        AttributeBinding<?> idAttribute = this.attributes.get("id");
        int id = this.nextId++;
        idAttribute.setValue(id, id);
        return new EntryBinding(this, id);
    }

    @Override
    public void deleteEntry(int id) {
        for (AttributeBinding<?> ab : this.attributes.values()) {
            if (ab == this.idAttribute) continue;
            ab.remove(id);
        }
        this.idAttribute.remove(id);
    }

    @Override
    public AbstractAttributeBinding getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public List<AbstractAttributeBinding> getAttributes() {
        return new ArrayList<AbstractAttributeBinding>(this.attributes.values());
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public AbstractAttributeBinding addAttribute(String name, AttributeType type, boolean isList, boolean isEnum, AbstractRelationBinding referencedRelation, String ... enumValues) {
        if (this.hasAttribute(name)) {
            throw new AttributeExistsException();
        }
        String fqname = this.name + "." + name;
        JDBMAttributeType jdbmType = new JDBMAttributeType(type, this.nextAttributeId, isList, isEnum, new ArrayList<String>(Arrays.asList(enumValues)), referencedRelation == null ? "" : referencedRelation.getName());
        ++this.nextAttributeId;
        RCFBinding rcf = (RCFBinding)this.rcf;
        rcf.types.put(fqname, jdbmType);
        rcf.addAttributeName(this.name, name);
        rcf.db.createTreeMap(fqname);
        rcf.db.commit();
        AttributeBinding<?> binding = this.createAttributeBinding(name, rcf);
        this.attributes.put(name, binding);
        return binding;
    }

    @Override
    public int size() {
        return this.idAttribute.size();
    }

    @Override
    public AbstractRelationIteratorBinding iterator() {
        return new RelationIteratorBinding(this);
    }

    protected boolean isSetInAttribute(Integer id, Integer attributeId) {
        return this.idAttribute.isSetInAttribute(id, attributeId);
    }

    protected void markSetInAttribute(Integer id, Integer attributeId) {
        this.idAttribute.markSetInAttribute(id, attributeId);
    }

    protected void markUnsetInAttribute(Integer id, Integer attributeId) {
        this.idAttribute.markUnsetInAttribute(id, attributeId);
    }
}

